/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import oracle.ide.net.JarIndex;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.WeakCache;

public final class JarUtil {
    static final String JAR_URL_SEPARATOR = "!/";
    static final String FILE_PROTOCOL_PREFIX = "file:";
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private static final Logger logger = Logger.getLogger(JarUtil.class.getName());
    private static WeakCache<URLKey, ReadWriteLock> _locks;

    private JarUtil() {
    }

    public static String getJarEntry(URL jarURL) {
        String urlPathStr;
        int bangPos;
        if (JarUtil.isJarURL(jarURL) && (bangPos = (urlPathStr = jarURL.getPath()).indexOf(JAR_URL_SEPARATOR)) >= 0) {
            return urlPathStr.substring(bangPos + 2);
        }
        return null;
    }

    public static URL getJarFileURL(URL jarURL) {
        if (JarUtil.isJarURL(jarURL)) {
            try {
                String urlPathStr = jarURL.getPath();
                int bangSlashPos = urlPathStr.indexOf(JAR_URL_SEPARATOR);
                if (bangSlashPos >= 0) {
                    String resultStr = urlPathStr.substring(0, bangSlashPos);
                    return JarUtil.checkAndCreateNewJarFileURL(resultStr);
                }
                if (urlPathStr.endsWith("!")) {
                    String resultStr = urlPathStr.substring(0, urlPathStr.length() - 1);
                    return JarUtil.checkAndCreateNewJarFileURL(resultStr);
                }
                return JarUtil.checkAndCreateNewJarFileURL(urlPathStr);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid JAR URL: " + jarURL, e);
            }
        }
        return jarURL;
    }

    public static URL getJarURL(URL jarURL) {
        if (JarUtil.isJarURL(jarURL)) {
            try {
                String urlPathStr = jarURL.getPath();
                int bangSlashPos = urlPathStr.indexOf(JAR_URL_SEPARATOR);
                if (bangSlashPos >= 0) {
                    String resultStr = urlPathStr.substring(0, bangSlashPos);
                    return URLFactory.newJarURL(JarUtil.checkAndCreateNewJarFileURL(resultStr), "");
                }
                if (urlPathStr.endsWith("!")) {
                    String resultStr = urlPathStr.substring(0, urlPathStr.length() - 1);
                    return URLFactory.newJarURL(JarUtil.checkAndCreateNewJarFileURL(resultStr), "");
                }
                return URLFactory.newJarURL(JarUtil.checkAndCreateNewJarFileURL(urlPathStr), "");
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid JAR URL: " + jarURL, e);
            }
        }
        return jarURL;
    }

    public static Manifest getManifest(URL jarURL) throws IOException {
        return JarUtil.getManifestImpl(JarUtil.getManifestFileURL(jarURL));
    }

    public static Manifest getManifest(File jarFile) throws IOException {
        return JarUtil.getManifestImpl(JarUtil.getManifestFileURL(jarFile));
    }

    public static String getMainClass(File jarFile) throws IOException {
        return JarUtil.getMainClassImpl(JarUtil.getManifestFileURL(jarFile));
    }

    public static String getMainClass(URL jarURL) throws IOException {
        return JarUtil.getMainClassImpl(JarUtil.getManifestFileURL(jarURL));
    }

    public static String getClassPath(File jarFile) throws IOException {
        return JarUtil.getClassPathImpl(JarUtil.getManifestFileURL(jarFile));
    }

    public static String getClassPath(URL jarURL) throws IOException {
        return JarUtil.getClassPathImpl(JarUtil.getManifestFileURL(jarURL));
    }

    public static List<URL> getClassPathURLs(URL jarURL) throws IOException {
        String classpath;
        if (jarURL == null) {
            throw new NullArgumentException("null URL");
        }
        String jarEntry = JarUtil.getJarEntry(jarURL);
        if ("".equals(jarEntry) && (classpath = JarUtil.getClassPath(jarURL)) != null && classpath.length() > 0) {
            URL dirURL = URLFileSystem.getParent(JarUtil.getJarFileURL(jarURL));
            String[] entries = classpath.split("\\s+");
            ArrayList<URL> urls = new ArrayList<URL>(entries.length);
            for (String pathEntry : entries) {
                if (pathEntry.length() == 0) continue;
                if (JarUtil.isArchive(pathEntry)) {
                    URL entryJarFileURL = URLFactory.newURL(dirURL, pathEntry);
                    URL entryURL = URLFactory.newJarURL(entryJarFileURL, null);
                    urls.add(entryURL);
                    continue;
                }
                urls.add(URLFactory.newURL(dirURL, pathEntry));
            }
            return urls;
        }
        return Collections.emptyList();
    }

    public static boolean isJarURL(URL jarURL) {
        return jarURL != null ? jarURL.getProtocol().equals("jar") || jarURL.getProtocol().equals("wsjar") : false;
    }

    public static JarIndex getJarIndex(URL jarURL) throws IOException {
        return JarIndex.getInstance(JarUtil.getJarFileURL(jarURL));
    }

    @Deprecated
    public static JarIndex getJarIndex(URL jarURL, boolean full) throws IOException {
        return JarUtil.getJarIndex(jarURL);
    }

    public static void releaseJarIndex(URL jarURL) {
        JarIndex.uncache(JarUtil.getJarFileURL(jarURL));
    }

    public static boolean isArchive(String pathname) {
        int offset = pathname.length() - 4;
        if (pathname.regionMatches(true, offset, ".jar", 0, 4) || pathname.regionMatches(true, offset, ".zip", 0, 4)) {
            return true;
        }
        offset = pathname.length() - 5;
        return pathname.regionMatches(true, offset, ".jmod", 0, 5);
    }

    public static synchronized ReadWriteLock getLock(URL url) {
        URLKey key = URLKey.getInstance(JarUtil.getJarFileURL(url));
        ReadWriteLock lock = null;
        if (_locks == null) {
            _locks = new WeakCache();
        } else {
            lock = _locks.get(key);
        }
        if (lock == null) {
            lock = new ReadWriteLock(key.toString());
            _locks.put(key.intern(), lock);
        }
        return lock;
    }

    private static URL getManifestFileURL(File jarFile) {
        return URLFactory.newJarURL(jarFile, MANIFEST_FILE);
    }

    private static URL getManifestFileURL(URL jarURL) {
        return URLFactory.newJarURL(jarURL, MANIFEST_FILE);
    }

    private static String getMainClassImpl(URL manifestFileURL) throws IOException {
        return JarUtil.getManifestMainAttribute(manifestFileURL, true);
    }

    private static String getClassPathImpl(URL manifestFileURL) throws IOException {
        return JarUtil.getManifestMainAttribute(manifestFileURL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifestImpl(URL manifestFileURL) throws IOException {
        InputStream manifestIn = null;
        try {
            manifestIn = URLFileSystem.openInputStream(manifestFileURL);
            Manifest manifest = new Manifest(manifestIn);
            return manifest;
        }
        finally {
            if (manifestIn != null) {
                try {
                    manifestIn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String getManifestMainAttribute(URL manifestFileURL, boolean getMainClass) throws IOException {
        return JarUtil.getJarIndex(manifestFileURL).getManifestMainAttribute(getMainClass);
    }

    static URL newJarFileURLImpl(String urlStr) {
        try {
            return JarUtil.checkAndCreateNewJarFileURL(urlStr);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static URL checkAndCreateNewJarFileURL(String urlStr) throws MalformedURLException {
        if (((String)urlStr).indexOf(":") == -1) {
            logger.warning("Missing protocol prefix in JAR url: " + (String)urlStr + ". The prefix file: has been added to the URL.");
            urlStr = FILE_PROTOCOL_PREFIX + (String)urlStr;
        }
        URL url = null;
        try {
            url = new URL((String)urlStr);
        }
        catch (MalformedURLException ex) {
            if (PlatformUtils.isWindows()) {
                String newUrlStr = FILE_PROTOCOL_PREFIX + (String)urlStr;
                try {
                    url = new URL(newUrlStr);
                }
                catch (Exception ex2) {
                    throw ex;
                }
                logger.warning("Missing protocol prefix in JAR url: " + (String)urlStr + ". The prefix file: has been added to the URL.");
            }
            throw ex;
        }
        String authority = url.getAuthority();
        if ("file".equals(url.getProtocol()) && authority != null && !authority.isEmpty()) {
            url = new URL("file", null, -1, URLFileSystem.getPath(url));
        }
        return url;
    }
}

