/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class URLStreamHandlerFactoryQueue
implements URLStreamHandlerFactory {
    private static final URLStreamHandlerFactory _factory = new URLStreamHandlerFactoryQueue();
    private static final Map<String, List<URLStreamHandlerFactory>> _protocolMap = new HashMap<String, List<URLStreamHandlerFactory>>();
    private static final List<URLStreamHandlerFactory> _oldStyleFactories = new ArrayList<URLStreamHandlerFactory>();

    private URLStreamHandlerFactoryQueue() {
    }

    public static URLStreamHandlerFactory getInstance() {
        return _factory;
    }

    public static void addFactory(URLStreamHandlerFactory factory) {
        if (factory != null) {
            URLStreamHandlerFactoryQueue.addFactoryImpl(null, factory);
        }
    }

    public static void addFactory(String protocol, URLStreamHandlerFactory factory) {
        URLStreamHandlerFactoryQueue.addFactoryImpl(protocol, factory);
    }

    public static void addHandler(final String handlerProtocol, final URLStreamHandler handler) {
        URLStreamHandlerFactory factory = new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if (handlerProtocol.equals(protocol)) {
                    return handler;
                }
                return null;
            }
        };
        URLStreamHandlerFactoryQueue.addFactoryImpl(handlerProtocol, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        Map<String, List<URLStreamHandlerFactory>> map = _protocolMap;
        synchronized (map) {
            List<URLStreamHandlerFactory> streamHandlers = _protocolMap.get(protocol);
            if (streamHandlers != null) {
                for (URLStreamHandlerFactory factory : streamHandlers) {
                    URLStreamHandler handler = factory.createURLStreamHandler(protocol);
                    if (handler == null) continue;
                    return handler;
                }
            } else {
                for (URLStreamHandlerFactory factory : _oldStyleFactories) {
                    URLStreamHandler handler = factory.createURLStreamHandler(protocol);
                    if (handler == null) continue;
                    return handler;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFactoryImpl(String protocol, URLStreamHandlerFactory factory) {
        Map<String, List<URLStreamHandlerFactory>> map = _protocolMap;
        synchronized (map) {
            if (protocol != null) {
                List<URLStreamHandlerFactory> list = _protocolMap.get(protocol);
                if (list == null) {
                    list = new ArrayList<URLStreamHandlerFactory>();
                    _protocolMap.put(protocol, list);
                }
                list.add(factory);
            } else {
                _oldStyleFactories.add(factory);
            }
        }
    }

    static {
        if (!"OSGi".equalsIgnoreCase(System.getProperty("oracle.ide.classload.layer"))) {
            try {
                URL.setURLStreamHandlerFactory(_factory);
            }
            catch (Error e) {
                System.err.println("Warning: Unable to set URLStreamHandlerFactory");
            }
        } else {
            System.err.println(URLStreamHandlerFactoryQueue.class.getName() + " was classloaded in OSGi mode. URL stream handler registrations will not work properly.");
            Thread.dumpStack();
        }
    }
}

