/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.ButtonMenu;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdevimpl.style.preferences.CodingStylePreferences;
import oracle.jdevimpl.style.profile.CodingStylePreviewPanel;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.CodingStyleProfilePanel;
import oracle.jdevimpl.style.profile.CodingStyleProfiles;
import oracle.jdevimpl.style.profile.ProfileModel;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStylePreferencesPanel
extends DefaultTraversablePanel
implements ItemListener,
ActionListener,
ApplyListener {
    private JComboBox profileList;
    private ProfileModel model;
    private JButton editButton;
    private JMenuItem deleteItem;
    private JMenuItem duplicateItem;
    private JMenuItem importItem;
    private JMenuItem exportItem;
    private JMenuItem restoreItem;
    private CodingStylePreviewPanel preview;
    private URL lastImportExportURL;
    private CodingStylePreferences preferences;
    private static final String PREFERENCES_HELP_TOPIC = "f1_ideidesetcodingstyle_html";
    private static final String EDIT_PROFILE_HELP_TOPIC = "f1_ideidesetsavecodingstyle_html";
    private static final String EXPORT_HELP_TOPIC = "f1_ideidesetexportcodingstyle_html";
    private static final String IMPORT_HELP_TOPIC = "f1_ideidesetimportcodingstyle_html";
    private static final String SAMPLE;

    public CodingStylePreferencesPanel() {
        this.setHelpID(PREFERENCES_HELP_TOPIC);
        this.model = new ProfileModel();
        this.profileList = new JComboBox(this.model);
        this.profileList.setRenderer(new ProfileRenderer());
        this.profileList.setEditable(false);
        this.profileList.addItemListener(this);
        JLabel profileLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)profileLabel, (Component)this.profileList, (String)CodingStyleArb.getString(1));
        this.editButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)CodingStyleArb.getString(2));
        this.editButton.addActionListener(this);
        this.duplicateItem = new JMenuItem();
        ResourceUtils.resButton((AbstractButton)this.duplicateItem, (String)CodingStyleArb.getString(4));
        this.duplicateItem.addActionListener(this);
        this.deleteItem = new JMenuItem();
        ResourceUtils.resButton((AbstractButton)this.deleteItem, (String)CodingStyleArb.getString(5));
        this.deleteItem.addActionListener(this);
        this.importItem = new JMenuItem();
        ResourceUtils.resButton((AbstractButton)this.importItem, (String)CodingStyleArb.getString(6));
        this.importItem.addActionListener(this);
        this.exportItem = new JMenuItem();
        ResourceUtils.resButton((AbstractButton)this.exportItem, (String)CodingStyleArb.getString(7));
        this.exportItem.addActionListener(this);
        this.restoreItem = new JMenuItem();
        ResourceUtils.resButton((AbstractButton)this.restoreItem, (String)CodingStyleArb.getString(8));
        this.restoreItem.addActionListener(this);
        this.preview = new CodingStylePreviewPanel();
        this.preview.setSampleCode(SAMPLE);
        JLabel previewLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)previewLabel, (Component)this.preview.getEditor(), (String)CodingStyleArb.getString(9));
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        items.add(this.duplicateItem);
        items.add(this.deleteItem);
        items.add(this.importItem);
        items.add(this.exportItem);
        items.add(this.restoreItem);
        String moreString = CodingStyleArb.getString(3);
        JToggleButton moreActionsButton = ButtonMenu.createButtonMenu((String)StringUtils.stripMnemonic((String)moreString), null, items);
        moreActionsButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)moreString));
        this.setLayout((LayoutManager)new MigLayout("ins 0 0 0 0, nogrid, fillx, gapy 4"));
        this.add(profileLabel, "");
        this.add(this.profileList, "newline");
        this.add(this.editButton, "");
        this.add(moreActionsButton);
        this.add(previewLabel, "newline, gaptop 10");
        this.add(this.preview, "newline, grow");
    }

    public void onEntry(TraversableContext tc) {
        this.preferences = this.getCodingStylePreferences(tc);
        CodingStyleProfile profile = null;
        String name = this.preferences.getActiveProfile();
        boolean missingProfile = name != null && !this.model.contains(name);
        Assert.println((boolean)missingProfile, (String)("Coding Style profile '" + name + "' not found."));
        profile = name == null || missingProfile ? this.model.getDefaultProfile() : this.model.getProfile(name);
        this.model.setSelectedItem((Object)profile);
        this.updatePreview();
        this.updateButtons();
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        CodingStylePreferences preferences = this.getCodingStylePreferences(tc);
        CodingStyleProfile profile = this.getSelectedProfile();
        if (profile != null) {
            preferences.setActiveProfile(this.getSelectedProfile().getName());
        } else {
            preferences.setActiveProfile(null);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.updatePreview();
            this.updateButtons();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.editButton) {
            this.editProfile();
        } else if (source == this.duplicateItem) {
            this.saveProfile();
        } else if (source == this.deleteItem) {
            this.deleteProfile();
        } else if (source == this.exportItem) {
            this.exportProfile();
        } else if (source == this.importItem) {
            this.importProfile();
        } else if (source == this.restoreItem) {
            this.restoreProfile();
        }
    }

    public void apply(ApplyEvent e) {
        HashMap<String, CodingStyleProfile> map = new HashMap<String, CodingStyleProfile>();
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            CodingStyleProfile profile = (CodingStyleProfile)((Object)this.model.getElementAt(i));
            String profileName = profile.getName();
            map.put(profileName, profile);
        }
        TraversableContext tc = e.getTraversableContext();
        PropertyStorage prefs = tc.getPropertyStorage();
        CodingStyleProfiles tcProfiles = CodingStyleProfiles.getInstance(prefs);
        tcProfiles.setProfileMap(map);
        this.preview.dispose();
    }

    public void cancel(ApplyEvent e) {
        this.model.revert();
        this.preview.dispose();
    }

    private void updatePreview() {
        CodingStyleProfile profile = this.getSelectedProfile();
        this.preview.setProfile(profile);
        this.preview.update();
    }

    private void updateButtons() {
        CodingStyleProfile profile = this.getSelectedProfile();
        boolean enabled = profile != null;
        this.deleteItem.setEnabled(enabled && !this.model.isDefaultProfile(profile));
        this.restoreItem.setEnabled(enabled && this.model.canRestore(profile));
        this.editButton.setEnabled(enabled);
        this.exportItem.setEnabled(enabled);
        this.duplicateItem.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editProfile() {
        CodingStyleProfilePanel panel = new CodingStyleProfilePanel();
        CodingStyleProfile profile = this.getSelectedProfile();
        CodingStyleProfile profileCopy = new CodingStyleProfile();
        profile.copyTo((Object)profileCopy);
        Namespace data = new Namespace();
        data.put("Profile", (Object)profileCopy);
        MessageFormat format = new MessageFormat(CodingStyleArb.getString(26));
        TDialogLauncher launcher = new TDialogLauncher((Component)((Object)this), format.format(new Object[]{profileCopy.getName()}), (Traversable)panel, data, (DialogRunnerCallback)new SizeKeeperCallback("coding.style.profile"));
        launcher.setInitialSize(800, 600);
        try {
            if (launcher.showDialog() && ModelUtil.areDifferent((Object)((Object)profile), (Object)((Object)profileCopy))) {
                profileCopy.copyTo((Object)profile);
                this.model.setModified(profile);
                this.updatePreview();
                this.updateButtons();
            }
        }
        finally {
            launcher.dispose();
        }
    }

    private void saveProfile() {
        CodingStyleProfile profile = this.getSelectedProfile();
        String oldName = profile.getName();
        String name = this.getProfileName(oldName);
        if (name != null && (name.equalsIgnoreCase(oldName) || !this.model.contains(name) || this.confirmSaveAsOverwrite(name))) {
            CodingStyleProfile copy = this.model.copy(profile, name);
            this.model.setSelectedItem((Object)copy);
            this.model.revert(profile);
        }
    }

    private boolean confirmSaveAsOverwrite(String name) {
        String title;
        String message = CodingStyleArb.format(19, name);
        int result = JOptionPane.showConfirmDialog((Component)((Object)this), message, title = CodingStyleArb.getString(20), 2);
        return result == 0;
    }

    private String getProfileName(String oldName) {
        JTextField nameField = new JTextField(oldName, 32);
        nameField.selectAll();
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)nameField, (String)CodingStyleArb.getString(23));
        JPanel content = new JPanel(new GridBagLayout());
        HelpUtils.setHelpID((JComponent)content, (String)EDIT_PROFILE_HELP_TOPIC);
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.right = 10;
        gbc.gridheight = 0;
        gbc.anchor = 17;
        content.add((Component)label, gbc);
        gbc.gridwidth = 0;
        gbc.insets.right = 0;
        content.add((Component)nameField, gbc);
        JEWTDialog dialog = JEWTDialog.createDialog((Component)((Object)this), (String)CodingStyleArb.getString(24), (int)7);
        nameField.getDocument().addDocumentListener(new SaveAsListener(dialog));
        dialog.setContent((Component)content);
        dialog.setOKButtonText(CodingStyleArb.getString(25));
        return dialog.runDialog() ? nameField.getText().trim() : null;
    }

    private void deleteProfile() {
        CodingStyleProfile profile = this.getSelectedProfile();
        if (this.confirmDelete(profile)) {
            this.model.remove(profile);
        }
    }

    private boolean confirmDelete(CodingStyleProfile profile) {
        String title;
        String message = CodingStyleArb.format(98, profile.getName());
        int result = JOptionPane.showConfirmDialog((Component)((Object)this), message, title = CodingStyleArb.getString(99), 2);
        return result == 0;
    }

    private void exportProfile() {
        ExportURLChooser chooser = new ExportURLChooser();
        DialogUtil.initURLChooser((URLChooser)chooser, null);
        if (this.lastImportExportURL != null) {
            chooser.setSelectedURL(this.lastImportExportURL);
        } else {
            URL url = this.getUserHomeDirectory();
            if (url != null) {
                chooser.setSelectedURL(url);
            }
        }
        chooser.clearChooseableURLFilters();
        DefaultURLFilter filter = new DefaultURLFilter(CodingStyleArb.getString(21), ".xml");
        chooser.addChooseableURLFilter((URLFilter)filter);
        chooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        chooser.setURLFilter((URLFilter)filter);
        int result = chooser.showSaveDialog((Component)((Object)this), CodingStyleArb.getString(10));
        if (result == 0) {
            URL url = chooser.getSelectedURL();
            if ("".equals(URLFileSystem.getSuffix((URL)url))) {
                url = URLFileSystem.convertSuffix((URL)url, (String)"", (String)".xml");
            }
            try {
                this.getSelectedProfile().exportTo(url);
                this.lastImportExportURL = URLFileSystem.getParent((URL)url);
            }
            catch (Exception e) {
                String message = CodingStyleArb.format(15, URLFileSystem.getPlatformPathName((URL)url), e.toString());
                String title = CodingStyleArb.getString(14);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
            }
        }
    }

    private void importProfile() {
        URLChooser chooser = DialogUtil.newURLChooser();
        chooser.clearChooseableURLFilters();
        DefaultURLFilter filter = new DefaultURLFilter(CodingStyleArb.getString(21), ".xml");
        chooser.addChooseableURLFilter((URLFilter)filter);
        chooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        chooser.setURLFilter((URLFilter)filter);
        chooser.setHelpID(IMPORT_HELP_TOPIC);
        if (this.lastImportExportURL != null) {
            chooser.setSelectedURL(this.lastImportExportURL);
        } else {
            URL url = this.getUserHomeDirectory();
            if (url != null) {
                chooser.setSelectedURL(url);
            }
        }
        int result = chooser.showOpenDialog((Component)((Object)this), CodingStyleArb.getString(16));
        if (result == 0) {
            URL url = chooser.getSelectedURL();
            try {
                CodingStyleProfile profile = CodingStyleProfile.importFrom(url);
                String name = profile.getName();
                if (name != null) {
                    if (!this.model.contains(name) || this.confirmImportOverwrite(name)) {
                        this.model.add(profile);
                        this.model.setSelectedItem((Object)profile);
                        this.lastImportExportURL = URLFileSystem.getParent((URL)url);
                    }
                } else {
                    this.showInvalidProfileDialog(url);
                }
            }
            catch (IOException ioe) {
                this.showInvalidProfileDialog(url);
            }
        }
    }

    private void showInvalidProfileDialog(URL url) {
        String message = CodingStyleArb.format(172, URLFileSystem.getPlatformPathName((URL)url));
        String title = CodingStyleArb.getString(171);
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
    }

    private boolean confirmImportOverwrite(String name) {
        String title;
        String message = CodingStyleArb.format(17, name);
        int result = JOptionPane.showConfirmDialog((Component)((Object)this), message, title = CodingStyleArb.getString(18), 2);
        return result == 0;
    }

    private void restoreProfile() {
        this.model.restore(this.getSelectedProfile());
        this.updatePreview();
        this.updateButtons();
    }

    private URL getUserHomeDirectory() {
        URL url = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        return URLFileSystem.exists((URL)url) ? url : null;
    }

    private CodingStyleProfile getSelectedProfile() {
        return (CodingStyleProfile)((Object)this.model.getSelectedItem());
    }

    private CodingStylePreferences getCodingStylePreferences(TraversableContext tc) {
        return CodingStylePreferences.getInstance(tc.getPropertyStorage());
    }

    static {
        StringBuffer buffer = new StringBuffer();
        buffer.append("package mypackage;");
        buffer.append("${import}");
        buffer.append("public class Class1");
        buffer.append("{");
        buffer.append("private int ${field field} = 1 + 2 + 3;");
        buffer.append("public Class1()");
        buffer.append("{");
        buffer.append("}");
        buffer.append("public static void main(");
        buffer.append("String[] ${parameter args})");
        buffer.append("{");
        buffer.append("Class1 ${local class1} = new Class1();");
        buffer.append("if ( ${local class1}.toString() != null )");
        buffer.append("{");
        buffer.append("System.out.println( 1 );");
        buffer.append("}");
        buffer.append("else");
        buffer.append("{");
        buffer.append("}");
        buffer.append("switch (${parameter args}.length)");
        buffer.append("{");
        buffer.append("case 0:");
        buffer.append("break;");
        buffer.append("default:");
        buffer.append("break;");
        buffer.append("}");
        buffer.append("}");
        buffer.append("}");
        SAMPLE = buffer.toString();
    }

    private class ProfileRenderer
    extends BasicComboBoxRenderer {
        private ProfileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof CodingStyleProfile) {
                CodingStyleProfile profile = (CodingStyleProfile)((Object)value);
                value = profile.isModified() ? CodingStyleArb.format(22, profile.getName()) : profile.getName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class SaveAsListener
    implements DocumentListener {
        private JEWTDialog dialog;

        public SaveAsListener(JEWTDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e.getDocument());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e.getDocument());
        }

        private void update(Document document) {
            String text;
            try {
                text = document.getText(0, document.getLength()).trim();
            }
            catch (BadLocationException e1) {
                throw new UnexpectedExceptionError((Throwable)e1);
            }
            this.dialog.setOKButtonEnabled(text.length() > 0);
        }
    }

    private class ExportURLChooser
    extends URLChooser {
        public ExportURLChooser() {
            this.setHelpID(CodingStylePreferencesPanel.EXPORT_HELP_TOPIC);
        }

        public boolean approveSelection() {
            return super.approveSelection() && this.checkExistingFile() && this.checkReadOnlyFile();
        }

        private boolean checkExistingFile() {
            URL url = this.getSelectedURL();
            if (URLFileSystem.exists((URL)url)) {
                String message = CodingStyleArb.format(12, URLFileSystem.getPlatformPathName((URL)url));
                String title = CodingStyleArb.getString(11);
                int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), message, title, 2);
                return result == 0;
            }
            return true;
        }

        private boolean checkReadOnlyFile() {
            URL url = this.getSelectedURL();
            if (URLFileSystem.isReadOnly((URL)url)) {
                String message = CodingStyleArb.format(13, URLFileSystem.getPlatformPathName((URL)url));
                String title = CodingStyleArb.getString(14);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
                return false;
            }
            return true;
        }
    }
}

