/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.pushdpopddirs.commands.popd;

import java.io.IOException;
import java.sql.Connection;
import java.util.Optional;
import oracle.dbtools.extension.pushdpopddirs.service.DirectoryManager;
import oracle.dbtools.extension.pushdpopddirs.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class PopdCommand
extends CommandListener
implements IHelp {
    private final String POPD_CMD = "POPD";

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!this.matches(cmd.getSql())) {
            return false;
        }
        String command = this.handleMinusCase(cmd);
        Type type = this.getParserType();
        Parser parser = new Parser(type, ctx.getEnvironment());
        Optional parsedCommand = parser.parse(command, arg_0 -> ((ScriptRunnerContext)ctx).writeln(arg_0));
        if (parsedCommand.isPresent()) {
            String navParameter = (String)((ParsedCommand)parsedCommand.get()).getParameterValue((Id)Symbol.NAV);
            DirectoryManager directoryManager = (DirectoryManager)ctx.getService(DirectoryManager.class);
            try {
                if (navParameter == null) {
                    directoryManager.popDirectory();
                    FileUtils.changeDirectory(ctx, directoryManager.getCurrentDirectory());
                    directoryManager.printDirectories(ctx, directoryManager.getDirectories());
                } else {
                    this.handleCommandWithParams(navParameter, directoryManager, ctx);
                }
            }
            catch (IOException e) {
                ctx.writeln(e.getMessage());
            }
        }
        return true;
    }

    private void handleCommandWithParams(String navParameter, DirectoryManager directoryManager, ScriptRunnerContext ctx) {
        String navigationSign = navParameter.substring(0, 1);
        String navigationValue = navParameter.substring(1);
        if (navigationSign.equals("+") && this.isNumber(navigationValue)) {
            directoryManager.navigateStack(ctx, directoryManager, navParameter, directoryManager::popPlus);
        } else if (navigationSign.equals("_") && this.isNumber(navigationValue)) {
            directoryManager.navigateStack(ctx, directoryManager, navParameter, directoryManager::popMinest);
        } else {
            ctx.writeln("popd: parameter not recognized");
        }
    }

    private boolean isNumber(String navigationValue) {
        return navigationValue.chars().allMatch(Character::isDigit);
    }

    private String handleMinusCase(ISQLCommand command) {
        String trimmedCmd = command.getSql().trim();
        if (trimmedCmd.length() > "POPD".length()) {
            int firstSpaceIndex = 5;
            String parameter = trimmedCmd.substring(5).trim();
            boolean minusIndex = true;
            if (parameter.startsWith("-")) {
                command.setSql("POPD _" + parameter.substring(1));
            }
        }
        return command.getSql();
    }

    public Type createType() {
        return Factory.type((Id)Symbol.POPD).add(Factory.parameter((Id)Symbol.NAV).build()).build();
    }

    public Type getParserType() {
        return this.createType();
    }

    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx, this.createType()).get(pagePath);
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx, Type type) {
        return new HelpPagesBuilder(ctx.getEnvironment()).addHelpContainerFor((Object)this).addPages((Iterable)new CommandPageAssemblers(type, new Type[0])).build();
    }

    private boolean matches(String line) {
        String command;
        String trimmed = line.trim();
        if (trimmed.equalsIgnoreCase(command = this.getCommand())) {
            return true;
        }
        int firstSpace = trimmed.indexOf(" ");
        if (firstSpace > 0) {
            String firstWord = line.substring(0, firstSpace);
            return firstWord.equalsIgnoreCase(command);
        }
        return false;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String getCommand() {
        return "POPD";
    }

    public boolean isSqlPlus() {
        return false;
    }

    public static enum Symbol implements Id
    {
        NAV,
        POPD;

    }
}

