/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.NavigableContext;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;
import oracle.jdevimpl.xml.NDRPanel;

public class NDRElementListListener
implements ElementListListener {
    private final NDRPanel _ndrPanel;

    NDRElementListListener(NDRPanel ndrPanel) {
        this._ndrPanel = ndrPanel;
    }

    private TraversableContext getTraversableContext() {
        return this._ndrPanel.getTraversableContext();
    }

    public void elementsAdded(ElementListEvent e) {
        if (!this._ndrPanel.isMoveInProgress()) {
            int newIndex = e.getStartIndex();
            TraversableContext tc = this.getTraversableContext();
            JTree tree = (JTree)tc.getDesignTimeObject("MDDPanel.CURRENT_TREE1");
            DefaultMutableTreeNode treeNode = this._ndrPanel.getElementListTreeNode(tc);
            NavigableContext nc = tc.newNavigableContext();
            ElementList elementList = this._ndrPanel.getCreateElementList(tc);
            Object newData = elementList.get(newIndex);
            DefaultMutableTreeNode newTreeNode = this._ndrPanel.createTreeNode(nc, newData);
            treeNode.add(newTreeNode);
            DefaultTreeModel treeModel = (DefaultTreeModel)tc.getDesignTimeObject("MDDPanel.CURRENT_TREE1_MODEL");
            treeModel.nodesWereInserted(treeNode, new int[]{newIndex});
            if (this._ndrPanel.selectNewChildren()) {
                TreePath newNodePath = new TreePath(newTreeNode.getPath());
                tree.setSelectionPath(newNodePath);
                tree.expandPath(newNodePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementsRemoved(ElementListEvent e) {
        if (!this._ndrPanel.isMoveInProgress()) {
            int startIndex = e.getStartIndex();
            int endIndex = e.getEndIndex();
            TraversableContext tc = this.getTraversableContext();
            JTree tree = (JTree)tc.getDesignTimeObject("MDDPanel.CURRENT_TREE1");
            int selectionRow = tree.getSelectionRows()[0];
            DefaultMutableTreeNode parentNode = this._ndrPanel.getElementListTreeNode(tc);
            int count = endIndex - startIndex + 1;
            int[] removed = new int[count];
            Object[] remObjs = new Object[count];
            int i = endIndex;
            while (i >= startIndex) {
                remObjs[--count] = parentNode.getChildAt(i);
                parentNode.remove(i);
                removed[count] = i--;
            }
            DefaultTreeModel treeModel = (DefaultTreeModel)tc.getDesignTimeObject("MDDPanel.CURRENT_TREE1_MODEL");
            treeModel.nodesWereRemoved(parentNode, removed, remObjs);
            MDDPanel mddPanel = (MDDPanel)tc.getDesignTimeObject("navigable-ui-container");
            boolean selectionDelay = NDRPanel.enableSelectionDelay(mddPanel, false);
            try {
                tree.setSelectionRow(selectionRow < tree.getRowCount() ? selectionRow : selectionRow - 1);
            }
            finally {
                NDRPanel.enableSelectionDelay(mddPanel, selectionDelay);
            }
        }
    }

    public void elementsChanged(ElementListEvent e) {
    }
}

