/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.controls.checkboxlist.CheckBoxList;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.dialogs.JDevDialogHeader;
import oracle.jdeveloper.resource.ModelArb;

public class FilesPatternFilterPanel
extends JPanel
implements ActionListener,
CheckBoxListItemStateListener,
DocumentListener {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel lblFileTypes = new JLabel();
    private JRadioButton rbShow = new JRadioButton();
    private JRadioButton rbHide = new JRadioButton();
    protected CheckBoxListModel fileListModel = new CheckBoxListModel();
    private CheckBoxList fileList = new CheckBoxList();
    private JScrollPane listScroller = new JScrollPane();
    private JCheckBox checkSubdirectories = new JCheckBox();
    private JPanel buttonPanel = new JPanel();
    private JButton btnSelectAll = new JButton();
    private JButton btnDeselectAll = new JButton();
    private JLabel lblMoreFilters = new JLabel();
    private JLabel lblMoreFiltersHint = new JLabel();
    private JTextField txtMoreFilters = new JTextField();
    private JDevDialogHeader dlgHeader;
    private JEWTDialog dialog;
    private static boolean recurse = true;
    private static boolean show = false;
    private static final String HELP_TOPIC = "f1_idedaddfilefilter_html";

    public FilesPatternFilterPanel() {
        try {
            this.initializeUI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean showDialog(Component parent, PatternFilters filters, String selectedDir) {
        String directory = selectedDir;
        if (selectedDir.endsWith("/")) {
            directory = selectedDir.substring(0, selectedDir.length() - 1);
        } else if (directory.length() == 0) {
            directory = ModelArb.getString((int)78);
        }
        ResourceUtils.resButton((AbstractButton)this.checkSubdirectories, (String)ModelArb.format((int)89, (Object)directory));
        this.initFileListModel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, HELP_TOPIC);
        this.dialog = DialogUtil.createJEWTDialogOwnedBy((Component)parent);
        if (this.dialog == null) {
            return false;
        }
        this.dialog.setContent((Component)this);
        this.dialog.setOKButtonEnabled(false);
        this.dialog.setInitialFocus((Component)this.fileList);
        this.dialog.setTitle(ModelArb.getString((int)79));
        this.dialog.setButtonMask(7);
        this.dialog.setResizable(true);
        this.dialog.pack();
        if (this.dialog.runDialog()) {
            this.commitTo(filters, selectedDir);
            return true;
        }
        this.dialog.dispose();
        this.dialog = null;
        return false;
    }

    public void hideCheckSubdirectories() {
        this.remove(this.checkSubdirectories);
    }

    private void commitTo(PatternFilters filters, String selectedDirectory) {
        String filterText;
        String pattern;
        String token;
        String RECURSE_PATTERN = "**/";
        if (((String)selectedDirectory).length() > 0 && !((String)selectedDirectory).endsWith("/")) {
            selectedDirectory = (String)selectedDirectory + "/";
        }
        boolean applyRecursively = this.checkSubdirectories.isSelected();
        boolean include = this.rbShow.isSelected();
        List selection = this.fileListModel.getSelectionList();
        if (selection != null) {
            for (TextPair textPair : selection) {
                token = textPair.toString();
                String string = pattern = applyRecursively ? (String)selectedDirectory + RECURSE_PATTERN + token : (String)selectedDirectory + token;
                if (include) {
                    filters.addInclude(pattern);
                    continue;
                }
                filters.addExclude(pattern);
            }
        }
        if ((filterText = this.txtMoreFilters.getText()).length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(filterText, ";");
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                String string = pattern = recurse ? (String)selectedDirectory + RECURSE_PATTERN + token : (String)selectedDirectory + token;
                if (include) {
                    filters.addInclude(pattern);
                    continue;
                }
                filters.addExclude(pattern);
            }
        }
        show = include;
        recurse = applyRecursively;
    }

    private JDevDialogHeader getDialogHeader() {
        if (this.dlgHeader == null) {
            this.dlgHeader = new JDevDialogHeader();
            this.dlgHeader.setHeaderTitle(ModelArb.getString((int)80));
            this.dlgHeader.setHeaderDescription(ModelArb.getString((int)81));
        }
        return this.dlgHeader;
    }

    private void initializeUI() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.rbShow, (String)ModelArb.getString((int)83));
        ResourceUtils.resButton((AbstractButton)this.rbHide, (String)ModelArb.getString((int)84));
        ResourceUtils.resLabel((JLabel)this.lblFileTypes, (Component)this.fileList, (String)ModelArb.getString((int)82));
        ResourceUtils.resLabel((JLabel)this.lblMoreFilters, (Component)this.txtMoreFilters, (String)ModelArb.getString((int)85));
        ResourceUtils.resLabel((JLabel)this.lblMoreFiltersHint, (Component)this.txtMoreFilters, (String)ModelArb.getString((int)86));
        ResourceUtils.resButton((AbstractButton)this.checkSubdirectories, (String)ModelArb.getString((int)75));
        ResourceUtils.resButton((AbstractButton)this.btnSelectAll, (String)ModelArb.getString((int)87));
        ResourceUtils.resButton((AbstractButton)this.btnDeselectAll, (String)ModelArb.getString((int)88));
        this.btnSelectAll.addActionListener(this);
        this.btnDeselectAll.addActionListener(this);
        this.txtMoreFilters.getDocument().addDocumentListener(this);
        ButtonGroup includeGroup = new ButtonGroup();
        includeGroup.add(this.rbShow);
        includeGroup.add(this.rbHide);
        if (show) {
            this.rbShow.setSelected(true);
        } else {
            this.rbHide.setSelected(true);
        }
        this.checkSubdirectories.setSelected(recurse);
        this.fileList.setModel((ListModel)this.fileListModel);
        this.listScroller.getViewport().add((Component)this.fileList, null);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 8, 8));
        this.buttonPanel.add(this.btnSelectAll);
        this.buttonPanel.add(this.btnDeselectAll);
        this.setLayout(this.gridBagLayout1);
        int Y = -1;
        int INDENT = 10;
        Insets emptyInsets = new Insets(0, 0, 0, 5);
        Insets header = new Insets(10, 0, 0, 0);
        Insets inset = new Insets(3, 0, 0, 0);
        Insets buttonPanelInsets = new Insets(8, 30, 0, 0);
        this.add((Component)this.rbShow, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, emptyInsets, 0, 0));
        this.add((Component)this.rbHide, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, emptyInsets, 0, 0));
        this.add((Component)this.lblFileTypes, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, header, 0, 0));
        this.add((Component)this.listScroller, new GridBagConstraints(1, -1, 2, 1, 1.0, 1.0, 17, 1, inset, 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(1, -1, 2, 1, 0.0, 0.0, 13, 0, buttonPanelInsets, 0, 0));
        this.add((Component)this.lblMoreFilters, new GridBagConstraints(1, -1, 2, 1, 0.0, 0.0, 17, 0, header, 0, 0));
        this.add((Component)this.txtMoreFilters, new GridBagConstraints(1, -1, 2, 1, 0.0, 0.0, 17, 2, inset, 0, 0));
        this.add((Component)this.lblMoreFiltersHint, new GridBagConstraints(1, -1, 2, 1, 0.0, 0.0, 17, 2, inset, 0, 0));
        this.add((Component)this.checkSubdirectories, new GridBagConstraints(1, -1, 2, 1, 0.0, 0.0, 17, 0, header, 0, 0));
    }

    protected void setShow(boolean show) {
        this.rbHide.setSelected(!show);
        this.rbShow.setSelected(show);
    }

    protected void setShowButtonLabel(String label) {
        ResourceUtils.resButton((AbstractButton)this.rbShow, (String)label);
    }

    protected void setHideButtonLabel(String label) {
        ResourceUtils.resButton((AbstractButton)this.rbHide, (String)label);
    }

    protected void initFileListModel() {
        if (this.fileListModel.getSize() > 0) {
            return;
        }
        ArrayList<String> collected = new ArrayList<String>(25);
        for (File fileExtension : FileTypesRecognizer.allMappedExtensionsToNodes()) {
            String extension = fileExtension.getPath();
            if (collected.contains(extension)) continue;
            collected.add(extension);
            TextPair textPair = new TextPair(extension);
            this.fileListModel.addElement((Object)textPair, null, true, false);
        }
        this.fileListModel.sort();
        this.fileListModel.addCheckBoxStateListener((CheckBoxListItemStateListener)this);
    }

    private void enableOkButton() {
        if (this.dialog != null) {
            boolean enabled = this.txtMoreFilters.getText().length() > 0;
            this.dialog.setOKButtonEnabled(enabled || this.hasFileSelection());
        }
    }

    private synchronized boolean hasFileSelection() {
        boolean selected = false;
        int length = this.fileListModel.getSize();
        for (int i = 0; i < length; ++i) {
            if (!this.fileListModel.isElementSelected(i)) continue;
            selected = true;
            break;
        }
        return selected;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.btnSelectAll) {
            this.fileListModel.selectAll();
            this.fileList.repaint();
        } else if (obj == this.btnDeselectAll) {
            this.fileListModel.deselectAll();
            this.fileList.repaint();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.enableOkButton();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.enableOkButton();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void stateChanged(Object source) {
        this.enableOkButton();
    }

    protected static class TextPair {
        String _filterText;
        String _displayText;

        public TextPair(String filterText) {
            this._filterText = filterText;
        }

        public String getFilterText() {
            return this._filterText;
        }

        public void setFilterText(String filterText) {
            this._filterText = filterText;
        }

        public String toString() {
            if (this._displayText == null) {
                this.parseFilterText();
            }
            return this._displayText;
        }

        private void parseFilterText() {
            if (this._filterText.startsWith("*.") && !WildcardURLFilter.hasWildcard((String)this._filterText.substring(2))) {
                this._displayText = this._filterText;
                this.setFilterText(this._filterText.substring(1));
            } else {
                this._displayText = this._filterText.startsWith(".") && !WildcardURLFilter.hasWildcard((String)this._filterText) ? "*" + this._filterText : this._filterText;
            }
        }
    }
}

