/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.ContentSet;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Project;
import oracle.ide.model.panels.HSAdapterDelegateComponent;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.model.ContentFolder;
import oracle.jdeveloper.model.ContentSetFilterPanel;
import oracle.jdeveloper.model.ContentSetValidator;
import oracle.jdeveloper.resource.ModelArb;

public class ContentSetPanel
extends JPanel {
    private final JButton _addContentButton = new JButton();
    private final JButton _removeContentButton = new JButton();
    private final JButton _moveUpButton = new JButton();
    private final JButton _moveDownButton = new JButton();
    private final JLabel _contentSetLabel = new JLabel();
    private final DefaultListModel _contentListModel = new DefaultListModel();
    private final JList _contentList = new JList(this._contentListModel);
    private final ContentSetFilterPanel _filterTabs = new ContentSetFilterPanel();
    private final InteractionListener _listener = new InteractionListener();
    private final LCR _cellRenderer = new LCR();
    private final JPanel _content = new JPanel();
    private final HSAdapterDelegateComponent _delegatingComp = new HSAdapterDelegateComponent((JComponent)this._content);
    private String _csHashAdapterDelegateKey;
    private boolean _updating;
    private URL _projectURL;
    private ContentSet _contentSet;
    private ContentSetValidator _validator;
    private ContentFolder[] _activeContentFlders;

    public ContentSetPanel() {
        this((ContentSetValidator)null);
    }

    public ContentSetPanel(ContentSetValidator validator) {
        this._validator = validator;
        this._activeContentFlders = new ContentFolder[0];
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setContentSetLabel(String label) {
        ResourceUtils.resLabel((JLabel)this._contentSetLabel, (Component)this._contentList, (String)label);
    }

    public void setValidator(ContentSetValidator validator) {
        this._validator = validator;
    }

    public ContentSetValidator getValidator() {
        return this._validator;
    }

    public void setHashAdapaterDelegateKey(String key) {
        this._csHashAdapterDelegateKey = key;
    }

    public void loadFrom(Project project, ContentSet contentSet) {
        this._projectURL = project.getURL();
        this._contentSet = contentSet;
        this._contentListModel.clear();
        URLPath srcPath = this._contentSet.getURLPath();
        if (srcPath.size() > 0) {
            this.populateContentList(this._contentSet);
        }
        int contentSets = this._contentSet.countContentSets();
        for (int i = 0; i < contentSets; ++i) {
            ContentSet cs = this._contentSet.getContentSet(i);
            this.populateContentList(cs);
        }
        if (this._contentListModel.size() > 0) {
            this._contentList.setSelectedIndex(0);
        }
        this.enableControls();
        this._delegatingComp.configureComponent(this._csHashAdapterDelegateKey, HSAdapterDelegateComponent.Scope.PROJECT, (HashStructureNode)project);
    }

    public void saveContentSet() throws EmptyContentSetException {
        Object[] contents = this._contentListModel.toArray();
        ContentSet newContentSet = new ContentSet(HashStructure.newInstance());
        this._contentSet.copyTo((Object)newContentSet);
        if (contents.length == 0) {
            throw new EmptyContentSetException();
        }
        if (contents.length == 1) {
            ContentFolder folder = (ContentFolder)contents[0];
            newContentSet.removeAllContentSets();
            this.persistContentSet(folder, newContentSet);
        } else {
            newContentSet.getURLPath().setEntries(null);
            newContentSet.getPatternFilters().setFilters(null);
            newContentSet.removeAllContentSets();
            for (int i = 0; i < contents.length; ++i) {
                ContentFolder folder = (ContentFolder)contents[i];
                ContentSet subContentSet = new ContentSet(HashStructure.newInstance());
                newContentSet.addContentSet(subContentSet);
                this.persistContentSet(folder, subContentSet);
            }
        }
        if (!newContentSet.equals((Object)this._contentSet)) {
            this._contentSet.getURLPath().setEntries(null);
            this._contentSet.getPatternFilters().setFilters(null);
            this._contentSet.removeAllContentSets();
            newContentSet.copyTo((Object)this._contentSet);
        }
    }

    public void hideUpDownButtons() {
        this._moveUpButton.setVisible(false);
        this._moveDownButton.setVisible(false);
    }

    public boolean addFolderToContentSet(URL contentFolderURL) {
        return this.addFolderToContentSet(contentFolderURL, contentFolderURL);
    }

    public boolean addFolderToContentSet(URL contentFolderURL, URL srcRootURL) {
        String relPath = URLFileSystem.toRelativeSpec((URL)contentFolderURL, (URL)srcRootURL, (boolean)true);
        if (relPath == null) {
            Assert.printStackTrace((relPath == null ? 1 : 0) != 0, (String)"Content folder is not under the specified source root");
            return false;
        }
        if (this.contentSetContainsURL(contentFolderURL)) {
            return false;
        }
        ContentFolder contentFolder = new ContentFolder(contentFolderURL, srcRootURL);
        this._contentListModel.addElement(contentFolder);
        return true;
    }

    public URLPath getURLPath() {
        URLPath urlPath = new URLPath();
        Object[] contents = this._contentListModel.toArray();
        for (int i = 0; i < contents.length; ++i) {
            ContentFolder contentFolder = (ContentFolder)contents[i];
            URL srcRootURL = contentFolder.getRootURL();
            urlPath.add(srcRootURL);
        }
        return urlPath;
    }

    public boolean contentSetContainsURL(URL url) {
        Object[] contents = this._contentListModel.toArray();
        for (int i = 0; i < contents.length; ++i) {
            ContentFolder folder = (ContentFolder)contents[i];
            if (!URLFileSystem.equals((URL)url, (URL)folder.getContentFolderURL())) continue;
            return true;
        }
        return false;
    }

    private void populateContentList(ContentSet contentSet) {
        URL contentFolderURL = contentSet.getContentFolderURL();
        URLPath urlPath = contentSet.getURLPath();
        for (URL srcRootURL : urlPath.asList()) {
            PatternFilter[] filters = contentSet.getPatternFilters().getFilters();
            ContentFolder folder = new ContentFolder(contentFolderURL, srcRootURL, filters);
            this._contentListModel.addElement(folder);
        }
    }

    private void persistContentSet(ContentFolder contentFolder, ContentSet contentSet) {
        URL srcRootURL = contentFolder.getRootURL();
        URLPath existingURLPath = contentSet.getURLPath();
        if (existingURLPath.size() != 1 || !URLFileSystem.equals((URL)((URL)existingURLPath.asList().get(0)), (URL)srcRootURL)) {
            URL[] entries = new URL[]{srcRootURL};
            existingURLPath.setEntries(entries);
        }
        if (!contentFolder.getContentFolderURL().equals(srcRootURL)) {
            contentSet.setContentFolderURL(contentFolder.getContentFolderURL());
        } else {
            contentSet.setContentFolderURL(null);
        }
        PatternFilter[] filters = contentFolder.getAllFilters();
        contentSet.getPatternFilters().setFilters(filters);
    }

    private int getIndexOfURL(URL url) {
        Object[] contents = this._contentListModel.toArray();
        for (int i = 0; i < contents.length; ++i) {
            ContentFolder folder = (ContentFolder)contents[i];
            if (!URLFileSystem.equals((URL)url, (URL)folder.getContentFolderURL())) continue;
            return i;
        }
        return -1;
    }

    private void enableControls() {
        if (!this._updating) {
            int index = this._contentList.getSelectedIndex();
            boolean hasSelection = index != -1;
            this._removeContentButton.setEnabled(hasSelection);
            this._filterTabs.setEnabled(hasSelection);
            int length = this._contentList.getSelectedIndices().length;
            this._moveUpButton.setEnabled(length == 1 && index > 0);
            this._moveDownButton.setEnabled(length == 1 && index < this._contentListModel.size() - 1);
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this._addContentButton, (String)ModelArb.getString((int)93));
        ResourceUtils.resButton((AbstractButton)this._removeContentButton, (String)ModelArb.getString((int)94));
        ResourceUtils.resButton((AbstractButton)this._moveUpButton, (String)ModelArb.getString((int)96));
        ResourceUtils.resButton((AbstractButton)this._moveDownButton, (String)ModelArb.getString((int)97));
        ResourceUtils.resLabel((JLabel)this._contentSetLabel, (Component)this._contentList, (String)ModelArb.getString((int)90));
        this._addContentButton.addActionListener(this._listener);
        this._removeContentButton.addActionListener(this._listener);
        this._moveUpButton.addActionListener(this._listener);
        this._moveDownButton.addActionListener(this._listener);
        this._contentList.addListSelectionListener(this._listener);
        this._contentList.setCellRenderer(this._cellRenderer);
        this._contentList.getSelectionModel().setSelectionMode(2);
        JScrollPane contentListScroller = new JScrollPane(this._contentList);
        this.setLayout(new BorderLayout());
        this.add((Component)this._delegatingComp.getComponent(), "Center");
        this._content.setLayout(new GridBagLayout());
        Insets labelInsets = new Insets(0, 0, 2, 0);
        Insets tabPaneInsets = new Insets(5, 0, 0, 0);
        Insets listInsets = new Insets(0, 0, 0, 0);
        Insets buttonInsets = new Insets(0, 8, 5, 0);
        int Y = -1;
        this._content.add((Component)this._contentSetLabel, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 2, labelInsets, 0, 0));
        this._content.add((Component)contentListScroller, new GridBagConstraints(0, -1, 1, 4, 1.0, 1.0, 10, 1, listInsets, 0, 0));
        this._content.add((Component)this._addContentButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 10, 2, buttonInsets, 0, 0));
        this._content.add((Component)this._removeContentButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, buttonInsets, 0, 0));
        this._content.add((Component)this._moveUpButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, buttonInsets, 0, 0));
        buttonInsets.bottom = 0;
        this._content.add((Component)this._moveDownButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, buttonInsets, 0, 0));
        this._content.add((Component)this._filterTabs, new GridBagConstraints(0, -1, 2, 1, 1.0, 5.0, 17, 1, tabPaneInsets, 0, 0));
    }

    private class InteractionListener
    implements ActionListener,
    ListSelectionListener {
        private InteractionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indexes;
            int selectionCount;
            ContentSetPanel.this._updating = true;
            Object src = e.getSource();
            if (src == ContentSetPanel.this._addContentButton) {
                WaitCursor waitCursor = new WaitCursor((Component)ContentSetPanel.this);
                waitCursor.show();
                URLChooser chooser = DialogUtil.newURLChooser();
                chooser.setShowJarsAsDirs(false);
                chooser.setSelectionScope(1);
                chooser.setSelectionMode(2);
                chooser.setRoots(URLFileSystem.listRoots());
                chooser.setSelectedURL(ContentSetPanel.this._projectURL);
                if (ContentSetPanel.this._activeContentFlders.length > 0) {
                    chooser.setSelectedURL(ContentSetPanel.this._activeContentFlders[0].getContentFolderURL());
                }
                waitCursor.hide();
                waitCursor.dispose();
                if (chooser.showOpenDialog((Component)ContentSetPanel.this.getParent()) == 0) {
                    URL[] selectedURLs = chooser.getSelectedURLs();
                    if (ContentSetPanel.this._validator != null) {
                        ContentSetPanel.this._validator.validateAndProcessURLs(ContentSetPanel.this, selectedURLs);
                        ContentSetPanel.this._contentList.setSelectedIndex(ContentSetPanel.this._contentListModel.size() - 1);
                    } else {
                        for (int i = 0; i < selectedURLs.length; ++i) {
                            URL url = selectedURLs[i];
                            ContentSetPanel.this.addFolderToContentSet(url, url);
                            int index = ContentSetPanel.this.getIndexOfURL(selectedURLs[i]);
                            ContentSetPanel.this._contentList.setSelectedIndex(index);
                        }
                    }
                }
                chooser.flush();
            } else if (src == ContentSetPanel.this._removeContentButton) {
                if (ContentSetPanel.this._activeContentFlders.length == ContentSetPanel.this._contentListModel.size()) {
                    ContentSetPanel.this._contentListModel.clear();
                    ContentSetPanel.this._addContentButton.requestFocus();
                } else {
                    int index = ContentSetPanel.this._contentList.getSelectedIndex();
                    for (int i = ContentSetPanel.this._activeContentFlders.length - 1; i >= 0; --i) {
                        ContentSetPanel.this._contentListModel.removeElement(ContentSetPanel.this._activeContentFlders[i]);
                    }
                    int length = ContentSetPanel.this._contentListModel.size();
                    if (length > 0 && index <= length) {
                        if (index == length) {
                            --index;
                        }
                        ContentSetPanel.this._contentList.setSelectedIndex(index);
                    }
                }
            } else if (src == ContentSetPanel.this._moveUpButton) {
                int[] indexes2 = ContentSetPanel.this._contentList.getSelectedIndices();
                int selectionCount2 = indexes2.length;
                if (selectionCount2 == 1) {
                    int pos = indexes2[0];
                    ContentFolder folder = (ContentFolder)ContentSetPanel.this._contentListModel.getElementAt(pos);
                    ContentSetPanel.this._contentListModel.remove(pos);
                    ContentSetPanel.this._contentListModel.add(--pos, folder);
                    ContentSetPanel.this._contentList.setSelectedIndex(pos);
                }
            } else if (src == ContentSetPanel.this._moveDownButton && (selectionCount = (indexes = ContentSetPanel.this._contentList.getSelectedIndices()).length) == 1) {
                int pos = indexes[0];
                ContentFolder folder = (ContentFolder)ContentSetPanel.this._contentListModel.getElementAt(pos);
                ContentSetPanel.this._contentListModel.remove(pos);
                ContentSetPanel.this._contentListModel.add(++pos, folder);
                ContentSetPanel.this._contentList.setSelectedIndex(pos);
            }
            ContentSetPanel.this._updating = false;
            ContentSetPanel.this.enableControls();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == ContentSetPanel.this._contentList && !e.getValueIsAdjusting()) {
                Object[] selection = ContentSetPanel.this._contentList.getSelectedValues();
                ContentSetPanel.this._activeContentFlders = new ContentFolder[selection.length];
                for (int i = 0; i < selection.length; ++i) {
                    ContentSetPanel.this._activeContentFlders[i] = (ContentFolder)selection[i];
                }
                ContentSetPanel.this._filterTabs.setData(ContentSetPanel.this._activeContentFlders);
                ContentSetPanel.this.enableControls();
            }
        }
    }

    private static class LCR
    extends DefaultListCellRenderer {
        private LCR() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ContentFolder) {
                l.setIcon(OracleIcons.getIcon((String)"folder.png"));
                l.setText(URLFileSystem.getPlatformPathName((URL)((ContentFolder)value).getContentFolderURL()));
            } else if (!(value instanceof String)) {
                System.err.println("**** Warning: unrecognized list item type: " + (value != null ? value.getClass() : null));
            }
            return l;
        }
    }

    public static class EmptyContentSetException
    extends Exception {
        EmptyContentSetException() {
            super("The ContentSet is empty.");
        }
    }
}

