/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.ocsp.AcceptableResponseTypeExtension;
import oracle.security.crypto.ocsp.ArchiveCutOffExtension;
import oracle.security.crypto.ocsp.CRLReferenceExtension;
import oracle.security.crypto.ocsp.NoCheckExtension;
import oracle.security.crypto.ocsp.NonceExtension;
import oracle.security.crypto.ocsp.ServiceLocatorExtension;
import oracle.security.crypto.util.OIDManager;

public interface OCSP {
    public static final ASN1ObjectID id_pkix_ocsp = PKIX.id_ad_ocsp;
    public static final ASN1ObjectID id_pkix_ocsp_basic = new ASN1ObjectID(id_pkix_ocsp, 1);
    public static final ASN1ObjectID id_pkix_ocsp_nonce = new ASN1ObjectID(id_pkix_ocsp, 2);
    public static final ASN1ObjectID id_pkix_ocsp_crl = new ASN1ObjectID(id_pkix_ocsp, 3);
    public static final ASN1ObjectID id_pkix_ocsp_response = new ASN1ObjectID(id_pkix_ocsp, 4);
    public static final ASN1ObjectID id_pkix_ocsp_nocheck = new ASN1ObjectID(id_pkix_ocsp, 5);
    public static final ASN1ObjectID id_pkix_ocsp_archive_cutoff = new ASN1ObjectID(id_pkix_ocsp, 6);
    public static final ASN1ObjectID id_pkix_ocsp_service_locator = new ASN1ObjectID(id_pkix_ocsp, 7);
    public static final ASN1ObjectID id_kp_OCSPSigning = new ASN1ObjectID(PKIX.id_kp, 9);
    public static final AlgorithmIdentifier sha_1 = AlgID.sha1;
    public static final AlgorithmIdentifier md5 = AlgID.md5;
    public static final AlgorithmIdentifier id_dsa_with_sha_1 = new AlgorithmIdentifier(AlgID.dsaWithSHA1.getOID(), false);
    public static final AlgorithmIdentifier dsaWithSHA = new AlgorithmIdentifier(AlgID.dsaWithSHA.getOID(), false);
    public static final AlgorithmIdentifier hmac_SHA_1 = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.iana, 1, 2));
    public static final AlgorithmIdentifier rsaEncryption = AlgID.rsaEncryption;
    public static final AlgorithmIdentifier id_alg_CMS3DESwrap = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 16, 3, 6));
    public static final AlgorithmIdentifier id_alg_CMSRC2wrap = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 16, 3, 7));

    public static class OIDRegistrar {
        OIDRegistrar() {
        }

        static {
            OIDManager oidMgr = new OIDManager(OIDManager.getOIDManager());
            oidMgr.setMapping(id_pkix_ocsp_nonce, "extension", NonceExtension.class);
            oidMgr.setMapping(id_pkix_ocsp_crl, "extension", CRLReferenceExtension.class);
            oidMgr.setMapping(id_pkix_ocsp_response, "extension", AcceptableResponseTypeExtension.class);
            oidMgr.setMapping(id_pkix_ocsp_nocheck, "extension", NoCheckExtension.class);
            oidMgr.setMapping(id_pkix_ocsp_archive_cutoff, "extension", ArchiveCutOffExtension.class);
            oidMgr.setMapping(id_pkix_ocsp_service_locator, "extension", ServiceLocatorExtension.class);
            OIDManager.setOIDManager((OIDManager)oidMgr);
        }
    }
}

