/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;

public class ProviderUtil {
    private static final Logger logger = Logger.getLogger("oracle.adfinternal.share.util.ProviderUtil");

    private ProviderUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final <T> T loadProviderPlugin(Class<T> c) {
        final String spiCN = c.getName();
        String spiSN = c.getSimpleName();
        String pluginCN = "OFF";
        try {
            String string = pluginCN = System.getSecurityManager() == null ? System.getProperty(spiCN) : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(spiCN);
                }
            });
            if (pluginCN != null) {
                if ("OFF".equalsIgnoreCase(pluginCN)) {
                    if (!logger.isLoggable(Level.INFO)) return null;
                    logger.info(spiSN + " loading disabled by -D" + spiCN + "=OFF");
                    return null;
                }
                if (!logger.isLoggable(Level.INFO)) return ClassUtils.forName(pluginCN, true, ProviderUtil.class).newInstance();
                logger.info("Loading: " + pluginCN);
                return ClassUtils.forName(pluginCN, true, ProviderUtil.class).newInstance();
            }
            ServiceLoader<T> sl = ServiceLoader.load(c, ClassUtils.getClassLoader(ProviderUtil.class));
            Iterator<T> iter = sl.iterator();
            if (iter.hasNext()) {
                T ext = iter.next();
                if (!logger.isLoggable(Level.INFO)) return ext;
                logger.info("Loaded registered " + spiSN + ": " + ext);
                return ext;
            }
            if (!logger.isLoggable(Level.INFO)) return null;
            logger.info("No " + spiSN + " registration, skipping.");
            return null;
        }
        catch (Exception x) {
            logger.log(Level.SEVERE, pluginCN, x);
        }
        return null;
    }
}

