/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.release;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adfinternal.share.release.Function;

public abstract class ReleaseAdapter {
    private static ReleaseAdapter instance;

    public static ReleaseAdapter getInstance() {
        if (instance == null) {
            try {
                instance = ReleaseAdapter.getAdapter(ReleaseAdapter.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    private static ReleaseAdapter getAdapter(Class interfaceClass) throws Exception {
        Iterator iter = ServiceLoader.load(interfaceClass, interfaceClass.getClassLoader()).iterator();
        if (!iter.hasNext()) {
            throw new Exception("no release adapter found");
        }
        ReleaseAdapter adapter = (ReleaseAdapter)iter.next();
        if (iter.hasNext()) {
            throw new Exception("multiple release adapters found");
        }
        return adapter;
    }

    public abstract void addSuppressedExceptions(Throwable var1, List<Throwable> var2);

    public abstract void reportException(Logger var1, Exception var2, Exception var3);

    public abstract void throwException(RuntimeException var1, Throwable var2, Throwable var3);

    public abstract <K, V> V computeIfAbsent(Map<K, V> var1, K var2, Function<? super K, ? extends V> var3);

    public abstract <K, V> V putIfAbsent(Map<K, V> var1, K var2, V var3);

    public abstract boolean supportsMT();

    public abstract Context createInitialContext(Hashtable var1, ClassLoader var2) throws NamingException;
}

