/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.objectmerge.logging;

import java.util.HashMap;
import java.util.Map;

public abstract class SandboxLogRecord<R extends SandboxLogRecord<R>> {
    protected final String summary;
    protected Map<String, Object> values;

    protected SandboxLogRecord(String summary) {
        if (summary == null) {
            throw new IllegalArgumentException("Invalid log record summary: null.");
        }
        this.summary = summary;
    }

    public final String getSummary() {
        return this.summary;
    }

    public String toString() {
        return this.summary + (String)(this.values == null ? "" : " " + this.values);
    }

    public abstract R clone(String var1);

    public R clone() {
        return this.clone(null);
    }

    protected void initValues() {
        if (this.values == null) {
            this.values = new HashMap<String, Object>(8);
        }
    }

    public Object get(String name) {
        return this.values.get(name);
    }

    protected R put(String name, Object value) {
        this.initValues();
        this.values.put(name, value);
        return (R)this;
    }

    public R loggedBy(String s) {
        return this.put("loggedBy", s);
    }
}

