/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.services.impl.TokenizableConstants;
import oracle.javatools.annotations.Concealed;

public class ServicesEnumeration
implements Enumeration<String> {
    private static final Logger logger = Logger.getLogger(ServicesEnumeration.class.getName());
    private BufferedReader rdr = null;
    private String lastRead = null;
    private Map<String, List<String>> resources = null;
    private boolean prologSeen = false;
    private boolean epilogSeen = false;
    private HashSet<String> nonBrowsables = null;

    public ServicesEnumeration(Reader inRdr) {
        this.rdr = inRdr instanceof BufferedReader ? (BufferedReader)inRdr : new BufferedReader(inRdr);
        this.lastRead = this.readNextToken();
    }

    @Override
    public String nextElement() {
        String retThis = this.lastRead;
        this.lastRead = this.readNextToken();
        return retThis;
    }

    @Override
    public boolean hasMoreElements() {
        return this.lastRead != null;
    }

    public void close() {
        try {
            if (this.rdr != null) {
                this.rdr.close();
                this.rdr = null;
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, "close failed", e);
        }
    }

    @Concealed
    public Map<String, List<String>> getResourceHolder() {
        return this.resources;
    }

    @Concealed
    public HashSet<String> getNonBrowsables() {
        return this.nonBrowsables;
    }

    private String readNextToken() {
        Object lin;
        try {
            lin = this.rdr.readLine();
            while (lin != null) {
                int pos = ((String)(lin = this.cleanHashComment((String)lin))).indexOf("<!--");
                if (pos != -1) {
                    int pos2 = ((String)lin).indexOf("-->");
                    if (pos2 != -1) {
                        String rawLin = lin;
                        lin = rawLin.substring(0, pos) + " " + rawLin.substring(pos2 + "-->".length());
                    } else {
                        String otherLin = null;
                        while (pos2 == -1) {
                            otherLin = this.rdr.readLine();
                            if (otherLin == null) {
                                pos2 = -1;
                                lin = ((String)lin).substring(0, pos);
                                break;
                            }
                            otherLin = this.cleanHashComment(otherLin);
                            pos2 = otherLin.indexOf("-->");
                        }
                        if (pos2 != -1) {
                            lin = ((String)lin).substring(0, pos) + " " + otherLin.substring(pos2 + "-->".length());
                        }
                    }
                }
                if (((String)(lin = ((String)lin).trim())).length() <= 0) {
                    lin = this.rdr.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "read failed", e);
            Object lin2 = null;
            throw new RuntimeException(e);
        }
        return lin;
    }

    private final String cleanHashComment(String lin) {
        int pos = lin.indexOf(35);
        if (pos != -1) {
            if (pos == 0 && !this.epilogSeen) {
                this.interpretTokenizableComment(lin);
            }
            lin = lin.substring(0, pos);
        }
        return lin.trim();
    }

    private void interpretTokenizableComment(String lin) {
        if (this.epilogSeen) {
            return;
        }
        lin = lin.trim();
        if (!this.prologSeen) {
            if (lin.startsWith("#:__PROLOG__:")) {
                this.prologSeen = true;
                String[] types = lin.substring(TokenizableConstants.PROLOG_SIG_LEN).split(":");
                this.resources = new LinkedHashMap<String, List<String>>(types.length);
                this.nonBrowsables = new HashSet(types.length / 3 + 1);
                for (String serviceType : types) {
                    boolean tokenizable = false;
                    boolean browsable = true;
                    int sentinel = (serviceType = serviceType.trim()).indexOf(59);
                    if (sentinel != -1) {
                        block5: for (int xs = 0; xs < sentinel; ++xs) {
                            char ch = serviceType.charAt(xs);
                            switch (ch) {
                                case '!': {
                                    tokenizable = true;
                                    continue block5;
                                }
                                case '-': {
                                    browsable = false;
                                    continue block5;
                                }
                                default: {
                                    if (!logger.isLoggable(Level.FINE)) continue block5;
                                    logger.fine("Didn't recognize (" + ch + ") in: " + lin);
                                }
                            }
                        }
                    }
                    String key = serviceType.substring(sentinel + 1);
                    if (!browsable) {
                        this.nonBrowsables.add(key);
                    }
                    this.resources.put(key, tokenizable ? new ArrayList() : Collections.EMPTY_LIST);
                }
            }
            return;
        }
        if (lin.startsWith("#:__EPILOG__:")) {
            this.epilogSeen = true;
            return;
        }
        if (lin.startsWith("#:")) {
            int keySep = lin.indexOf(58, TokenizableConstants.DESCR_SIG_LEN);
            if (keySep == -1) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No ':' in : " + lin);
                }
            } else {
                String key = lin.substring(TokenizableConstants.DESCR_SIG_LEN, keySep).trim();
                List<String> list = this.resources.get(key);
                if (list == null || list == Collections.EMPTY_LIST) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Had to create a list unexpectedly for " + key + " in " + lin);
                    }
                    list = new ArrayList<String>();
                    this.resources.put(key, list);
                }
                String value = lin.substring(keySep + 1).trim();
                list.add(value);
            }
            return;
        }
    }
}

