/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.util;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import oracle.adf.share.logging.ADFLogger;

public class ADFPropertiesUtil {
    protected static final ADFLogger sLogger = ADFLogger.createADFLogger(ADFPropertiesUtil.class);

    private ADFPropertiesUtil() {
    }

    public static final String getSystemProperty(final String propertyName, final String defaultValue) {
        String value = defaultValue;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    String v = System.getProperty(propertyName, defaultValue);
                    return v;
                }
            });
        }
        catch (PrivilegedActionException e) {
            sLogger.log(e.getMessage());
        }
        return value;
    }

    public static final String setSystemProperty(final String propertyName, final String _value) {
        String value = _value;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    String v = System.setProperty(propertyName, _value);
                    return v;
                }
            });
        }
        catch (PrivilegedActionException e) {
            sLogger.log(e.getMessage());
        }
        return value;
    }

    public static final String getSystemProperty(String propertyName) {
        return ADFPropertiesUtil.getSystemProperty(propertyName, null);
    }
}

