/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;

@CodeSharingSafe(value="StaticInitializer")
public final class ServiceLoader<S>
implements Iterable<S> {
    @CodeSharingSafe(value="MutableStaticField")
    private static boolean useNew = false;
    private Object theImpl = null;
    private static final Class[] EMPTY_TYPES = new Class[0];
    private static final String OLD_CLASS_NAME = "sun/misc/Service.class";
    private static final String[] oldMethodNames = new String[]{"providers", "providers", "installedProviders", "toString", null, null};
    private static final String NEW_CLASS_NAME = "java/util/ServiceLoader.class";
    private static final String[] newMethodNames = new String[]{"load", "load", "loadInstalled", "toString", "reload", "iterator"};
    private static final int LOAD1 = 0;
    private static final int LOAD2 = 1;
    private static final int LOAD_INSTALLED = 2;
    private static final int TO_STRING = 3;
    private static final int RELOAD = 4;
    private static final int ITERATOR = 5;
    @CodeSharingSafe(value="MutableStaticField")
    private static String[] METH_NAMES = oldMethodNames;
    @CodeSharingSafe(value="MutableStaticField")
    private static Class clazz = null;
    @CodeSharingSafe(value="MutableStaticField")
    private static Method[] METHODS = new Method[METH_NAMES.length];

    private ServiceLoader(Object theImpl) {
        this.theImpl = theImpl;
    }

    public void reload() {
        if (!useNew) {
            throw new UnsupportedOperationException("reload not supported, use JDK 1.6");
        }
        ServiceLoader.invoke(4, this.theImpl, null);
    }

    @Override
    public Iterator<S> iterator() {
        if (!useNew) {
            return (Iterator)this.theImpl;
        }
        return (Iterator)ServiceLoader.invoke(5, this.theImpl, null);
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        Object[] args = new Object[]{service, loader};
        return new ServiceLoader<S>(ServiceLoader.invoke(0, null, args));
    }

    public static <S> ServiceLoader<S> load(Class<S> service) {
        Object[] args = new Object[]{service};
        return new ServiceLoader<S>(ServiceLoader.invoke(1, null, args));
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> service) {
        Object[] args = new Object[]{service};
        return new ServiceLoader<S>(ServiceLoader.invoke(2, null, args));
    }

    public String toString() {
        return (String)ServiceLoader.invoke(3, this.theImpl, null);
    }

    private static final Object invoke(int meth, Object obj, Object[] args) {
        try {
            return METHODS[meth].invoke(obj, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void initImpl() throws ClassNotFoundException, NoSuchMethodException {
        String className = OLD_CLASS_NAME;
        int major = 1;
        int minor = 6;
        try {
            String ver = System.getProperty("java.version", "1.6");
            int x = ver.indexOf(46);
            if (x != -1) {
                major = Integer.parseInt(ver.substring(0, x));
                int oldX = x;
                if ((x = ver.indexOf(46, x + 1)) != -1) {
                    minor = Integer.parseInt(ver.substring(oldX + 1, x));
                } else if (major != 1) {
                    minor = 0;
                }
            }
        }
        catch (Throwable ver) {
            // empty catch block
        }
        if (major > 1 || major == 1 && minor > 5) {
            className = NEW_CLASS_NAME;
            METH_NAMES = newMethodNames;
            useNew = true;
        }
        URL url = null;
        while ((url = ClassUtils.getClassLoader(ServiceLoader.class).getResource(className)) == null) {
            if (!useNew) {
                throw new ClassNotFoundException(className);
            }
            className = OLD_CLASS_NAME;
            METH_NAMES = oldMethodNames;
            useNew = false;
        }
        String forNameStyle = className.substring(0, className.length() - 6).replace('/', '.');
        clazz = ClassUtils.forName(forNameStyle, ServiceLoader.class);
        Class[] param0 = new Class[]{Class.class, ClassLoader.class};
        Class[] param1 = new Class[]{Class.class};
        ServiceLoader.METHODS[0] = clazz.getMethod(METH_NAMES[0], param0);
        ServiceLoader.METHODS[1] = clazz.getMethod(METH_NAMES[1], param1);
        ServiceLoader.METHODS[2] = clazz.getMethod(METH_NAMES[2], param1);
        ServiceLoader.METHODS[3] = clazz.getMethod(METH_NAMES[3], EMPTY_TYPES);
        if (useNew) {
            ServiceLoader.METHODS[4] = clazz.getMethod(METH_NAMES[4], EMPTY_TYPES);
            ServiceLoader.METHODS[5] = clazz.getMethod(METH_NAMES[5], EMPTY_TYPES);
        }
    }

    static {
        try {
            ServiceLoader.initImpl();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

