/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.TuningResources;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.IPopupSupplier;
import oracle.dbtools.raptor.controls.MouseMotionTooltipListener;
import oracle.dbtools.raptor.sqltrace.SqlTraceEditorNode;
import oracle.dbtools.raptor.sqltrace.TableColumnChooser;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.dbtools.raptor.sqltrace.ui.StatisticsSummaryTable;
import oracle.dbtools.raptor.sqltrace.ui.TracePopupProvider;
import oracle.dbtools.raptor.sqltrace.ui.WaitSummaryTable;
import oracle.dbtools.raptor.sqltrace.ui.renderer.MultiLineTextCellEditor;
import oracle.dbtools.raptor.sqltrace.ui.renderer.MultiLineTextRenderer;
import oracle.dbtools.raptor.sqltrace.ui.renderer.SqlCursorRenderer;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.ui.balloon.Balloon;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class SqlTraceListCursorsEditor
extends Editor {
    private JComponent _ui;
    Balloon b = new Balloon();
    private Toolbar _toolBar;
    private SqlCursorRenderer _renderer;
    private DefaultTableModel _model;
    private SqlTraceEditorNode _node;
    private JComboBox _filter;
    private StatisticsSummaryTable _cp;
    private WaitSummaryTable _ws;
    private JScrollPane _sp;
    private boolean _hasWaits;
    private boolean _hasStats;
    private boolean _hasTimes;
    private JCheckBox _includeSys;
    protected String _filterText;
    private int _sortBy = 0;
    protected int _sortOrder = 0;
    private JTable _table;

    public void open() {
    }

    private void init() {
        if (this._ui == null) {
            this._table = new JTable();
            TableColumnChooser.install(this._table);
            MouseMotionTooltipListener mouseMotionTooltipListener = new MouseMotionTooltipListener((JComponent)this._table, (IPopupSupplier)new TracePopupProvider(){

                public Component getComponentAt(Point point) {
                    return SqlTraceListCursorsEditor.this.getGUI().getComponentAt(point);
                }
            });
            this._node = (SqlTraceEditorNode)this.getContext().getNode();
            this.buildTable();
            this.initToolbar();
            this._ui = this._table;
        }
    }

    private void buildTable() {
        RaptorTask raptorTask = new RaptorTask(TuningResources.getString("SqlTraceListCursorsEditor.29"), true){

            protected Object doWork() throws TaskException {
                SqlTraceListCursorsEditor.this._node.getTraceFile();
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SqlTraceListCursorsEditor.this._hasWaits = false;
                        SqlTraceListCursorsEditor.this._hasStats = false;
                        SqlTraceListCursorsEditor.this._hasTimes = false;
                        for (SqlCursor sqlCursor : SqlTraceListCursorsEditor.this._node.getTraceFile().getCursors()) {
                            if (!SqlTraceListCursorsEditor.this._hasWaits && sqlCursor.getWaitSummary() != null && sqlCursor.getWaitSummary().size() > 0) {
                                SqlTraceListCursorsEditor.this._hasWaits = true;
                            }
                            if (!SqlTraceListCursorsEditor.this._hasStats && sqlCursor.getStats() != null && sqlCursor.getStats().size() > 0) {
                                SqlTraceListCursorsEditor.this._hasStats = true;
                            }
                            if (SqlTraceListCursorsEditor.this._hasTimes || !(sqlCursor.getTotalCPU() > 0.0f)) continue;
                            SqlTraceListCursorsEditor.this._hasTimes = true;
                        }
                        SqlTraceListCursorsEditor.this._table.setAutoResizeMode(0);
                        SqlTraceListCursorsEditor.this._model = (DefaultTableModel)SqlTraceListCursorsEditor.this._table.getModel();
                        SqlTraceListCursorsEditor.this._model.addColumn(TuningResources.getString("SqlTraceListCursorsEditor.0"));
                        if (SqlTraceListCursorsEditor.this._hasTimes) {
                            SqlTraceListCursorsEditor.this._model.addColumn(TuningResources.getString("SqlTraceListCursorsEditor.1"));
                        }
                        if (SqlTraceListCursorsEditor.this._hasWaits) {
                            SqlTraceListCursorsEditor.this._model.addColumn(TuningResources.getString("SqlTraceListCursorsEditor.2"));
                        }
                        if (SqlTraceListCursorsEditor.this._hasStats) {
                            SqlTraceListCursorsEditor.this._model.addColumn(TuningResources.getString("SqlTraceListCursorsEditor.3"));
                        }
                        int n = 0;
                        SqlTraceListCursorsEditor.this._table.getColumnModel().getColumn(n).setMinWidth(200);
                        ++n;
                        if (SqlTraceListCursorsEditor.this._hasTimes) {
                            SqlTraceListCursorsEditor.this._table.getColumnModel().getColumn(n).setMinWidth(425);
                            ++n;
                        }
                        if (SqlTraceListCursorsEditor.this._hasWaits) {
                            SqlTraceListCursorsEditor.this._table.getColumnModel().getColumn(n).setMinWidth(350);
                            ++n;
                        }
                        if (SqlTraceListCursorsEditor.this._hasStats) {
                            SqlTraceListCursorsEditor.this._table.getColumnModel().getColumn(n).setMinWidth(450);
                            ++n;
                        }
                        SqlTraceListCursorsEditor.this._table.setRowHeight(95);
                        SqlTraceListCursorsEditor.this._renderer = new SqlCursorRenderer(false, false);
                        SqlTraceListCursorsEditor.this._table.setDefaultRenderer(Object.class, SqlTraceListCursorsEditor.this._renderer);
                        SqlTraceListCursorsEditor.this._table.setDefaultEditor(Object.class, SqlTraceListCursorsEditor.this._renderer);
                        SqlTraceListCursorsEditor.this._table.setShowGrid(true);
                        SqlTraceListCursorsEditor.this._table.getColumnModel().getColumn(0).setCellRenderer(new MultiLineTextRenderer());
                        SqlTraceListCursorsEditor.this._table.setDefaultEditor(Object.class, new MultiLineTextCellEditor());
                        SqlTraceListCursorsEditor.this.loadCursors();
                        SqlTraceListCursorsEditor.this._table.validate();
                    }
                });
            }
        });
        RaptorTaskManager.getInstance().addTask(raptorTask);
    }

    private void initToolbar() {
        if (this._toolBar == null) {
            this._toolBar = new Toolbar();
            final JComboBox jComboBox = new JComboBox();
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
            defaultComboBoxModel.addElement("s");
            char c = '\u0173';
            defaultComboBoxModel.addElement(c + "s");
            jComboBox.setSize(20, jComboBox.getHeight());
            jComboBox.setMaximumSize(new Dimension(100, 30));
            jComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        if (jComboBox.getSelectedIndex() == 0) {
                            SqlTraceListCursorsEditor.this._renderer.setTimeFactor(1000000L);
                        } else if (jComboBox.getSelectedIndex() == 1) {
                            SqlTraceListCursorsEditor.this._renderer.setTimeFactor(0L);
                        }
                        SqlTraceListCursorsEditor.this.getGUI().repaint();
                    }
                }
            });
            this._filter = new JComboBox();
            DefaultComboBoxModel defaultComboBoxModel2 = (DefaultComboBoxModel)this._filter.getModel();
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.6"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.7"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.8"));
            this._filter.setSelectedIndex(2);
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SqlTraceListCursorsEditor.this.loadCursors();
                }
            };
            this._filter.addItemListener(itemListener);
            this._filter.setMaximumSize(this._filter.getMinimumSize());
            this._includeSys = new JCheckBox(TuningResources.getString("SqlTraceListCursorsEditor.9"));
            this._includeSys.setSelected(false);
            this._includeSys.addItemListener(itemListener);
            final SearchField searchField = new SearchField();
            Dimension dimension = searchField.getPreferredSize();
            dimension.setSize(150, dimension.height);
            searchField.setMinimumSize(dimension);
            searchField.setPreferredSize(dimension);
            searchField.setMaximumSize(dimension);
            searchField.addSearchListener(new SearchListener(){

                public void searchCategoryChanged(SearchEvent searchEvent) {
                }

                public void searchPerformed(SearchEvent searchEvent) {
                    SqlTraceListCursorsEditor.this._filterText = searchField.getText();
                    SqlTraceListCursorsEditor.this.loadCursors();
                }
            });
            final JComboBox jComboBox2 = new JComboBox();
            defaultComboBoxModel2 = (DefaultComboBoxModel)jComboBox2.getModel();
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.10"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.11"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.12"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.13"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.14"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.15"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.16"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.17"));
            jComboBox2.setSelectedIndex(3);
            jComboBox2.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        SqlTraceListCursorsEditor.this._sortBy = jComboBox2.getSelectedIndex();
                        SqlTraceListCursorsEditor.this.loadCursors();
                    }
                }
            });
            jComboBox2.setMaximumSize(jComboBox2.getMinimumSize());
            final JComboBox jComboBox3 = new JComboBox();
            defaultComboBoxModel2 = (DefaultComboBoxModel)jComboBox3.getModel();
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.18"));
            defaultComboBoxModel2.addElement(TuningResources.getString("SqlTraceListCursorsEditor.19"));
            jComboBox3.setSelectedIndex(1);
            jComboBox3.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        SqlTraceListCursorsEditor.this._sortOrder = jComboBox3.getSelectedIndex();
                        SqlTraceListCursorsEditor.this.loadCursors();
                    }
                }
            });
            jComboBox3.setMaximumSize(jComboBox3.getMinimumSize());
            int n = 0;
            this._toolBar.addComponent((Component)searchField, n++);
            this._toolBar.addComponent((Component)new JLabel(TuningResources.getString("SqlTraceListCursorsEditor.20")), n++);
            this._toolBar.addComponent(jComboBox, n++);
            this._toolBar.addComponent((Component)new JLabel(TuningResources.getString("SqlTraceListCursorsEditor.21")), n++);
            this._toolBar.addComponent((Component)this._filter, n++);
            this._toolBar.addComponent((Component)new JLabel(TuningResources.getString("SqlTraceListCursorsEditor.22")), n++);
            this._toolBar.addComponent(jComboBox2, n++);
            this._toolBar.addComponent(jComboBox3, n++);
            this._toolBar.addComponent((Component)this._includeSys, n++);
            this._toolBar.addComponent(Box.createHorizontalGlue(), n++);
        }
    }

    public Component getGUI() {
        this.init();
        return this._ui;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        this.init();
    }

    public Component getFixedTopMargin() {
        this.initToolbar();
        return this._toolBar;
    }

    public void loadCursors() {
        RaptorTask<Object> raptorTask = new RaptorTask<Object>(TuningResources.getString("SqlTraceListCursorsEditor.29"), true, IRaptorTaskRunMode.TASKVIEWER){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws TaskException {
                SqlTraceListCursorsEditor.this._node.getTraceFile();
                Vector<Vector> vector = SqlTraceListCursorsEditor.this._model.getDataVector();
                synchronized (vector) {
                    Vector<Vector> vector2 = SqlTraceListCursorsEditor.this._model.getDataVector();
                    vector2.removeAllElements();
                    for (SqlCursor sqlCursor : SqlTraceListCursorsEditor.this._node.getTraceFile().getCursors()) {
                        int n = SqlTraceListCursorsEditor.this._filter.getSelectedIndex();
                        boolean bl = false;
                        if (n == 0) {
                            bl = true;
                        } else if (n == 1 && sqlCursor.getDepLevel() == 0) {
                            bl = true;
                        } else if (n == 2 && sqlCursor.getDepLevel() > 0) {
                            bl = true;
                        }
                        if (sqlCursor.getUid() == 0 && SqlTraceListCursorsEditor.this._includeSys.isSelected()) {
                            bl = true;
                        } else if (sqlCursor.getUid() == 0 && !SqlTraceListCursorsEditor.this._includeSys.isSelected()) {
                            bl = false;
                        }
                        if (bl && SqlTraceListCursorsEditor.this._filterText != null && SqlTraceListCursorsEditor.this._filterText.trim().length() > 0 && sqlCursor.getSQL().toLowerCase().indexOf(SqlTraceListCursorsEditor.this._filterText.toLowerCase()) == -1) {
                            bl = false;
                        }
                        if (!bl) continue;
                        Vector<Object> vector3 = new Vector<Object>();
                        vector3.add(sqlCursor.getSQL());
                        if (SqlTraceListCursorsEditor.this._hasTimes) {
                            vector3.add(sqlCursor);
                        }
                        if (SqlTraceListCursorsEditor.this._hasWaits) {
                            vector3.add(sqlCursor.getWaitSummary());
                        }
                        if (SqlTraceListCursorsEditor.this._hasStats) {
                            vector3.add(sqlCursor.getStats());
                        }
                        vector2.add(vector3);
                    }
                    SqlTraceListCursorsEditor.this._table.removeEditor();
                    SqlTraceListCursorsEditor.this.sortCursors(SqlTraceListCursorsEditor.this._table, SqlTraceListCursorsEditor.this._model, SqlTraceListCursorsEditor.this._sortBy, SqlTraceListCursorsEditor.this._sortOrder);
                    SqlTraceListCursorsEditor.this._model.fireTableDataChanged();
                }
                return null;
            }
        };
        raptorTask.setCancellable(true);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void sortCursors(JTable jTable, DefaultTableModel defaultTableModel, final int n, final int n2) {
        Vector<Vector> vector = defaultTableModel.getDataVector();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                SqlCursor sqlCursor = (SqlCursor)((Vector)object).get(1);
                SqlCursor sqlCursor2 = (SqlCursor)((Vector)object2).get(1);
                int n3 = 0;
                if (n == 0) {
                    n3 = Double.valueOf(sqlCursor.getTime()).compareTo(sqlCursor2.getTime());
                } else if (n == 1) {
                    n3 = Double.valueOf(sqlCursor.getTotalCount()).compareTo(sqlCursor2.getTotalCount());
                } else if (n == 2) {
                    n3 = Float.valueOf(sqlCursor.getTotalCPU()).compareTo(Float.valueOf(sqlCursor2.getTotalCPU()));
                } else if (n == 3) {
                    n3 = Float.valueOf(sqlCursor.getTotalElapsed(false)).compareTo(Float.valueOf(sqlCursor2.getTotalElapsed(false)));
                } else if (n == 4) {
                    n3 = Float.valueOf(sqlCursor.getTotalDisk()).compareTo(Float.valueOf(sqlCursor2.getTotalDisk()));
                } else if (n == 5) {
                    n3 = Float.valueOf(sqlCursor.getTotalQuery()).compareTo(Float.valueOf(sqlCursor2.getTotalQuery()));
                } else if (n == 6) {
                    n3 = Float.valueOf(sqlCursor.getTotalCurrent()).compareTo(Float.valueOf(sqlCursor2.getTotalCurrent()));
                } else if (n == 7) {
                    n3 = Float.valueOf(sqlCursor.getTotalRows()).compareTo(Float.valueOf(sqlCursor2.getTotalRows()));
                }
                return n3 == 0 || n2 == 0 ? n3 : n3 * -1;
            }
        });
    }
}

