/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing;

import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.IlvRuntimeException;
import ilog.views.util.annotation.NoWarning;
import ilog.views.util.internal.IlvEnvironmentUtil;
import ilog.views.util.swing.internal.IlvEventThreadRegistry;
import ilog.views.util.swing.internal.IlvHiddenWindow;
import java.applet.Applet;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.beans.Introspector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class IlvSwingUtil {
    private static Robot a;
    private static final PrintStream b;
    private static HashMap<String, Integer> c;
    private static Version d;

    private IlvSwingUtil() {
    }

    public static boolean isHTMLToolTipsSupported() {
        return true;
    }

    private static String a(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        StringBuffer stringBuffer = null;
        int n = string.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string.substring(0, i));
                    }
                    stringBuffer.append("&lt;");
                    continue block10;
                }
                case '>': {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string.substring(0, i));
                    }
                    stringBuffer.append("&gt;");
                    continue block10;
                }
                case '&': {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string.substring(0, i));
                    }
                    stringBuffer.append("&amp;");
                    continue block10;
                }
                case '\"': {
                    if (bl2) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(string.substring(0, i));
                        }
                        stringBuffer.append("&quot;");
                        continue block10;
                    }
                    if (stringBuffer == null) continue block10;
                    stringBuffer.append(c);
                    continue block10;
                }
                case '\'': {
                    if (bl2) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(string.substring(0, i));
                        }
                        stringBuffer.append("&apos;");
                        continue block10;
                    }
                    if (stringBuffer == null) continue block10;
                    stringBuffer.append(c);
                    continue block10;
                }
                case '/': {
                    if (i == 0 && !bl2) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        stringBuffer.append("&#47;");
                        continue block10;
                    }
                    if (stringBuffer == null) continue block10;
                    stringBuffer.append(c);
                    continue block10;
                }
                case ' ': {
                    if (bl4) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(string.substring(0, i));
                        }
                        stringBuffer.append("&nbsp;");
                        continue block10;
                    }
                    if (stringBuffer == null) continue block10;
                    stringBuffer.append(c);
                    continue block10;
                }
                case '\n': {
                    if (!bl2 && bl3) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(string.substring(0, i));
                        }
                        stringBuffer.append("<br>");
                        continue block10;
                    }
                    if (stringBuffer == null) continue block10;
                    stringBuffer.append(c);
                    continue block10;
                }
                default: {
                    if (!bl || c < '\u007f') {
                        if (stringBuffer == null) continue block10;
                        stringBuffer.append(c);
                        continue block10;
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string.substring(0, i));
                    }
                    if (Character.isHighSurrogate(c) && i + 1 < n && Character.isLowSurrogate(string.charAt(i + 1))) {
                        int n2 = Character.toCodePoint(c, string.charAt(i + 1));
                        stringBuffer.append("&#");
                        stringBuffer.append(String.valueOf(n2));
                        stringBuffer.append(';');
                        ++i;
                        continue block10;
                    }
                    stringBuffer.append("&#");
                    stringBuffer.append(String.valueOf((int)c));
                    stringBuffer.append(';');
                }
            }
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public static String escapeForHTMLElement(String string, boolean bl) {
        return IlvSwingUtil.a(string, bl, false, true, true);
    }

    public static String escapeForHTMLAttribute(String string, boolean bl) {
        return IlvSwingUtil.a(string, bl, true, false, false);
    }

    public static String escapeForHTMLElementVariableSpaces(String string, boolean bl) {
        return IlvSwingUtil.a(string, bl, false, true, false);
    }

    public static String createMultiLineToolTipText(String[] stringArray, int n) {
        String string;
        switch (n) {
            case 2: {
                string = "left";
                break;
            }
            case 4: {
                string = "right";
                break;
            }
            case 0: {
                string = "center";
                break;
            }
            case 10: {
                string = "leading";
                break;
            }
            case 11: {
                string = "trailing";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported alignment: " + n + " (must be javax.swing.SwingConstants.LEFT, RIGHT, or CENTER)");
            }
        }
        Font font = UIManager.getFont("ToolTip.font");
        StringBuffer stringBuffer = new StringBuffer("<p align=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" style=\"font-family:");
        stringBuffer.append(font.getName());
        stringBuffer.append(";font-size:");
        stringBuffer.append(font.getSize());
        stringBuffer.append("pt\">");
        String string2 = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer("<html>");
        for (String string3 : stringArray) {
            stringBuffer2.append(string2);
            stringBuffer2.append(string3);
            stringBuffer2.append("</p>");
        }
        stringBuffer2.append("</html>");
        return stringBuffer2.toString();
    }

    public static String createMultiLineToolTipText(String string, int n) {
        String[] stringArray;
        int n2 = string.indexOf(10);
        if (n2 < 0) {
            return string;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if ("\n".equals(stringArray)) {
                arrayList.add(IlvSwingUtil.escapeForHTMLElementVariableSpaces(string2, false));
                string2 = "";
                continue;
            }
            string2 = stringArray;
        }
        arrayList.add(IlvSwingUtil.escapeForHTMLElementVariableSpaces(string2, false));
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        return IlvSwingUtil.createMultiLineToolTipText(stringArray, n);
    }

    public static String createMultiLineToolTipText(String string, int n, int n2) {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setTipText(string);
        if (jToolTip.getPreferredSize().width > n) {
            String string2;
            switch (n2) {
                case 2: {
                    string2 = "left";
                    break;
                }
                case 4: {
                    string2 = "right";
                    break;
                }
                case 0: {
                    string2 = "center";
                    break;
                }
                case 10: {
                    string2 = "leading";
                    break;
                }
                case 11: {
                    string2 = "trailing";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported alignment: " + n2 + " (must be javax.swing.SwingConstants.LEFT, RIGHT, or CENTER)");
                }
            }
            return "<html><div width=\"" + n + "\" align=\"" + string2 + "\">" + IlvSwingUtil.escapeForHTMLElementVariableSpaces(string, false) + "</div></html>";
        }
        return string;
    }

    public static String unescapeHTMLCharacterData(String string) {
        int n = 0;
        int n2 = string.indexOf("&");
        if (n2 < 0) {
            return string;
        }
        int n3 = string.indexOf(";", n2);
        if (n3 < 0) {
            return string;
        }
        IlvSwingUtil.a();
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 >= 0 && n3 >= 0) {
            if (n2 > n) {
                stringBuffer.append(string.substring(n, n2));
            }
            if (n3 > n2 + 1) {
                String string2 = string.substring(n2 + 1, n3);
                boolean bl = false;
                Integer n4 = c.get(string2);
                if (n4 != null) {
                    stringBuffer.append((char)n4.intValue());
                    bl = true;
                } else if (string2.charAt(0) == '#') {
                    char c;
                    int n5;
                    int n6 = string2.length();
                    int n7 = 0;
                    if (n6 > 3 && string2.charAt(1) == 'x') {
                        bl = true;
                        for (n5 = 2; n5 < n6; ++n5) {
                            c = string2.charAt(n5);
                            if (c >= '0' && c <= '9') {
                                n7 = n7 * 16 + (c - 48);
                                continue;
                            }
                            if (c >= 'A' && c <= 'F') {
                                n7 = n7 * 16 + (10 + c - 65);
                                continue;
                            }
                            if (c >= 'a' && c <= 'f') {
                                n7 = n7 * 16 + (10 + c - 97);
                                continue;
                            }
                            bl = false;
                            break;
                        }
                    } else {
                        bl = true;
                        for (n5 = 1; n5 < n6; ++n5) {
                            c = string2.charAt(n5);
                            if (c < '0' || c > '9') {
                                bl = false;
                                break;
                            }
                            n7 = n7 * 10 + (c - 48);
                        }
                    }
                    if (bl && (n7 < 0 || n7 > 0x10FFFF)) {
                        bl = false;
                    }
                    if (bl) {
                        if (n7 < 65536) {
                            stringBuffer.append((char)n7);
                        } else {
                            stringBuffer.append((char)(55296 + (n7 - 65536 >> 10)));
                            stringBuffer.append((char)(56320 + (n7 - 65536 & 0x3FF)));
                        }
                    }
                }
                if (!bl) {
                    stringBuffer.append("&");
                    stringBuffer.append(string2);
                    stringBuffer.append(";");
                }
            } else {
                stringBuffer.append("&;");
            }
            n = n3 + 1;
            n2 = string.indexOf("&", n);
            n3 = string.indexOf(";", n2);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private static void a() {
        if (c != null) {
            return;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("quot", 34);
        hashMap.put("amp", 38);
        hashMap.put("lt", 60);
        hashMap.put("gt", 62);
        hashMap.put("nbsp", 160);
        hashMap.put("iexcl", 161);
        hashMap.put("cent", 162);
        hashMap.put("pound", 163);
        hashMap.put("curren", 164);
        hashMap.put("yen", 165);
        hashMap.put("brvbar", 166);
        hashMap.put("sect", 167);
        hashMap.put("uml", 168);
        hashMap.put("copy", 169);
        hashMap.put("ordf", 170);
        hashMap.put("laquo", 171);
        hashMap.put("not", 172);
        hashMap.put("shy", 173);
        hashMap.put("reg", 174);
        hashMap.put("macr", 175);
        hashMap.put("deg", 176);
        hashMap.put("plusmn", 177);
        hashMap.put("sup2", 178);
        hashMap.put("sup3", 179);
        hashMap.put("acute", 180);
        hashMap.put("micro", 181);
        hashMap.put("para", 182);
        hashMap.put("middot", 183);
        hashMap.put("cedil", 184);
        hashMap.put("sup1", 185);
        hashMap.put("ordm", 186);
        hashMap.put("raquo", 187);
        hashMap.put("frac14", 188);
        hashMap.put("frac12", 189);
        hashMap.put("frac34", 190);
        hashMap.put("iquest", 191);
        hashMap.put("Agrave", 192);
        hashMap.put("Aacute", 193);
        hashMap.put("Acirc", 194);
        hashMap.put("Atilde", 195);
        hashMap.put("Auml", 196);
        hashMap.put("Aring", 197);
        hashMap.put("AElig", 198);
        hashMap.put("Ccedil", 199);
        hashMap.put("Egrave", 200);
        hashMap.put("Eacute", 201);
        hashMap.put("Ecirc", 202);
        hashMap.put("Euml", 203);
        hashMap.put("Igrave", 204);
        hashMap.put("Iacute", 205);
        hashMap.put("Icirc", 206);
        hashMap.put("Iuml", 207);
        hashMap.put("ETH", 208);
        hashMap.put("Ntilde", 209);
        hashMap.put("Ograve", 210);
        hashMap.put("Oacute", 211);
        hashMap.put("Ocirc", 212);
        hashMap.put("Otilde", 213);
        hashMap.put("Ouml", 214);
        hashMap.put("times", 215);
        hashMap.put("Oslash", 216);
        hashMap.put("Ugrave", 217);
        hashMap.put("Uacute", 218);
        hashMap.put("Ucirc", 219);
        hashMap.put("Uuml", 220);
        hashMap.put("Yacute", 221);
        hashMap.put("THORN", 222);
        hashMap.put("szlig", 223);
        hashMap.put("agrave", 224);
        hashMap.put("aacute", 225);
        hashMap.put("acirc", 226);
        hashMap.put("atilde", 227);
        hashMap.put("auml", 228);
        hashMap.put("aring", 229);
        hashMap.put("aelig", 230);
        hashMap.put("ccedil", 231);
        hashMap.put("egrave", 232);
        hashMap.put("eacute", 233);
        hashMap.put("ecirc", 234);
        hashMap.put("euml", 235);
        hashMap.put("igrave", 236);
        hashMap.put("iacute", 237);
        hashMap.put("icirc", 238);
        hashMap.put("iuml", 239);
        hashMap.put("eth", 240);
        hashMap.put("ntilde", 241);
        hashMap.put("ograve", 242);
        hashMap.put("oacute", 243);
        hashMap.put("ocirc", 244);
        hashMap.put("otilde", 245);
        hashMap.put("ouml", 246);
        hashMap.put("divide", 247);
        hashMap.put("oslash", 248);
        hashMap.put("ugrave", 249);
        hashMap.put("uacute", 250);
        hashMap.put("ucirc", 251);
        hashMap.put("uuml", 252);
        hashMap.put("yacute", 253);
        hashMap.put("thorn", 254);
        hashMap.put("yuml", 255);
        hashMap.put("Alpha", 913);
        hashMap.put("alpha", 945);
        hashMap.put("Beta", 914);
        hashMap.put("beta", 946);
        hashMap.put("Gamma", 915);
        hashMap.put("gamma", 947);
        hashMap.put("Delta", 916);
        hashMap.put("delta", 948);
        hashMap.put("Epsilon", 917);
        hashMap.put("epsilon", 949);
        hashMap.put("Zeta", 918);
        hashMap.put("zeta", 950);
        hashMap.put("Eta", 919);
        hashMap.put("eta", 951);
        hashMap.put("Theta", 920);
        hashMap.put("theta", 952);
        hashMap.put("Iota", 921);
        hashMap.put("iota", 953);
        hashMap.put("Kappa", 922);
        hashMap.put("kappa", 954);
        hashMap.put("Lambda", 923);
        hashMap.put("lambda", 955);
        hashMap.put("Mu", 924);
        hashMap.put("mu", 956);
        hashMap.put("Nu", 925);
        hashMap.put("nu", 957);
        hashMap.put("Xi", 926);
        hashMap.put("xi", 958);
        hashMap.put("Omicron", 927);
        hashMap.put("omicron", 959);
        hashMap.put("Pi", 928);
        hashMap.put("pi", 960);
        hashMap.put("Rho", 929);
        hashMap.put("rho", 961);
        hashMap.put("Sigma", 931);
        hashMap.put("sigmaf", 962);
        hashMap.put("sigma", 963);
        hashMap.put("Tau", 932);
        hashMap.put("tau", 964);
        hashMap.put("Upsilon", 933);
        hashMap.put("upsilon", 965);
        hashMap.put("Phi", 934);
        hashMap.put("phi", 966);
        hashMap.put("Chi", 935);
        hashMap.put("chi", 967);
        hashMap.put("Psi", 936);
        hashMap.put("psi", 968);
        hashMap.put("Omega", 937);
        hashMap.put("omega", 969);
        hashMap.put("thetasym", 977);
        hashMap.put("upsih", 978);
        hashMap.put("piv", 982);
        hashMap.put("forall", 8704);
        hashMap.put("part", 8706);
        hashMap.put("exist", 8707);
        hashMap.put("empty", 8709);
        hashMap.put("nabla", 8711);
        hashMap.put("isin", 8712);
        hashMap.put("notin", 8713);
        hashMap.put("ni", 8715);
        hashMap.put("prod", 8719);
        hashMap.put("sum", 8721);
        hashMap.put("minus", 8722);
        hashMap.put("lowast", 8727);
        hashMap.put("radic", 8730);
        hashMap.put("prop", 8733);
        hashMap.put("infin", 8734);
        hashMap.put("ang", 8736);
        hashMap.put("and", 8743);
        hashMap.put("or", 8744);
        hashMap.put("cap", 8745);
        hashMap.put("cup", 8746);
        hashMap.put("int", 8747);
        hashMap.put("there4", 8756);
        hashMap.put("sim", 8764);
        hashMap.put("cong", 8773);
        hashMap.put("asymp", 8776);
        hashMap.put("ne", 8800);
        hashMap.put("equiv", 8801);
        hashMap.put("le", 8804);
        hashMap.put("ge", 8805);
        hashMap.put("sub", 8834);
        hashMap.put("sup", 8835);
        hashMap.put("nsub", 8836);
        hashMap.put("sube", 8838);
        hashMap.put("supe", 8839);
        hashMap.put("oplus", 8853);
        hashMap.put("otimes", 8855);
        hashMap.put("perp", 8869);
        hashMap.put("sdot", 8901);
        hashMap.put("loz", 9674);
        hashMap.put("lceil", 8968);
        hashMap.put("rceil", 8969);
        hashMap.put("lfloor", 8970);
        hashMap.put("rfloor", 8971);
        hashMap.put("lang", 9001);
        hashMap.put("rang", 9002);
        hashMap.put("larr", 8592);
        hashMap.put("uarr", 8593);
        hashMap.put("rarr", 8594);
        hashMap.put("darr", 8595);
        hashMap.put("harr", 8596);
        hashMap.put("crarr", 8629);
        hashMap.put("lArr", 8656);
        hashMap.put("uArr", 8657);
        hashMap.put("rArr", 8658);
        hashMap.put("dArr", 8659);
        hashMap.put("hArr", 8660);
        hashMap.put("bull", 8226);
        hashMap.put("prime", 8242);
        hashMap.put("Prime", 8243);
        hashMap.put("oline", 8254);
        hashMap.put("frasl", 8260);
        hashMap.put("weierp", 8472);
        hashMap.put("image", 8465);
        hashMap.put("real", 8476);
        hashMap.put("trade", 8482);
        hashMap.put("euro", 8364);
        hashMap.put("alefsym", 8501);
        hashMap.put("spades", 9824);
        hashMap.put("clubs", 9827);
        hashMap.put("hearts", 9829);
        hashMap.put("diams", 9830);
        hashMap.put("OElig", 338);
        hashMap.put("oelig", 339);
        hashMap.put("Scaron", 352);
        hashMap.put("scaron", 353);
        hashMap.put("Yuml", 376);
        hashMap.put("fnof", 402);
        hashMap.put("ensp", 8194);
        hashMap.put("emsp", 8195);
        hashMap.put("thinsp", 8201);
        hashMap.put("zwnj", 8204);
        hashMap.put("zwj", 8205);
        hashMap.put("lrm", 8206);
        hashMap.put("rlm", 8207);
        hashMap.put("ndash", 8211);
        hashMap.put("mdash", 8212);
        hashMap.put("lsquo", 8216);
        hashMap.put("rsquo", 8217);
        hashMap.put("sbquo", 8218);
        hashMap.put("ldquo", 8220);
        hashMap.put("rdquo", 8221);
        hashMap.put("bdquo", 8222);
        hashMap.put("dagger", 8224);
        hashMap.put("Dagger", 8225);
        hashMap.put("hellip", 8230);
        hashMap.put("permil", 8240);
        hashMap.put("lsaquo", 8249);
        hashMap.put("circ", 710);
        hashMap.put("tilde", 732);
        c = hashMap;
    }

    public static Locale getDefaultLocale() {
        return IlvLocaleUtil.getCurrentLocale();
    }

    public static void setDefaultLocale(Locale locale) {
        JComponent.setDefaultLocale(locale);
        UIManager.getDefaults().setDefaultLocale(locale);
        Locale.setDefault(locale);
    }

    public static void setDefaultULocale(ULocale uLocale) {
        Locale locale = uLocale.toLocale();
        JComponent.setDefaultLocale(locale);
        UIManager.getDefaults().setDefaultLocale(locale);
        ULocale.setDefault((ULocale)uLocale);
    }

    public static void updateComponentTreeOrientation(Component component, ComponentOrientation componentOrientation) {
        component.applyComponentOrientation(componentOrientation);
        if (component.isShowing()) {
            component.validate();
            component.repaint();
        }
    }

    public static boolean isAppropriateLookAndFeel(String string) {
        if (string.indexOf("Motif") >= 0 || string.indexOf("plaf.gtk.GTK") >= 0) {
            return false;
        }
        return string.indexOf("plaf.windows.Windows") < 0 || !System.getProperty("os.name").startsWith("Windows 7") || !System.getProperty("java.vm.vendor").contains("IBM") || !System.getProperty("java.version").startsWith("1.5");
    }

    public static String getDefaultAppropriateLookAndFeelClassName() {
        String string = UIManager.getSystemLookAndFeelClassName();
        if (!IlvSwingUtil.isAppropriateLookAndFeel(string)) {
            string = UIManager.getCrossPlatformLookAndFeelClassName();
        }
        return string;
    }

    @NoWarning(value={"java.util.Locale.getDefault()"})
    public static void setDefaultAppropriateLookAndFeel() {
        if (Locale.getDefault().getLanguage().equals("ja")) {
            GraphicsEnvironment.getLocalGraphicsEnvironment().preferLocaleFonts();
        }
        String string = IlvSwingUtil.getDefaultAppropriateLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            System.err.println("Incorrect look and feel name " + string + ". " + "Using cross platform look and feel.");
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public static URL getRelativeURL(JApplet jApplet, String string) throws MalformedURLException {
        URL uRL = null;
        try {
            uRL = jApplet.getDocumentBase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRL != null) {
            return new URL(uRL, string);
        }
        return new URL("file:" + string);
    }

    private static boolean a(String string) {
        try {
            Class.forName(string);
            if (b != null) {
                b.println("  " + string + " exists");
            }
            return true;
        }
        catch (Throwable throwable) {
            if (b != null) {
                b.println("  " + string + " could not be instantiated");
            }
            return false;
        }
    }

    private static boolean a(String string, String string2, Class[] classArray) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
            if (b != null) {
                b.println("  " + string + " exists");
            }
        }
        catch (Throwable throwable) {
            if (b != null) {
                b.println("  " + string + " could not be instantiated");
            }
            return false;
        }
        try {
            clazz.getDeclaredMethod(string2, classArray);
            if (b != null) {
                b.println("  " + string + "." + string2 + "() exists");
            }
        }
        catch (Throwable throwable) {
            if (b != null) {
                b.println("  " + string + "." + string2 + "() not found");
            }
            return false;
        }
        return true;
    }

    private static Version b() {
        if (b != null) {
            b.println("Computing Swing version");
        }
        if (!IlvSwingUtil.a("javax.swing.JComponent")) {
            return new Version(0, 0, 0);
        }
        if (!IlvSwingUtil.a("javax.swing.SizeSequence")) {
            if (IlvSwingUtil.a("javax.swing.JSplitPane", "isValidateRoot", new Class[0])) {
                return new Version(1, 1, 1);
            }
            return new Version(1, 1, 0);
        }
        if (!IlvSwingUtil.a("javax.swing.JSpinner")) {
            Class[] classArray = new Class[]{FocusEvent.class};
            if (IlvSwingUtil.a("javax.swing.JMenu", "processFocusEvent", classArray)) {
                return new Version(1, 3, 1);
            }
            return new Version(1, 3, 0);
        }
        int[] nArray = new int[]{0, 0, 0, 0};
        String string = System.getProperty("java.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        for (int i = 0; i < nArray.length && stringTokenizer.hasMoreTokens(); ++i) {
            int n;
            String string2 = stringTokenizer.nextToken().trim();
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    nArray[i] = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Error parsing \"" + string2 + "\" in java version: " + string);
                }
                continue;
            }
            String string3 = "0123456789";
            String string4 = "-_ ";
            String string5 = "";
            for (n = 0; n < string2.length() && string3.indexOf(string2.charAt(n)) >= 0; ++n) {
                string5 = string5 + string2.charAt(n);
            }
            if (n == 0) {
                System.err.println("Error parsing \"" + string2 + "\" in java version: " + string);
            } else {
                try {
                    nArray[i] = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Error parsing \"" + string5 + "\" in java version: " + string);
                }
            }
            if (i + 1 >= nArray.length) continue;
            while (n < string2.length() && string4.indexOf(string2.charAt(n)) >= 0) {
                ++n;
            }
            String string6 = "";
            while (n < string2.length() && string3.indexOf(string2.charAt(n)) >= 0) {
                string6 = string6 + string2.charAt(n);
                ++n;
            }
            if (string6.length() <= 0) continue;
            try {
                nArray[nArray.length - 1] = Integer.parseInt(string6);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error parsing \"" + string6 + "\" in java version: " + string);
            }
        }
        return new Version(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static Version getSwingVersion() {
        if (d == null) {
            d = IlvSwingUtil.b();
            if (b != null) {
                b.println("  version: " + d);
            }
        }
        return d;
    }

    public static void showErrorDialog(Component component, String string) {
        IlvSwingUtil.showErrorDialog(component, string, null);
    }

    public static void showErrorDialog(Component component, Throwable throwable) {
        IlvSwingUtil.showErrorDialog(component, null, throwable);
    }

    public static void showErrorDialog(Component component, String string, Throwable throwable) {
        IlvSwingUtil.showDialog(component, string, null, 0, throwable);
    }

    public static void showWarningDialog(Component component, String string) {
        IlvSwingUtil.showWarningDialog(component, string, null);
    }

    public static void showWarningDialog(Component component, String string, Object object) {
        IlvSwingUtil.showDialog(component, string, object, 2, null);
    }

    public static void showInformationDialog(Component component, String string) {
        IlvSwingUtil.showInformationDialog(component, string, null);
    }

    public static void showInformationDialog(Component component, String string, Object object) {
        IlvSwingUtil.showDialog(component, string, object, 1, null);
    }

    public static void showDialog(Component component, String string, Object object, int n, Throwable throwable) {
        Object[] objectArray;
        Object[] objectArray2;
        Object object2;
        Object object3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string != null) {
            arrayList.add(string);
        }
        Throwable throwable2 = null;
        while (throwable != null) {
            arrayList.add(throwable);
            throwable2 = throwable;
            throwable = throwable.getCause();
        }
        String string2 = null;
        if (throwable2 != null) {
            try {
                object3 = new ByteArrayOutputStream();
                object2 = new PrintWriter((OutputStream)object3);
                throwable2.printStackTrace((PrintWriter)object2);
                ((PrintWriter)object2).close();
                ((ByteArrayOutputStream)object3).close();
                string2 = ((ByteArrayOutputStream)object3).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object3 = arrayList.toArray();
        object2 = null;
        switch (n) {
            case 0: {
                object2 = IlvSwingUtil.b("ErrorDialog.Title");
                break;
            }
            case 1: {
                object2 = IlvSwingUtil.b("InformationDialog.Title");
                break;
            }
            case 2: {
                object2 = IlvSwingUtil.b("WarningDialog.Title");
                break;
            }
            case 3: {
                object2 = IlvSwingUtil.b("QuestionDialog.Title");
                break;
            }
            case -1: {
                object2 = IlvSwingUtil.b("PlainDialog.Title");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported dialogType: " + n);
            }
        }
        HashMap<KeyStroke, Object> hashMap = new HashMap<KeyStroke, Object>();
        hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("ErrorDialog.CloseButtonMnemonic1")), IlvSwingUtil.b("ErrorDialog.CloseButtonLabel"));
        hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("ErrorDialog.CloseButtonMnemonic2")), IlvSwingUtil.b("ErrorDialog.CloseButtonLabel"));
        hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("ErrorDialog.CloseButtonMnemonic3")), IlvSwingUtil.b("ErrorDialog.CloseButtonLabel"));
        if (string2 != null) {
            hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("ErrorDialog.StackTraceButtonMnemonic1")), IlvSwingUtil.b("ErrorDialog.StackTraceButtonLabel"));
            hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("ErrorDialog.StackTraceButtonMnemonic2")), IlvSwingUtil.b("ErrorDialog.StackTraceButtonLabel"));
        }
        if (object != null) {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = object3;
            objectArray2 = objectArray3;
            objectArray3[1] = object;
        } else {
            objectArray2 = object3;
        }
        if (string2 != null) {
            Object[] objectArray4 = new Object[2];
            objectArray4[0] = IlvSwingUtil.b("ErrorDialog.CloseButtonLabel");
            objectArray = objectArray4;
            objectArray4[1] = IlvSwingUtil.b("ErrorDialog.StackTraceButtonLabel");
        } else {
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = IlvSwingUtil.b("ErrorDialog.CloseButtonLabel");
        }
        int n2 = IlvSwingUtil.showOptionDialog(component, objectArray2, (String)object2, 0, n, null, objectArray, null, null, hashMap);
        if (n2 == 1) {
            JTextArea jTextArea = new JTextArea(string2, 10, 80);
            jTextArea.setEditable(false);
            jTextArea.setFocusable(false);
            hashMap = new HashMap();
            hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("ErrorDialog.StackTraceCloseButtonMnemonic1")), IlvSwingUtil.b("ErrorDialog.StackTraceCloseButton"));
            hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("ErrorDialog.StackTraceCloseButtonMnemonic2")), IlvSwingUtil.b("ErrorDialog.StackTraceCloseButton"));
            hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("ErrorDialog.StackTracePrintButtonMnemonic1")), IlvSwingUtil.b("ErrorDialog.StackTracePrintButton"));
            hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("ErrorDialog.StackTracePrintButtonMnemonic2")), IlvSwingUtil.b("ErrorDialog.StackTracePrintButton"));
            n2 = IlvSwingUtil.showOptionDialog(component, new Object[]{IlvSwingUtil.b("ErrorDialog.StackTraceLabel"), new JScrollPane(jTextArea)}, IlvSwingUtil.b("ErrorDialog.StackTraceTitle"), 0, n, null, new Object[]{IlvSwingUtil.b("ErrorDialog.StackTraceCloseButton"), IlvSwingUtil.b("ErrorDialog.StackTracePrintButton")}, null, null, hashMap);
            if (n2 == 1) {
                throwable2.printStackTrace();
            }
        }
    }

    public static Object showInputDialog(Component component, Object object, String string, int n, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n, 2, icon, null, null);
        jOptionPane.setWantsInput(true);
        jOptionPane.setSelectionValues(objectArray);
        jOptionPane.setInitialSelectionValue(object2);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.setResizable(true);
        jOptionPane.selectInitialValue();
        jDialog.setVisible(true);
        Object object3 = jOptionPane.getInputValue();
        jDialog.dispose();
        return object3 == JOptionPane.UNINITIALIZED_VALUE ? null : object3;
    }

    private static String b(String string) {
        return IlvResourceUtil.getString(string, IlvSwingUtil.class, IlvLocaleUtil.getCurrentLocale());
    }

    public static int showYesNoCancelDialog(Component component, Object object, String string, Icon icon) throws HeadlessException {
        return IlvSwingUtil.a(component, object, string, 1, 3, icon);
    }

    public static int showYesNoDialog(Component component, Object object, String string, Icon icon) throws HeadlessException {
        return IlvSwingUtil.a(component, object, string, 0, 3, icon);
    }

    private static int a(Component component, Object object, String string, int n, int n2, Icon icon) throws HeadlessException {
        HashMap<KeyStroke, Object> hashMap = new HashMap<KeyStroke, Object>();
        hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("YesNoCancelDialog.YesMnemonic1")), 0);
        hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("YesNoCancelDialog.YesMnemonic2")), 0);
        hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("YesNoCancelDialog.NoMnemonic1")), 1);
        hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("YesNoCancelDialog.NoMnemonic2")), 1);
        if (n == 1) {
            hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("YesNoCancelDialog.CancelMnemonic1")), 2);
            hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("YesNoCancelDialog.CancelMnemonic2")), 2);
            hashMap.put(KeyStroke.getKeyStroke(IlvSwingUtil.b("YesNoCancelDialog.CancelMnemonic3")), 2);
        }
        return IlvSwingUtil.showOptionDialog(component, object, string, n, n2, icon, null, null, null, hashMap);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2, Component component2, HashMap<KeyStroke, Object> hashMap) throws HeadlessException {
        Object object3;
        final JOptionPane jOptionPane = new JOptionPane(object, n2, n, icon, objectArray, object2);
        jOptionPane.setInitialValue(object2);
        Component component3 = component == null ? JOptionPane.getRootFrame() : component;
        jOptionPane.setComponentOrientation(component3.getComponentOrientation());
        final JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.setResizable(true);
        if (hashMap != null) {
            object3 = jOptionPane.getInputMap(2);
            ActionMap actionMap = jOptionPane.getActionMap();
            for (Map.Entry<KeyStroke, Object> entry : hashMap.entrySet()) {
                KeyStroke keyStroke = entry.getKey();
                final Object object4 = entry.getValue();
                String string2 = "showOptionDialog" + object4.toString();
                ((InputMap)object3).put(keyStroke, string2);
                if (actionMap.get(string2) != null) continue;
                actionMap.put(string2, new AbstractAction(string2){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jOptionPane.setValue(object4);
                        if (jDialog.isVisible()) {
                            jDialog.setVisible(false);
                        }
                    }
                });
            }
            IlvSwingUtil.a(jDialog.getContentPane(), hashMap);
        }
        if (component2 != null) {
            jDialog.getContentPane().add(component2, "South");
        }
        jDialog.pack();
        jOptionPane.selectInitialValue();
        jDialog.setVisible(true);
        jDialog.dispose();
        object3 = jOptionPane.getValue();
        if (object3 == null) {
            return -1;
        }
        if (objectArray == null) {
            if (object3 instanceof Integer) {
                return (Integer)object3;
            }
            return -1;
        }
        int n3 = objectArray.length;
        for (int i = 0; i < n3; ++i) {
            if (!objectArray[i].equals(object3)) continue;
            return i;
        }
        return -1;
    }

    private static void a(Component component, HashMap<KeyStroke, Object> hashMap) {
        Component[] componentArray;
        String string;
        if (component instanceof JButton && (string = (componentArray = (Component[])component).getText()) != null) {
            for (Map.Entry<KeyStroke, Object> entry : hashMap.entrySet()) {
                char c;
                KeyStroke keyStroke = entry.getKey();
                Object object = entry.getValue();
                if (!string.equals(object) || (c = keyStroke.getKeyChar()) == '\uffff' || keyStroke.getModifiers() != 0 || string.indexOf(c) < 0) continue;
                componentArray.setMnemonic(c);
            }
        }
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                IlvSwingUtil.a(componentArray[i], hashMap);
            }
        }
    }

    private static Robot c() {
        try {
            if (a == null) {
                a = new Robot();
            }
            return a;
        }
        catch (AWTException aWTException) {
            throw new IlvRuntimeException(aWTException);
        }
    }

    public static boolean isDispatchThread() {
        return EventQueue.isDispatchThread() || IlvEventThreadRegistry.isCustomEventThread(Thread.currentThread());
    }

    private static void b(final List<Runnable> list) {
        if (list.isEmpty()) {
            return;
        }
        final Runnable runnable = list.remove(0);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                runnable.run();
                if (!list.isEmpty()) {
                    IlvSwingUtil.b(list);
                }
            }
        });
    }

    public static void invokeLater(List<Runnable> list) {
        LinkedList<Runnable> linkedList = new LinkedList<Runnable>(list);
        IlvSwingUtil.b(linkedList);
    }

    public static void invokeLater(final Runnable runnable) {
        final boolean bl = IlvEnvironmentUtil.isWebServerThread();
        final ULocale uLocale = IlvLocaleUtil.getCurrentULocale();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                IlvEnvironmentUtil.setWebServerThread(bl);
                if (uLocale != null) {
                    IlvLocaleUtil.setThreadULocale(uLocale);
                }
                try {
                    runnable.run();
                }
                finally {
                    if (uLocale != null) {
                        IlvLocaleUtil.setThreadULocale(null);
                    }
                    IlvEnvironmentUtil.setWebServerThread(false);
                }
            }
        });
    }

    public static void invokeNowOrLater(Runnable runnable) {
        if (IlvSwingUtil.isDispatchThread()) {
            runnable.run();
        } else {
            IlvSwingUtil.invokeLater(runnable);
        }
    }

    public static void invokeAndWait(final Runnable runnable) {
        if (IlvSwingUtil.isDispatchThread()) {
            runnable.run();
        } else {
            final boolean bl = IlvEnvironmentUtil.isWebServerThread();
            final ULocale uLocale = IlvLocaleUtil.getCurrentULocale();
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        IlvEnvironmentUtil.setWebServerThread(bl);
                        if (uLocale != null) {
                            IlvLocaleUtil.setThreadULocale(uLocale);
                        }
                        try {
                            runnable.run();
                        }
                        finally {
                            if (uLocale != null) {
                                IlvLocaleUtil.setThreadULocale(null);
                            }
                            IlvEnvironmentUtil.setWebServerThread(false);
                        }
                    }
                });
            }
            catch (Exception exception) {
                throw new IlvRuntimeException(exception, true);
            }
        }
    }

    public static void invokeAndWaitForIdle(Runnable runnable) {
        if (IlvSwingUtil.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
                IlvSwingUtil.c().waitForIdle();
            }
            catch (Exception exception) {
                throw new IlvRuntimeException(exception, true);
            }
        }
    }

    private static Container a(Component component) {
        Container container;
        Container container2 = container = component instanceof Container ? (Container)component : component.getParent();
        while (container != null) {
            if (container instanceof Window) {
                return container;
            }
            if (container instanceof IlvHiddenWindow) {
                return container;
            }
            if (container instanceof Applet) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    public static Point getLocationOnScreen(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        Container container = IlvSwingUtil.a(component);
        if (container == null) {
            throw new IllegalArgumentException("component not connected to component tree hierarchy");
        }
        int n = 0;
        int n2 = 0;
        while (component != container) {
            n += component.getX();
            n2 += component.getY();
            component = component.getParent();
        }
        Point point = container.getLocationOnScreen();
        return new Point(point.x + n, point.y + n2);
    }

    public static void convertPointToScreen(Point point, Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        Container container = IlvSwingUtil.a(component);
        if (container == null) {
            throw new IllegalArgumentException("component not connected to component tree hierarchy");
        }
        int n = 0;
        int n2 = 0;
        while (component != container) {
            n += component.getX();
            n2 += component.getY();
            component = component.getParent();
        }
        Point point2 = container.getLocationOnScreen();
        point.x += point2.x + n;
        point.y += point2.y + n2;
    }

    public static void convertPointFromScreen(Point point, Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        Container container = IlvSwingUtil.a(component);
        if (container == null) {
            throw new IllegalArgumentException("component not connected to component tree hierarchy");
        }
        int n = 0;
        int n2 = 0;
        while (component != container) {
            n += component.getX();
            n2 += component.getY();
            component = component.getParent();
        }
        Point point2 = container.getLocationOnScreen();
        point.x -= point2.x + n;
        point.y -= point2.y + n2;
    }

    public static Point convertPoint(Component component, Point point, Component component2) {
        if (component == null && component2 == null) {
            return point;
        }
        Container container = null;
        if (component != null && (container = IlvSwingUtil.a(component)) == null) {
            throw new IllegalArgumentException("Source component not connected to component tree hierarchy");
        }
        Container container2 = null;
        if (component2 != null && (container2 = IlvSwingUtil.a(component2)) == null) {
            throw new IllegalArgumentException("Destination component not connected to component tree hierarchy");
        }
        if (component == null) {
            component = container2;
            container = container2;
        }
        if (component2 == null) {
            component2 = container;
            container2 = container;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (component != container) {
            n += component.getX();
            n2 += component.getY();
            component = component.getParent();
        }
        while (component2 != container2) {
            n3 += component2.getX();
            n4 += component2.getY();
            component2 = component2.getParent();
        }
        if (container == container2) {
            return new Point(point.x + n - n3, point.y + n2 - n4);
        }
        Point point2 = container.getLocationOnScreen();
        Point point3 = container2.getLocationOnScreen();
        return new Point(point.x + n + point2.x - point3.x - n3, point.y + n2 + point2.y - point3.y - n4);
    }

    public static Rectangle convertRectangle(Component component, Rectangle rectangle, Component component2) {
        if (component == null && component2 == null) {
            return rectangle;
        }
        Container container = null;
        if (component != null && (container = IlvSwingUtil.a(component)) == null) {
            throw new IllegalArgumentException("Source component not connected to component tree hierarchy");
        }
        Container container2 = null;
        if (component2 != null && (container2 = IlvSwingUtil.a(component2)) == null) {
            throw new IllegalArgumentException("Destination component not connected to component tree hierarchy");
        }
        if (component == null) {
            component = container2;
            container = container2;
        }
        if (component2 == null) {
            component2 = container;
            container2 = container;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (component != container) {
            n += component.getX();
            n2 += component.getY();
            component = component.getParent();
        }
        while (component2 != container2) {
            n3 += component2.getX();
            n4 += component2.getY();
            component2 = component2.getParent();
        }
        if (container == container2) {
            return new Rectangle(rectangle.x + n - n3, rectangle.y + n2 - n4, rectangle.width, rectangle.height);
        }
        Point point = container.getLocationOnScreen();
        Point point2 = container2.getLocationOnScreen();
        return new Rectangle(rectangle.x + n + point.x - point2.x - n3, rectangle.y + n2 + point.y - point2.y - n4, rectangle.width, rectangle.height);
    }

    public static boolean isHighContrastMode() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Boolean bl = (Boolean)toolkit.getDesktopProperty("win.highContrast.on");
        return bl != null && bl != false;
    }

    public static Color getSystemColor(int n) {
        switch (n) {
            default: {
                return SystemColor.desktop;
            }
            case 1: {
                return SystemColor.activeCaption;
            }
            case 2: {
                return SystemColor.activeCaptionText;
            }
            case 3: {
                return SystemColor.activeCaptionBorder;
            }
            case 4: {
                return SystemColor.inactiveCaption;
            }
            case 5: {
                return SystemColor.inactiveCaptionText;
            }
            case 6: {
                return SystemColor.inactiveCaptionBorder;
            }
            case 7: {
                return SystemColor.window;
            }
            case 8: {
                return SystemColor.windowBorder;
            }
            case 9: {
                return SystemColor.windowText;
            }
            case 10: {
                return SystemColor.menu;
            }
            case 11: {
                return SystemColor.menuText;
            }
            case 12: {
                return SystemColor.text;
            }
            case 13: {
                return SystemColor.textText;
            }
            case 14: {
                return SystemColor.textHighlight;
            }
            case 15: {
                return SystemColor.textHighlightText;
            }
            case 16: {
                return SystemColor.textInactiveText;
            }
            case 17: {
                return SystemColor.control;
            }
            case 18: {
                return SystemColor.controlText;
            }
            case 19: {
                return SystemColor.controlHighlight;
            }
            case 20: {
                return SystemColor.controlLtHighlight;
            }
            case 21: {
                return SystemColor.controlShadow;
            }
            case 22: {
                return SystemColor.controlDkShadow;
            }
            case 23: {
                return SystemColor.scrollbar;
            }
            case 24: {
                return SystemColor.info;
            }
            case 25: 
        }
        return SystemColor.infoText;
    }

    public static void adjustPreferredSizeForTitledBorder(JComponent jComponent) {
        Border border = jComponent.getBorder();
        if (border instanceof TitledBorder && ((TitledBorder)border).getTitle() != null) {
            Dimension dimension = ((TitledBorder)border).getMinimumSize(jComponent);
            int n = 5 + dimension.width + 5;
            int n2 = dimension.height;
            Dimension dimension2 = jComponent.getMinimumSize();
            Dimension dimension3 = new Dimension(Math.max(dimension2.width, n), Math.max(dimension2.height, n2));
            jComponent.setMinimumSize(dimension3);
            Dimension dimension4 = jComponent.getPreferredSize();
            Dimension dimension5 = new Dimension(Math.max(dimension4.width, n), Math.max(dimension4.height, n2));
            jComponent.setPreferredSize(dimension5);
        }
    }

    public static void cleanupApplet() {
        Introspector.flushCaches();
        System.runFinalization();
        System.gc();
    }

    static {
        b = null;
        c = null;
        d = null;
    }

    public static class Version {
        private int[] a;
        private int b;

        public Version(int n, int n2, int n3, int n4) {
            if (n < 0 || n >= 100) {
                throw new IllegalArgumentException("Major version must be 0 <= " + n + " < 100");
            }
            if (n2 < 0 || n2 >= 100) {
                throw new IllegalArgumentException("Minor version must be 0 <= " + n2 + " < 100");
            }
            if (n3 < 0 || n3 >= 100) {
                throw new IllegalArgumentException("Major revision must be 0 <= " + n3 + " < 100");
            }
            if (n4 < 0 || n4 >= 100) {
                throw new IllegalArgumentException("Minor revision must be 0 <= " + n4 + " < 100");
            }
            this.a = new int[4];
            this.a[0] = n;
            this.a[1] = n2;
            this.a[2] = n3;
            this.a[3] = n4;
            this.b = 1000000 * n + 10000 * n2 + 100 * n3 + n4;
        }

        public Version(int n, int n2, int n3) {
            this(n, n2, n3, 0);
        }

        public int intValue() {
            return this.b;
        }

        public int compareTo(Version version) {
            int n;
            int n2 = this.intValue();
            return n2 < (n = version.intValue()) ? -1 : (n2 == n ? 0 : 1);
        }

        public boolean equals(Version version) {
            return this.compareTo(version) == 0;
        }

        public int hashCode() {
            return this.intValue();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.a[0]);
            stringBuffer.append('.');
            stringBuffer.append(this.a[1]);
            if (this.a[2] != 0 || this.a[3] != 0) {
                stringBuffer.append('.');
                stringBuffer.append(this.a[2]);
                if (this.a[3] != 0) {
                    stringBuffer.append('.');
                    stringBuffer.append(this.a[3]);
                }
            }
            return stringBuffer.toString();
        }
    }
}

