/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d.internal;

public class IlvGradientUtil {
    public static final int[] SRGBtoLinearRGB = new int[256];
    public static final int[] LinearRGBtoSRGB = new int[256];

    private static int a(int n) {
        float f = (float)n / 255.0f;
        float f2 = f <= 0.04045f ? f / 12.92f : (float)Math.pow(((double)f + 0.055) / 1.055, 2.4);
        int n2 = Math.round(f2 * 255.0f);
        return n2;
    }

    private static int b(int n) {
        float f = (float)n / 255.0f;
        float f2 = (double)f <= 0.0031308 ? f * 12.92f : 1.055f * (float)Math.pow(f, 0.4166666666666667) - 0.055f;
        int n2 = Math.round(f2 * 255.0f);
        return n2;
    }

    public static int convertEntireColorLinearRGBtoSRGB(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        n3 = LinearRGBtoSRGB[n3];
        n4 = LinearRGBtoSRGB[n4];
        n5 = LinearRGBtoSRGB[n5];
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static int convertEntireColorSRGBtoLinearRGB(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        n3 = SRGBtoLinearRGB[n3];
        n4 = SRGBtoLinearRGB[n4];
        n5 = SRGBtoLinearRGB[n5];
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static int interpolate(int n, int n2, float f) {
        int n3 = n >> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = (n2 >> 24 & 0xFF) - n3;
        int n8 = (n2 >> 16 & 0xFF) - n4;
        int n9 = (n2 >> 8 & 0xFF) - n5;
        int n10 = (n2 & 0xFF) - n6;
        return (int)((double)((float)n3 + f * (float)n7) + 0.5) << 24 | (int)((double)((float)n4 + f * (float)n8) + 0.5) << 16 | (int)((double)((float)n5 + f * (float)n9) + 0.5) << 8 | (int)((double)((float)n6 + f * (float)n10) + 0.5);
    }

    public static void interpolate(int n, int n2, int[] nArray) {
        int n3 = n >> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = (n2 >> 24 & 0xFF) - n3;
        int n8 = (n2 >> 16 & 0xFF) - n4;
        int n9 = (n2 >> 8 & 0xFF) - n5;
        int n10 = (n2 & 0xFF) - n6;
        float f = 1.0f / (float)nArray.length;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)((double)((float)n3 + (float)(i * n7) * f) + 0.5) << 24 | (int)((double)((float)n4 + (float)(i * n8) * f) + 0.5) << 16 | (int)((double)((float)n5 + (float)(i * n9) * f) + 0.5) << 8 | (int)((double)((float)n6 + (float)(i * n10) * f) + 0.5);
        }
    }

    private IlvGradientUtil() {
    }

    static {
        for (int i = 0; i < 256; ++i) {
            IlvGradientUtil.SRGBtoLinearRGB[i] = IlvGradientUtil.a(i);
            IlvGradientUtil.LinearRGBtoSRGB[i] = IlvGradientUtil.b(i);
        }
    }
}

