/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.internal;

import com.ibm.icu.text.IDNA;
import com.ibm.icu.text.StringPrepParseException;
import ilog.views.util.annotation.NoWarning;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class IlvURLUtil {
    public static URL convertFilenameToURL(String string) throws MalformedURLException {
        try {
            return new URI("file", string.replace(File.separatorChar, '/'), null).toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            return new URL("file:" + string);
        }
    }

    public static URL convertFilenameToURL(String string, boolean bl) throws MalformedURLException {
        if (bl) {
            return IlvURLUtil.convertFilenameToURL(string);
        }
        return new URL("file:" + string);
    }

    public static URL convertFilenameToAbsoluteURL(String string) throws MalformedURLException {
        return new File(string).toURI().toURL();
    }

    @NoWarning(value={"java.io.File.toURL()"})
    public static URL convertFilenameToAbsoluteURL(String string, boolean bl) throws MalformedURLException {
        if (bl) {
            return IlvURLUtil.convertFilenameToAbsoluteURL(string);
        }
        return new File(string).toURL();
    }

    public static URL convertFileToAbsoluteURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    @NoWarning(value={"java.io.File.toURL()"})
    public static URL convertFileToAbsoluteURL(File file, boolean bl) throws MalformedURLException {
        if (bl) {
            return IlvURLUtil.convertFileToAbsoluteURL(file);
        }
        return file.toURL();
    }

    private static String c(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            int n;
            int n2;
            int n3;
            char c;
            block13: {
                block12: {
                    c = string.charAt(i);
                    if ('!' == c || '$' == c || c >= '&' && c <= ':' || '=' == c || c >= '@' && c <= 'Z' || '_' == c || c >= 'a' && c <= 'z' || '~' == c) {
                        stringBuffer.append(c);
                        continue;
                    }
                    if (File.separatorChar == c) {
                        stringBuffer.append('/');
                        continue;
                    }
                    if (c < '\u0080') {
                        stringBuffer.append('%');
                        stringBuffer.append("0123456789ABCDEF".charAt(c >> 4));
                        stringBuffer.append("0123456789ABCDEF".charAt(c & 0xF));
                        continue;
                    }
                    if (c < '\u0800') {
                        n3 = 192 + (c >> 6);
                        n2 = 128 + (c & 0x3F);
                        stringBuffer.append('%');
                        stringBuffer.append("0123456789ABCDEF".charAt(n3 >> 4));
                        stringBuffer.append("0123456789ABCDEF".charAt(n3 & 0xF));
                        stringBuffer.append('%');
                        stringBuffer.append("0123456789ABCDEF".charAt(n2 >> 4));
                        stringBuffer.append("0123456789ABCDEF".charAt(n2 & 0xF));
                        continue;
                    }
                    if (c < '\ud800') break block12;
                    if (c > '\udbff' || i + 1 >= string.length()) break block12;
                    if (string.charAt(i + 1) < '\udc00') break block12;
                    if (string.charAt(i + 1) <= '\udfff') break block13;
                }
                assert (c < '\u10000');
                n3 = 224 + (c >> 12);
                n2 = 128 + (c >> 6 & 0x3F);
                n = 128 + (c & 0x3F);
                stringBuffer.append('%');
                stringBuffer.append("0123456789ABCDEF".charAt(n3 >> 4));
                stringBuffer.append("0123456789ABCDEF".charAt(n3 & 0xF));
                stringBuffer.append('%');
                stringBuffer.append("0123456789ABCDEF".charAt(n2 >> 4));
                stringBuffer.append("0123456789ABCDEF".charAt(n2 & 0xF));
                stringBuffer.append('%');
                stringBuffer.append("0123456789ABCDEF".charAt(n >> 4));
                stringBuffer.append("0123456789ABCDEF".charAt(n & 0xF));
                continue;
            }
            n3 = Character.toCodePoint(c, string.charAt(i + 1));
            assert (n3 >= 65536);
            n2 = 240 + (n3 >> 18);
            n = 128 + (n3 >> 12 & 0x3F);
            int n4 = 128 + (n3 >> 6 & 0x3F);
            int n5 = 128 + (n3 & 0x3F);
            stringBuffer.append('%');
            stringBuffer.append("0123456789ABCDEF".charAt(n2 >> 4));
            stringBuffer.append("0123456789ABCDEF".charAt(n2 & 0xF));
            stringBuffer.append('%');
            stringBuffer.append("0123456789ABCDEF".charAt(n >> 4));
            stringBuffer.append("0123456789ABCDEF".charAt(n & 0xF));
            stringBuffer.append('%');
            stringBuffer.append("0123456789ABCDEF".charAt(n4 >> 4));
            stringBuffer.append("0123456789ABCDEF".charAt(n4 & 0xF));
            stringBuffer.append('%');
            stringBuffer.append("0123456789ABCDEF".charAt(n5 >> 4));
            stringBuffer.append("0123456789ABCDEF".charAt(n5 & 0xF));
            ++i;
        }
        return stringBuffer.toString();
    }

    public static URL convertStringToURL(String string) throws MalformedURLException {
        if (string.startsWith("file:")) {
            if (string.indexOf(0) < 0 && string.indexOf(63) < 0 && string.indexOf(91) < 0 && string.indexOf(93) < 0) {
                try {
                    return new URI(string).toURL();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            try {
                return new URI(IlvURLUtil.c(string)).toURL();
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        return new URL(string);
    }

    public static String convertFileURLToFilename(URL uRL) {
        if (!"file".equals(uRL.getProtocol())) {
            throw new IllegalArgumentException("not a file URL: " + uRL);
        }
        String string = uRL.getPath();
        if (File.separatorChar != '/' && string.length() >= 2 && string.charAt(1) == ':' && Character.isLetter(string.charAt(0)) && (string.length() == 2 || string.charAt(2) == '/' || string.charAt(2) == File.separatorChar)) {
            string = "/" + string;
        }
        try {
            String string2 = new URI(string).getPath();
            if (string2 != null) {
                string = string2;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return File.separatorChar != '/' ? (string.length() >= 3 && string.charAt(0) == '/' && string.charAt(2) == ':' && Character.isLetter(string.charAt(1)) ? string.substring(1).replace('/', File.separatorChar) : string.replace('/', File.separatorChar)) : string;
    }

    public static File convertFileURLToFile(URL uRL) {
        return new File(IlvURLUtil.convertFileURLToFilename(uRL));
    }

    public static URL prepare(URL uRL) throws MalformedURLException {
        String string = uRL.getHost();
        if (string != null) {
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= ' ' && c <= '~') continue;
                bl = true;
                break;
            }
            if (bl) {
                String string2;
                try {
                    string2 = IDNA.convertIDNToASCII((String)string, (int)0).toString();
                }
                catch (StringPrepParseException stringPrepParseException) {
                    MalformedURLException malformedURLException = new MalformedURLException(stringPrepParseException.getMessage());
                    malformedURLException.initCause(stringPrepParseException);
                    throw malformedURLException;
                }
                return new URL(uRL.getProtocol(), string2, uRL.getPort(), uRL.getRef() != null ? uRL.getFile() + "#" + uRL.getRef() : uRL.getFile());
            }
        }
        return uRL;
    }

    public static URLConnection openConnection(URL uRL) throws IOException {
        return IlvURLUtil.prepare(uRL).openConnection();
    }

    public static InputStream openStream(URL uRL) throws IOException {
        InputStream inputStream = IlvURLUtil.prepare(uRL).openStream();
        if (inputStream != null) {
            return inputStream;
        }
        throw new FileNotFoundException(uRL.toString());
    }

    public static String escape(String string) {
        return IlvURLUtil.c(string);
    }

    public static String unescape(String string) {
        if (string.indexOf(37) >= 0) {
            try {
                String string2 = new URI(string).getPath();
                if (string2 != null) {
                    string = string2;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return string;
    }

    private static boolean d(String string) {
        return !string.equals("bundleresource");
    }

    private static String a(URL uRL) {
        String string = uRL.getPath();
        if (IlvURLUtil.d(uRL.getProtocol())) {
            string = IlvURLUtil.unescape(string);
        }
        return string;
    }

    public static String lastPathComponent(URL uRL) {
        String string = IlvURLUtil.a(uRL);
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ("file".equals(uRL.getProtocol()) && File.separatorChar != '/' && (n = string.lastIndexOf(File.separatorChar)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getRelativePath(URL uRL, URL uRL2) {
        if (uRL.getProtocol().equals(uRL2.getProtocol())) {
            String string;
            String string2 = uRL2.getPath();
            String string3 = uRL.getPath();
            String string4 = string2;
            String string5 = string3;
            if ("file".equals(uRL2.getProtocol()) && File.separatorChar != '/') {
                string4 = string2.replace(File.separatorChar, '/');
                string5 = string3.replace(File.separatorChar, '/');
            }
            if ((string = IlvURLUtil.a(string5, string4, "file".equals(uRL2.getProtocol()))) != null && !string.equals(string5)) {
                return string + (uRL.getQuery() != null ? "?" + uRL.getQuery() : "") + (uRL.getRef() != null ? "#" + uRL.getRef() : "");
            }
        }
        return null;
    }

    static String a(String string, String string2, boolean bl) {
        int n;
        String string3;
        int n2;
        if (string == null || string2 == null) {
            return null;
        }
        ArrayList<String> arrayList = IlvURLUtil.a(string);
        if (arrayList.size() == 0) {
            return null;
        }
        ArrayList<String> arrayList2 = IlvURLUtil.a(string2);
        if (arrayList2.size() == 0) {
            return null;
        }
        for (n2 = 0; n2 < arrayList2.size() && n2 < arrayList.size() && arrayList2.get(n2).equals(arrayList.get(n2)); ++n2) {
        }
        if (bl) {
            if (n2 == 0) {
                return null;
            }
            if (n2 == 1) {
                string3 = arrayList2.get(0);
                if (string3.substring(1).equals(":")) {
                    return null;
                }
            }
        }
        string3 = "";
        for (n = n2; n < arrayList2.size(); ++n) {
            string3 = string3 + "../";
        }
        for (n = n2; n < arrayList.size(); ++n) {
            string3 = string3 + arrayList.get(n) + "/";
        }
        String string4 = IlvURLUtil.b(string);
        if (string4 != null) {
            string3 = string3 + string4;
        }
        return string3;
    }

    static ArrayList<String> a(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2.length() == 0) continue;
            arrayList.add(string2);
        }
        int n = arrayList.size();
        if (n > 0) {
            if (!string.endsWith("/")) {
                arrayList.remove(n - 1);
            }
        }
        return arrayList;
    }

    static String b(String string) {
        if (string.endsWith("/")) {
            return null;
        }
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private IlvURLUtil() {
    }
}

