/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.tiling;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.tiling.IlvThreadedTileLoader;
import ilog.views.tiling.IlvTile;
import ilog.views.tiling.IlvTileController;
import ilog.views.tiling.IlvTileLoader;
import ilog.views.tiling.IlvTiledLayer;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Vector;

public class IlvFreeTile
extends IlvTile
implements IlvPersistentObject {
    private final Point2D.Double a;
    private final Point2D.Double b;
    private transient Rectangle2D.Double c;

    public IlvFreeTile(Point2D point2D, Point2D point2D2, IlvTileController ilvTileController) {
        this(point2D, point2D2, ilvTileController, -1, -1);
    }

    public IlvFreeTile(Point2D point2D, Point2D point2D2, IlvTileController ilvTileController, int n, int n2) {
        super(n, n2, ilvTileController);
        this.a = new Point2D.Double(point2D.getX(), point2D.getY());
        this.b = new Point2D.Double(point2D2.getX(), point2D2.getY());
    }

    public IlvFreeTile(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(-1, -1, null);
        this.a = new Point2D.Double();
        this.b = new Point2D.Double();
        this.a.x = ilvInputStream.readDouble("x1");
        this.a.y = ilvInputStream.readDouble("y1");
        this.b.x = ilvInputStream.readDouble("x2");
        this.b.y = ilvInputStream.readDouble("y2");
        ((IlvTile)this).a = ilvInputStream.readInt("column");
        ((IlvTile)this).b = ilvInputStream.readInt("row");
    }

    @Override
    boolean c(Object object) {
        this.g.removeElement(object);
        if (this.g.size() == 0) {
            this.d = 2;
            ((IlvTile)this).c.a((IlvTile)this, object);
            return true;
        }
        return false;
    }

    @Override
    public void boundingBox(IlvRect ilvRect) {
        ilvRect.x = (float)this.a.x;
        ilvRect.y = (float)this.a.y;
        ilvRect.width = (float)(this.b.x - this.a.x);
        ilvRect.height = (float)(this.b.y - this.a.y);
    }

    public void boundingPoints(Point2D.Double double_, Point2D.Double double_2) {
        double_.x = this.a.x;
        double_.y = this.a.y;
        double_2.x = this.b.x;
        double_2.y = this.b.y;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof IlvFreeTile)) {
            return false;
        }
        IlvFreeTile ilvFreeTile = (IlvFreeTile)object;
        return super.equals(object) && this.a.equals(ilvFreeTile.a) && this.b.equals(ilvFreeTile.b);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() {
        IlvTiledLayer ilvTiledLayer = ((IlvTile)this).c.getLayer();
        IlvRect ilvRect = new IlvRect();
        this.boundingBox(ilvRect);
        IlvTiledLayer ilvTiledLayer2 = ilvTiledLayer;
        synchronized (ilvTiledLayer2) {
            CollectObject collectObject = new CollectObject();
            ilvTiledLayer.mapIntersects(ilvRect, ilvRect, collectObject, null, null);
            int n = collectObject.a.size();
            for (int i = 0; i < n; ++i) {
                IlvGraphic ilvGraphic = (IlvGraphic)collectObject.a.elementAt(i);
                if (this.isObjectShared(ilvGraphic)) continue;
                this.removeObject(ilvGraphic);
            }
            collectObject = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reDraw() {
        IlvTiledLayer ilvTiledLayer = ((IlvTile)this).c.getLayer();
        IlvRect ilvRect = new IlvRect();
        this.boundingBox(ilvRect);
        IlvRect ilvRect2 = new IlvRect();
        IlvTiledLayer ilvTiledLayer2 = ilvTiledLayer;
        synchronized (ilvTiledLayer2) {
            ilvTiledLayer.mapIntersects(ilvRect, ilvRect, new IlvApplyObject(){

                @Override
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvRect ilvRect = (IlvRect)object;
                    if (ilvRect.isEmpty()) {
                        IlvRect ilvRect2 = ilvGraphic.boundingBox(null);
                        ilvRect.x = ilvRect2.x;
                        ilvRect.y = ilvRect2.y;
                        ilvRect.width = ilvRect2.width;
                        ilvRect.height = ilvRect2.height;
                    } else {
                        ilvRect.add(ilvGraphic.boundingBox(null));
                    }
                }
            }, ilvRect2, null);
        }
        ilvTiledLayer.getManager().initReDraws();
        try {
            ilvTiledLayer.getManager().invalidateRegion(ilvRect2);
        }
        finally {
            ilvTiledLayer.getManager().reDrawViews();
        }
    }

    @Override
    public boolean isObjectShared(IlvGraphic ilvGraphic) {
        _isObjectSharedInternalStruct _isObjectSharedInternalStruct2 = new _isObjectSharedInternalStruct();
        _isObjectSharedInternalStruct2.objBbox = ilvGraphic.boundingBox(null);
        _isObjectSharedInternalStruct2.refTile = this;
        Collection collection = ((IlvTile)this).c.getIntersectingTiles(_isObjectSharedInternalStruct2.objBbox);
        int n = collection.size();
        if (n > ((IlvTile)this).c.f()) {
            return ((IlvTile)this).c.a(new IlvTileController.MatchFunction(){

                @Override
                public boolean apply(IlvTile ilvTile, Object object) {
                    _isObjectSharedInternalStruct _isObjectSharedInternalStruct2 = (_isObjectSharedInternalStruct)object;
                    ilvTile.boundingBox(_isObjectSharedInternalStruct2.bbox);
                    return _isObjectSharedInternalStruct2.bbox.intersects(_isObjectSharedInternalStruct2.objBbox) && ilvTile != _isObjectSharedInternalStruct2.refTile && ilvTile.getStatus() != 0;
                }
            }, (Object)_isObjectSharedInternalStruct2);
        }
        for (IlvTile ilvTile : collection) {
            if (ilvTile.d == 0 || ilvTile == this) continue;
            IlvTileLoader ilvTileLoader = ilvTile.getController().getTileLoader();
            if (ilvTileLoader != null && ilvTileLoader instanceof IlvThreadedTileLoader) {
                ((IlvThreadedTileLoader)ilvTileLoader).addNonCancellableTask(ilvTile);
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.a + " " + this.b + ") " + ((IlvTile)this).c;
    }

    void b() {
        this.d = 0;
        this.e = false;
    }

    void a(IlvTileController ilvTileController) {
        ((IlvTile)this).c = ilvTileController;
    }

    boolean a(IlvRect ilvRect) {
        if (this.c == null) {
            this.c = new Rectangle2D.Double(this.a.x, this.a.y, this.b.x - this.a.x, this.b.y - this.a.y);
        }
        return this.c.intersects(ilvRect);
    }

    public boolean isPersistent() {
        return true;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("x1", this.a.x);
        ilvOutputStream.write("y1", this.a.y);
        ilvOutputStream.write("x2", this.b.x);
        ilvOutputStream.write("y2", this.b.y);
        ilvOutputStream.write("column", ((IlvTile)this).a);
        ilvOutputStream.write("row", ((IlvTile)this).b);
    }

    private class _isObjectSharedInternalStruct {
        public IlvRect objBbox;
        public IlvTile refTile;
        public IlvRect bbox = new IlvRect();
    }

    final class CollectObject
    implements IlvApplyObject {
        Vector a = new Vector(16);

        CollectObject() {
        }

        @Override
        public final void apply(IlvGraphic ilvGraphic, Object object) {
            this.a.addElement(ilvGraphic);
        }
    }
}

