/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.editor.internal;

import ilog.views.IlvDefinitionRectInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.beans.editor.IlvShapePropertyEditor;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleModel;
import ilog.views.css.model.IlvRuleUtils;
import ilog.views.css.model.IlvSelector;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.graphic.IlvEllipse;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvLine;
import ilog.views.graphic.IlvPolyPoints;
import ilog.views.graphic.IlvPolygon;
import ilog.views.graphic.IlvPolyline;
import ilog.views.graphic.IlvRectangle;
import ilog.views.graphic.IlvSpline;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.layout.IlvAttachableGraphic;
import ilog.views.graphic.composite.layout.IlvAttachmentBounds;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLayout;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.interactor.IlvSelectInteractor;
import ilog.views.swing.IlvJScrollManagerView;
import ilog.views.symbology.IlvSymbolDescriptor;
import ilog.views.symbology.editor.IlvSymbolEditorDocument;
import ilog.views.symbology.editor.IlvSymbolEditorView;
import ilog.views.symbology.editor.rules.IlvSymbolRuleModel;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteBaseObject;
import ilog.views.symbology.palettes.IlvPaletteCategory;
import ilog.views.symbology.palettes.IlvPaletteManager;
import ilog.views.symbology.palettes.IlvPaletteObject;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameter;
import ilog.views.util.IlvClassLoaderUtil;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SymbolEditorUtilities {
    private static Map a = new HashMap();
    private static IlvShapePropertyEditor b = new IlvShapePropertyEditor();

    public static IlvTransformer getRecenterTransformer(IlvSymbolEditorView ilvSymbolEditorView, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = ilvSymbolEditorView.getDocument().getToplevelGraphic().boundingBox(ilvTransformer);
        Dimension dimension = ilvSymbolEditorView.getManagerView().getSize();
        return new IlvTransformer(new IlvPoint((float)((double)(dimension.width / 2) - ilvRect.getCenterX()), (float)((double)(dimension.height / 2) - ilvRect.getCenterY())));
    }

    public static IlvSymbolEditorView getSymbolEditorView(IlvManagerView ilvManagerView) {
        return (IlvSymbolEditorView)SwingUtilities.getAncestorOfClass(IlvSymbolEditorView.class, ilvManagerView);
    }

    public static String getUniqueGraphicName(IlvSymbolEditorDocument ilvSymbolEditorDocument, String string) {
        String string2 = string;
        int n = 2;
        int n2 = string.length();
        while (Character.isDigit(string.charAt(n2 - 1))) {
            --n2;
        }
        if (n2 < string.length()) {
            try {
                n = Integer.parseInt(string.substring(n2));
                string = string.substring(0, n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int n3 = 2;
        while (true) {
            if (SymbolEditorUtilities.findGraphicByName(ilvSymbolEditorDocument, "port_in_" + string2) == null) break;
            string2 = string + n3++;
        }
        if (n3 > 2) {
            return string2;
        }
        n3 = 2;
        while (true) {
            if (SymbolEditorUtilities.findGraphicByName(ilvSymbolEditorDocument, "port_out_" + string2) == null) break;
            string2 = string + n3++;
        }
        if (n3 > 2) {
            return string2;
        }
        n3 = 2;
        while (true) {
            if (SymbolEditorUtilities.findGraphicByName(ilvSymbolEditorDocument, "port_inout_" + string2) == null) break;
            string2 = string + n3++;
        }
        if (n3 > 2) {
            return string2;
        }
        while (SymbolEditorUtilities.findGraphicByName(ilvSymbolEditorDocument, string2) != null) {
            string2 = string + n++;
        }
        return string2;
    }

    public static IlvGraphic findGraphicByName(IlvSymbolEditorDocument ilvSymbolEditorDocument, String string) {
        IlvGraphic ilvGraphic = ilvSymbolEditorDocument.getToplevelGraphic();
        if (ilvGraphic instanceof IlvCompositeGraphic) {
            return SymbolEditorUtilities.a((IlvCompositeGraphic)ilvGraphic, string);
        }
        return null;
    }

    public static String getUniqueParameterName(IlvSymbolEditorDocument ilvSymbolEditorDocument, String string) {
        String string2 = string;
        int n = 2;
        int n2 = string.length();
        while (Character.isDigit(string.charAt(n2 - 1))) {
            --n2;
        }
        if (n2 < string.length()) {
            try {
                n = Integer.parseInt(string.substring(n2));
                string = string.substring(0, n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        while (SymbolEditorUtilities.findParameterByName(ilvSymbolEditorDocument, string2) != null) {
            string2 = string + n++;
        }
        return string2;
    }

    public static IlvPaletteSymbolParameter findParameterByName(IlvSymbolEditorDocument ilvSymbolEditorDocument, String string) {
        for (int i = 0; i < ilvSymbolEditorDocument.getSymbol().getParameterCount(); ++i) {
            IlvPaletteSymbolParameter ilvPaletteSymbolParameter = ilvSymbolEditorDocument.getSymbol().getParameter(i);
            if (!string.equals(ilvPaletteSymbolParameter.getName())) continue;
            return ilvPaletteSymbolParameter;
        }
        return null;
    }

    public static String getUniqueRuleID(IlvSymbolEditorDocument ilvSymbolEditorDocument, IlvRule[] ilvRuleArray, String string) {
        Integer n;
        String string2 = string;
        int n2 = 2;
        int n3 = string.length();
        while (Character.isDigit(string.charAt(n3 - 1))) {
            --n3;
        }
        if (n3 < string.length()) {
            try {
                n2 = Integer.parseInt(string.substring(n3));
                string = string.substring(0, n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((n = (Integer)a.get(string)) != null) {
            n2 = n;
            string2 = string + n2++;
        }
        while (SymbolEditorUtilities.a(ilvSymbolEditorDocument, ilvRuleArray, string2) != null) {
            string2 = string + n2++;
        }
        a.put(string, new Integer(n2));
        return string2;
    }

    private static IlvRule a(IlvSymbolEditorDocument ilvSymbolEditorDocument, IlvRule[] ilvRuleArray, String string) {
        IlvRule[] ilvRuleArray2 = ilvSymbolEditorDocument.getRuleModel().getRulesFromId(IlvRuleModel.ALL_RULES, string);
        if (ilvRuleArray2 != null && ilvRuleArray2.length > 0) {
            return ilvRuleArray2[0];
        }
        ilvRuleArray2 = IlvRuleUtils.getRulesFromId(ilvRuleArray, string);
        if (ilvRuleArray2 != null && ilvRuleArray2.length > 0) {
            return ilvRuleArray2[0];
        }
        return null;
    }

    public static IlvPaletteObject getPaletteObject(IlvPalette ilvPalette, String string) {
        IlvPaletteBaseObject ilvPaletteBaseObject = ilvPalette.getRoot();
        if (string.length() == 0 || ilvPaletteBaseObject != null && string.equals(((IlvPaletteBaseObject)ilvPaletteBaseObject).getID())) {
            return ilvPaletteBaseObject;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "./");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Enumeration enumeration = ilvPalette.getChildren(ilvPaletteBaseObject);
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                IlvPaletteBaseObject ilvPaletteBaseObject2 = (IlvPaletteBaseObject)enumeration.nextElement();
                if (!ilvPaletteBaseObject2.getID().equals(string2)) continue;
                if (!stringTokenizer.hasMoreTokens()) {
                    return (IlvPaletteObject)((Object)ilvPaletteBaseObject2);
                }
                ilvPaletteBaseObject = ilvPaletteBaseObject2;
                bl = true;
                break;
            }
            if (bl) continue;
            break;
        }
        return null;
    }

    public static String getPaletteObjectPath(IlvPaletteObject ilvPaletteObject) {
        IlvPaletteBaseObject ilvPaletteBaseObject = (IlvPaletteBaseObject)((Object)ilvPaletteObject);
        if (ilvPaletteObject.getParent() == null) {
            return ilvPaletteBaseObject.getID();
        }
        String string = ilvPaletteBaseObject.getID();
        for (IlvPaletteCategory ilvPaletteCategory = ilvPaletteObject.getParent(); ilvPaletteCategory != null && ilvPaletteCategory.getParent() != null; ilvPaletteCategory = ilvPaletteCategory.getParent()) {
            string = ilvPaletteCategory.getID() + "/" + string;
        }
        return string;
    }

    public static IlvPalette getPalette(IlvPaletteManager ilvPaletteManager, URL uRL) {
        for (int i = 0; i < ilvPaletteManager.getPaletteCount(); ++i) {
            IlvPalette ilvPalette = ilvPaletteManager.getPalette(i);
            if (!ilvPalette.getJarURL().equals(uRL)) continue;
            return ilvPalette;
        }
        return null;
    }

    private static IlvGraphic a(IlvCompositeGraphic ilvCompositeGraphic, String string) {
        IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
        if (ilvGraphicArray != null) {
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                IlvGraphic ilvGraphic;
                IlvGraphic ilvGraphic2 = ilvGraphicArray[i];
                if (ilvGraphic2 == null) continue;
                if (string.equals(ilvGraphic2.getName())) {
                    return ilvGraphic2;
                }
                if (!(ilvGraphic2 instanceof IlvCompositeGraphic) || SymbolEditorUtilities.isSubSymbol(ilvGraphic2) || (ilvGraphic = SymbolEditorUtilities.a((IlvCompositeGraphic)ilvGraphic2, string)) == null) continue;
                return ilvGraphic;
            }
        }
        return null;
    }

    public static boolean hasCondition(IlvRule ilvRule) {
        IlvSelector ilvSelector = ilvRule.getSelector();
        return ilvSelector != null && (ilvSelector.getAttributes() != null && ilvSelector.getAttributes().length > 0 || ilvSelector.getPseudoClasses() != null && ilvSelector.getPseudoClasses().length > 0);
    }

    public static boolean isDesignRule(IlvRule ilvRule) {
        String[] stringArray;
        IlvSelector ilvSelector = ilvRule.getSelector();
        if (ilvSelector != null && (stringArray = ilvSelector.getPseudoClasses()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!"design".equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static IlvGraphic translateGraphic(IlvGraphic ilvGraphic, boolean bl) {
        if (ilvGraphic instanceof IlvLine) {
            IlvLine ilvLine = (IlvLine)ilvGraphic;
            IlvGeneralPath ilvGeneralPath = new IlvGeneralPath(new GeneralPath(new Line2D.Float(ilvLine.getFrom().x, ilvLine.getFrom().y, ilvLine.getTo().x, ilvLine.getTo().y)));
            ilvGeneralPath.setFillOn(false);
            ilvGeneralPath.setFillPaint(null);
            ilvGeneralPath.setStrokeOn(true);
            ilvGeneralPath.setStrokePaint(ilvLine.getForeground());
            return ilvGeneralPath;
        }
        if (ilvGraphic instanceof IlvPolyline || ilvGraphic instanceof IlvPolygon) {
            IlvPolyPoints ilvPolyPoints = (IlvPolyPoints)ilvGraphic;
            GeneralPath generalPath = new GeneralPath();
            IlvPoint ilvPoint = ilvPolyPoints.getPointAt(0, null);
            generalPath.moveTo(ilvPoint.x, ilvPoint.y);
            for (int i = 1; i < ilvPolyPoints.getPointsCardinal(); ++i) {
                ilvPoint = ilvPolyPoints.getPointAt(i, null);
                generalPath.lineTo(ilvPoint.x, ilvPoint.y);
            }
            if (ilvGraphic instanceof IlvPolygon) {
                generalPath.closePath();
            }
            IlvGeneralPath ilvGeneralPath = new IlvGeneralPath(generalPath);
            if (ilvGraphic instanceof IlvPolygon) {
                IlvPolygon ilvPolygon = (IlvPolygon)ilvGraphic;
                ilvGeneralPath.setFillOn(ilvPolygon.isFillOn());
                ilvGeneralPath.setFillPaint(bl ? ilvPolygon.getBackground() : ilvPolygon.getForeground());
                ilvGeneralPath.setStrokeOn(ilvPolygon.isStrokeOn());
                ilvGeneralPath.setStrokePaint(bl ? ilvPolygon.getForeground() : ilvPolygon.getBackground());
            } else {
                ilvGeneralPath.setFillOn(false);
                ilvGeneralPath.setFillPaint(null);
                ilvGeneralPath.setStrokeOn(true);
                ilvGeneralPath.setStrokePaint(((IlvPolyline)ilvPolyPoints).getForeground());
            }
            return ilvGeneralPath;
        }
        if (ilvGraphic instanceof IlvSpline) {
            IlvSpline ilvSpline = (IlvSpline)ilvGraphic;
            int n = ilvSpline.getPointsCardinal();
            IlvPoint[] ilvPointArray = new IlvPoint[n];
            for (int i = 0; i < n; ++i) {
                ilvPointArray[i] = ilvSpline.getPointAt(i, null);
            }
            float f = 0.65f;
            GeneralPath generalPath = new GeneralPath();
            if (n > 2) {
                if (f != -1.0f) {
                    IlvPoint[] ilvPointArray2 = IlvGraphicUtil.GetSmoothSpline(ilvPointArray, n, f, false, null);
                    n = (n - 2) * 3 + 1;
                    ilvPointArray = ilvPointArray2;
                }
            }
            generalPath.moveTo(ilvPointArray[0].x, ilvPointArray[0].y);
            int n2 = 3 * ((n - 1) / 3);
            int n3 = 1;
            while (n3 < n2) {
                generalPath.curveTo(ilvPointArray[n3].x, ilvPointArray[n3++].y, ilvPointArray[n3].x, ilvPointArray[n3++].y, ilvPointArray[n3].x, ilvPointArray[n3++].y);
            }
            ++n2;
            if (ilvSpline.isClosed()) {
                if (n - n2 == 2) {
                    generalPath.curveTo(ilvPointArray[n2].x, ilvPointArray[n2++].y, ilvPointArray[n2].x, ilvPointArray[n2].y, ilvPointArray[0].x, ilvPointArray[0].y);
                } else if (n - n2 == 1) {
                    generalPath.curveTo(ilvPointArray[n2].x, ilvPointArray[n2].y, ilvPointArray[n2].x, ilvPointArray[n2].y, ilvPointArray[0].x, ilvPointArray[0].y);
                } else {
                    generalPath.closePath();
                }
            } else if (n - n2 == 2) {
                generalPath.curveTo(ilvPointArray[n2].x, ilvPointArray[n2].y, ilvPointArray[n2].x, ilvPointArray[n2++].y, ilvPointArray[n2].x, ilvPointArray[n2].y);
            } else if (n - n2 == 1) {
                generalPath.lineTo(ilvPointArray[n2].x, ilvPointArray[n2].y);
            }
            IlvGeneralPath ilvGeneralPath = new IlvGeneralPath(generalPath);
            ilvGeneralPath.setFillOn(ilvSpline.isClosed());
            ilvGeneralPath.setFillPaint(ilvSpline.getBackground());
            ilvGeneralPath.setStrokeOn(ilvSpline.isStrokeOn());
            ilvGeneralPath.setStrokePaint(ilvSpline.getForeground());
            return ilvGeneralPath;
        }
        if (ilvGraphic instanceof IlvRectangle) {
            IlvRectangle ilvRectangle = (IlvRectangle)ilvGraphic;
            IlvRect ilvRect = ilvRectangle.getDefinitionRect();
            IlvGeneralPath ilvGeneralPath = ilvRectangle.getRadius() > 0 ? new IlvGeneralPath(new GeneralPath(new RoundRectangle2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height, ilvRectangle.getRadius(), ilvRectangle.getRadius()))) : new IlvGeneralPath(new GeneralPath(new Rectangle2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height)));
            ilvGeneralPath.setPointEditionAllowed(false);
            ilvGeneralPath.setFillOn(true);
            ilvGeneralPath.setFillPaint(ilvRectangle.getBackground());
            ilvGeneralPath.setStrokeOn(ilvRectangle.isStrokeOn());
            ilvGeneralPath.setStrokePaint(ilvRectangle.getForeground());
            return ilvGeneralPath;
        }
        if (ilvGraphic instanceof IlvEllipse) {
            IlvEllipse ilvEllipse = (IlvEllipse)ilvGraphic;
            IlvRect ilvRect = ilvEllipse.getDefinitionRect();
            IlvGeneralPath ilvGeneralPath = new IlvGeneralPath(new GeneralPath(new Ellipse2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height)));
            ilvGeneralPath.setPointEditionAllowed(false);
            ilvGeneralPath.setFillOn(true);
            ilvGeneralPath.setFillPaint(ilvEllipse.getBackground());
            ilvGeneralPath.setStrokeOn(ilvEllipse.isStrokeOn());
            ilvGeneralPath.setStrokePaint(ilvEllipse.getForeground());
            return ilvGeneralPath;
        }
        return ilvGraphic.copy();
    }

    public static IlvGraphic chooseShape(Component component) {
        String[] stringArray = new String[1];
        stringArray[0] = "Shape";
        return SymbolEditorUtilities.chooseGraphic(component, "Shape", stringArray);
    }

    public static IlvGraphic chooseDecoration(Component component) {
        String[] stringArray = new String[1];
        stringArray[0] = "Decoration";
        return SymbolEditorUtilities.chooseGraphic(component, "Decoration", stringArray);
    }

    public static IlvGraphic chooseGraphic(Component component, String string, String[] stringArray) {
        ResourceBundle resourceBundle = IlvResourceUtil.getBundle("ilog.views.symbology.editor.symboleditor", IlvLocaleUtil.getCurrentLocale(), IlvSymbolEditorDocument.class.getClassLoader());
        final IlvGraphic[] ilvGraphicArray = new IlvGraphic[1];
        final JTabbedPane jTabbedPane = new JTabbedPane();
        block3: for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = 0;
            while (true) {
                try {
                    String string3 = resourceBundle.getString("SymbolEditor.ChooseGraphic." + string2 + ".File." + n);
                    String string4 = resourceBundle.getString("SymbolEditor.ChooseGraphic." + string2 + ".Title." + n);
                    URL uRL = IlvClassLoaderUtil.getResource(SymbolEditorUtilities.class, "ilog/views/symbology/editor/shapes/" + string3);
                    IlvJScrollManagerView ilvJScrollManagerView = new IlvJScrollManagerView();
                    ilvJScrollManagerView.getView().setAntialiasing(true);
                    IlvSelectInteractor ilvSelectInteractor = new IlvSelectInteractor();
                    ilvSelectInteractor.setEditionAllowed(false);
                    ilvSelectInteractor.setDragAllowed(false);
                    ilvSelectInteractor.setMoveAllowed(false);
                    ilvJScrollManagerView.getView().setInteractor(ilvSelectInteractor);
                    ilvJScrollManagerView.getView().getManager().read(uRL);
                    ilvJScrollManagerView.getView().getManager().addManagerSelectionListener(new ManagerSelectionListener(){

                        @Override
                        public void selectionChanged(ManagerSelectionChangedEvent managerSelectionChangedEvent) {
                            IlvGraphicEnumeration ilvGraphicEnumeration = ((IlvJScrollManagerView)jTabbedPane.getSelectedComponent()).getView().getManager().getSelectedObjects();
                            if (!ilvGraphicEnumeration.hasMoreElements()) {
                                ilvGraphicArray[0] = null;
                            } else {
                                ilvGraphicArray[0] = ilvGraphicEnumeration.nextElement();
                                if (ilvGraphicEnumeration.hasMoreElements()) {
                                    ilvGraphicArray[0] = null;
                                }
                            }
                            SymbolEditorUtilities.getOKButton(jTabbedPane).setEnabled(ilvGraphicArray[0] != null);
                        }
                    });
                    jTabbedPane.addTab(string4, ilvJScrollManagerView);
                }
                catch (MissingResourceException missingResourceException) {
                    continue block3;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ((IlvJScrollManagerView)jTabbedPane.getSelectedComponent()).getView().getManager().deSelectAll(true);
                ilvGraphicArray[0] = null;
                SymbolEditorUtilities.getOKButton(jTabbedPane).setEnabled(false);
            }
        });
        jTabbedPane.setPreferredSize(new Dimension(300, 300));
        String string5 = resourceBundle.getString("SymbolEditor.ChooseGraphic." + string + ".Title");
        if (SymbolEditorUtilities.showDialog(component, string5, jTabbedPane, false)) {
            return ilvGraphicArray[0];
        }
        return null;
    }

    public static IlvCompositeGraphic getComposite(IlvGraphic ilvGraphic) {
        if (ilvGraphic != null && ilvGraphic.getGraphicBag() instanceof IlvCompositeGraphic) {
            return (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
        }
        return null;
    }

    public static int getCompositeChildIndex(IlvGraphic ilvGraphic) {
        IlvCompositeGraphic ilvCompositeGraphic = SymbolEditorUtilities.getComposite(ilvGraphic);
        if (ilvCompositeGraphic != null && ilvCompositeGraphic.getLayout() instanceof IlvAttachmentLayout) {
            IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                if (ilvGraphicArray[i] != ilvGraphic) continue;
                return i;
            }
        }
        return -1;
    }

    public static IlvAttachmentConstraint getAttachmentConstraint(IlvGraphic ilvGraphic) {
        Object object;
        int n = SymbolEditorUtilities.getCompositeChildIndex(ilvGraphic);
        if (n >= 0 && (object = SymbolEditorUtilities.getComposite(ilvGraphic).getConstraints(n)) instanceof IlvAttachmentConstraint) {
            return (IlvAttachmentConstraint)object;
        }
        return null;
    }

    public static boolean showDialog(Component component, String string, Component component2, boolean bl) {
        return SymbolEditorUtilities.showDialog(component, string, component2, true, bl);
    }

    public static boolean showDialog(Component component, String string, Component component2, boolean bl, boolean bl2) {
        ResourceBundle resourceBundle = IlvResourceUtil.getBundle("ilog.views.symbology.editor.symboleditor", IlvLocaleUtil.getCurrentLocale(), IlvSymbolEditorDocument.class.getClassLoader());
        Window window = SymbolEditorUtilities.a(component);
        final JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, string, true) : new JDialog((Dialog)window, string, true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JSeparator(), "North");
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        jPanel.add((Component)jPanel2, "Last");
        final boolean[] blArray = new boolean[1];
        JButton jButton = new JButton(resourceBundle.getString("SymbolEditor.Dialog.OK"));
        jButton.setEnabled(bl2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                blArray[0] = true;
                jDialog.setVisible(false);
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(resourceBundle.getString("SymbolEditor.Dialog.Cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                blArray[0] = false;
                jDialog.setVisible(false);
            }
        });
        jPanel2.add(jButton2);
        if (jDialog.getContentPane() instanceof JComponent) {
            ((JComponent)jDialog.getContentPane()).registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    blArray[0] = false;
                    jDialog.setVisible(false);
                }
            }, "close", KeyStroke.getKeyStroke(27, 0), 2);
        }
        int n = Math.max(jButton.getPreferredSize().width, jButton2.getPreferredSize().width);
        int n2 = Math.max(jButton.getPreferredSize().height, jButton2.getPreferredSize().height);
        Dimension dimension = new Dimension(n, n2);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        jDialog.getContentPane().setLayout(new BorderLayout(5, 5));
        ((JComponent)jDialog.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jDialog.getContentPane().add(component2, "Center");
        if (bl) {
            jDialog.getContentPane().add((Component)jPanel, "Last");
        }
        jDialog.getRootPane().setDefaultButton(jButton);
        if (bl2) {
            jButton.requestFocus();
        }
        int n3 = SymbolEditorUtilities.a(resourceBundle, "SymbolEditor.Dialog.MinWidth", -1);
        int n4 = SymbolEditorUtilities.a(resourceBundle, "SymbolEditor.Dialog.MinHeight", -1);
        if (n3 != -1 && n4 != -1) {
            jDialog.setMinimumSize(new Dimension(n3, n4));
        }
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        jDialog.setVisible(true);
        return blArray[0];
    }

    private static Window a(Component component) {
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return SymbolEditorUtilities.a(component.getParent());
    }

    private static int a(ResourceBundle resourceBundle, String string, int n) {
        String string2 = resourceBundle.getString(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static JButton getOKButton(Component component) {
        JDialog jDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, component);
        return jDialog.getRootPane().getDefaultButton();
    }

    public static boolean isSubSymbol(IlvGraphic ilvGraphic) {
        return IlvSymbolDescriptor.get(ilvGraphic) != null;
    }

    public static boolean containsSubSymbol(IlvGraphic ilvGraphic, IlvPaletteSymbol ilvPaletteSymbol) {
        IlvGraphic[] ilvGraphicArray;
        IlvSymbolDescriptor ilvSymbolDescriptor = IlvSymbolDescriptor.get(ilvGraphic);
        if (ilvSymbolDescriptor != null && ilvSymbolDescriptor.getPaletteSymbol() == ilvPaletteSymbol) {
            return true;
        }
        if (ilvGraphic instanceof IlvCompositeGraphic && (ilvGraphicArray = ((IlvCompositeGraphic)ilvGraphic).getChildren()) != null) {
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                IlvGraphic ilvGraphic2 = ilvGraphicArray[i];
                if (ilvGraphic2 == null || !SymbolEditorUtilities.containsSubSymbol(ilvGraphic2, ilvPaletteSymbol)) continue;
                return true;
            }
        }
        return false;
    }

    public static IlvRect getAttachmentBounds(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof IlvAttachmentBounds) {
            return ((IlvAttachmentBounds)((Object)ilvGraphic)).getAttachmentBounds();
        }
        if (ilvGraphic instanceof IlvGeneralPath) {
            return ((IlvGeneralPath)ilvGraphic).getShapeBounds(null);
        }
        if (ilvGraphic instanceof IlvDefinitionRectInterface) {
            return ((IlvDefinitionRectInterface)((Object)ilvGraphic)).getDefinitionRect();
        }
        return ilvGraphic.boundingBox();
    }

    public static void generateAttachement(IlvSymbolRuleModel ilvSymbolRuleModel, IlvCompositeGraphic ilvCompositeGraphic) {
        ilvSymbolRuleModel.setAdjusting(true);
        SymbolEditorUtilities.generateAttachmentInternal(ilvSymbolRuleModel, ilvCompositeGraphic);
        ilvSymbolRuleModel.setAdjusting(false);
    }

    public static void generateAttachmentInternal(IlvSymbolRuleModel ilvSymbolRuleModel, IlvCompositeGraphic ilvCompositeGraphic) {
        IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
        if (ilvGraphicArray == null) {
            return;
        }
        for (int i = 0; i < ilvGraphicArray.length; ++i) {
            IlvGraphic ilvGraphic = ilvGraphicArray[i];
            if (ilvGraphic == null) continue;
            if (ilvGraphic instanceof IlvCompositeGraphic) {
                SymbolEditorUtilities.generateAttachmentInternal(ilvSymbolRuleModel, (IlvCompositeGraphic)ilvGraphic);
                continue;
            }
            if (!(ilvGraphic instanceof IlvGeneralPath)) continue;
            IlvGeneralPath ilvGeneralPath = (IlvGeneralPath)ilvGraphic;
            IlvRect ilvRect = ilvGeneralPath.getShapeBounds(null);
            ilvGeneralPath.setShapeBounds(ilvRect);
            Shape shape = ilvGeneralPath.getShape();
            if (ilvGeneralPath.isTransformedShapeMode()) {
                ilvGeneralPath.setTransformedShapeMode(false);
                ilvGeneralPath.setTransformedShapeMode(true);
            }
            b.setValue(shape);
            String string = b.getAsText();
            IlvRule ilvRule = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic);
            ilvSymbolRuleModel.setDeclarationValue(ilvRule, "shape", string);
        }
    }

    public static void doLayoutIfBaseChanged(IlvGraphic ilvGraphic) {
        IlvCompositeGraphic ilvCompositeGraphic;
        if (ilvGraphic.getGraphicBag() instanceof IlvCompositeGraphic && (ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic.getGraphicBag()).getLayout() instanceof IlvAttachmentLayout && ilvGraphic == ilvCompositeGraphic.getChildren(0)) {
            IlvCompositeGraphic ilvCompositeGraphic2 = (IlvCompositeGraphic)ilvCompositeGraphic.getParent();
            if (ilvCompositeGraphic2 == null) {
                IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)ilvCompositeGraphic.getConstraints(0);
                IlvPoint ilvPoint = null;
                if (ilvAttachmentConstraint != null) {
                    ilvPoint = ilvAttachmentConstraint.getSize();
                    ilvAttachmentConstraint.setSize(null);
                }
                ilvCompositeGraphic.doLayout();
                if (ilvPoint != null) {
                    ilvAttachmentConstraint.setSize(ilvPoint);
                }
            } else {
                IlvAttachableGraphic ilvAttachableGraphic = ilvCompositeGraphic.getAttachableGraphic(ilvCompositeGraphic);
                IlvLayoutManager ilvLayoutManager = ilvCompositeGraphic.getLayout();
                IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)ilvCompositeGraphic.getConstraints(0);
                IlvPoint ilvPoint = ilvAttachmentConstraint.getSize();
                ilvAttachmentConstraint.setSize(null);
                ilvLayoutManager.reset();
                ilvLayoutManager.attach(ilvAttachableGraphic);
                ilvLayoutManager.layoutGroup(ilvAttachableGraphic);
                ilvAttachmentConstraint.setSize(ilvPoint);
            }
        }
    }

    public static void correctMoveResizeNonzoomableGraphic(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl, boolean bl2) {
        IlvRect ilvRect2 = SymbolEditorUtilities.getAttachmentBounds(ilvGraphic);
        float f = 0.0f;
        if (bl) {
            f = Math.max(f, Math.abs(ilvRect2.x - ilvRect.x));
            f = Math.max(f, Math.abs(ilvRect2.x + ilvRect2.width - ilvRect.x - ilvRect.width));
            f = Math.max(f, Math.abs(ilvRect2.width - ilvRect.width));
            ilvRect2.x = ilvRect.x;
            ilvRect2.width = ilvRect.width;
        }
        if (bl2) {
            f = Math.max(f, Math.abs(ilvRect2.y - ilvRect.y));
            f = Math.max(f, Math.abs(ilvRect2.y + ilvRect2.height - ilvRect.y - ilvRect.height));
            f = Math.max(f, Math.abs(ilvRect2.height - ilvRect.height));
            ilvRect2.y = ilvRect.y;
            ilvRect2.height = ilvRect.height;
        }
        if (f > 0.5f) {
            SymbolEditorUtilities.a(ilvGraphic, ilvRect2);
        }
    }

    private static void a(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        IlvRect ilvRect2 = new IlvRect(ilvRect);
        SymbolEditorUtilities.adjustToAvoidZeroSize(ilvRect2);
        for (int i = 0; i < 4; ++i) {
            IlvRect ilvRect3 = ilvGraphic.boundingBox(null);
            if (ilvRect3.equals(ilvRect2)) {
                return;
            }
            SymbolEditorUtilities.adjustToAvoidZeroSize(ilvRect3);
            IlvTransformer ilvTransformer = new IlvTransformer();
            IlvTransformer.computeTransformer(ilvRect3, ilvRect2, ilvTransformer);
            if (ilvTransformer.isBad()) {
                return;
            }
            ilvGraphic.applyTransform(ilvTransformer);
        }
    }

    public static void adjustToAvoidZeroSize(IlvRect ilvRect) {
        if (ilvRect.width < 0.1f) {
            ilvRect.width = 0.1f;
        }
        if (ilvRect.height < 0.1f) {
            ilvRect.height = 0.1f;
        }
    }

    public static void disableLayout(IlvGraphic ilvGraphic) {
        for (IlvCompositeGraphic ilvCompositeGraphic = ilvGraphic instanceof IlvCompositeGraphic ? (IlvCompositeGraphic)ilvGraphic : (IlvCompositeGraphic)ilvGraphic.getGraphicBag(); ilvCompositeGraphic != null; ilvCompositeGraphic = (IlvCompositeGraphic)ilvCompositeGraphic.getGraphicBag()) {
            ilvCompositeGraphic.setLayoutEnabled(false, false);
            if (!(ilvCompositeGraphic.getGraphicBag() instanceof IlvCompositeGraphic)) break;
        }
    }

    public static void enableLayout(IlvGraphic ilvGraphic) {
        for (IlvCompositeGraphic ilvCompositeGraphic = ilvGraphic instanceof IlvCompositeGraphic ? (IlvCompositeGraphic)ilvGraphic : (IlvCompositeGraphic)ilvGraphic.getGraphicBag(); ilvCompositeGraphic != null; ilvCompositeGraphic = (IlvCompositeGraphic)ilvCompositeGraphic.getGraphicBag()) {
            ilvCompositeGraphic.setLayoutEnabled(true, true);
            if (!(ilvCompositeGraphic.getGraphicBag() instanceof IlvCompositeGraphic)) break;
        }
    }
}

