/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.svg;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvRectangle;
import ilog.views.svg.SVGDocumentBuilder;
import ilog.views.svg.SVGDocumentBuilderConfigurator;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGRectElement;

class IlvRectangleTranslator
implements SVGDocumentBuilderConfigurator.GraphicTranslator,
SVGConstants {
    @Override
    public Element translate(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer, SVGDocumentBuilder sVGDocumentBuilder) {
        IlvRectangle ilvRectangle = (IlvRectangle)ilvGraphic;
        SVGRectElement sVGRectElement = (SVGRectElement)sVGDocumentBuilder.getDocument().createElement("rect");
        IlvRect ilvRect = ilvRectangle.boundingBox(ilvTransformer);
        sVGRectElement.getX().getBaseVal().setValue(ilvRect.x);
        sVGRectElement.getY().getBaseVal().setValue(ilvRect.y);
        sVGRectElement.getWidth().getBaseVal().setValue(ilvRect.width);
        sVGRectElement.getHeight().getBaseVal().setValue(ilvRect.height);
        sVGDocumentBuilder.startStylingElement((Element)sVGRectElement, ilvRectangle);
        if (ilvRectangle.isFillOn()) {
            sVGDocumentBuilder.a(ilvRectangle.getBackground());
        } else {
            sVGDocumentBuilder.b();
        }
        if (ilvRectangle.isStrokeOn()) {
            sVGDocumentBuilder.b(ilvRectangle.getForeground());
        }
        sVGDocumentBuilder.endStylingElement();
        if (ilvRectangle.getRadius() != 0) {
            sVGRectElement.getRx().getBaseVal().setValue((float)ilvRectangle.getRadius());
        }
        return sVGRectElement;
    }
}

