/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.prototypes;

import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.prototypes.IlvBehavior;
import ilog.views.prototypes.IlvGraphicElement;
import ilog.views.prototypes.IlvGroup;
import ilog.views.prototypes.IlvGroupElement;
import ilog.views.prototypes.IlvGroupException;
import ilog.views.prototypes.IlvSingleBehavior;
import ilog.views.prototypes.IlvValueConverter;
import ilog.views.prototypes.IlvValueException;
import java.io.IOException;
import java.io.Serializable;

public class IlvMultiRepBehavior
extends IlvSingleBehavior {
    Object[] a;

    public IlvMultiRepBehavior(String string, Object[] objectArray) {
        super(string);
        this.a = objectArray;
    }

    public IlvMultiRepBehavior(IlvMultiRepBehavior ilvMultiRepBehavior) {
        super(ilvMultiRepBehavior);
        if (ilvMultiRepBehavior.a != null) {
            if (ilvMultiRepBehavior.c()) {
                this.a = new Object[ilvMultiRepBehavior.a.length];
                for (int i = 0; i < this.a.length; ++i) {
                    this.a[i] = this.a((String[])ilvMultiRepBehavior.a[i]);
                }
            } else {
                this.a = this.a((String[])ilvMultiRepBehavior.a);
            }
        }
    }

    private String[] a(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public IlvMultiRepBehavior(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        int n;
        try {
            n = ilvInputStream.readInt("states");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            n = -1;
        }
        if (n >= 0) {
            this.a = new Object[n];
            for (int i = 0; i < n; ++i) {
                this.a[i] = ilvInputStream.readStringArray("representation");
            }
        } else {
            this.a = ilvInputStream.readStringArray("representations");
        }
    }

    private boolean c() {
        return this.a.length > 1 && this.a[0] instanceof String[];
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        if (this.c()) {
            ilvOutputStream.write("states", this.a.length);
            for (int i = 0; i < this.a.length; ++i) {
                ilvOutputStream.write("representation", (String[])this.a[i]);
            }
        } else {
            ilvOutputStream.write("states", -1);
            ilvOutputStream.write("representations", (String[])this.a);
        }
    }

    @Override
    public IlvBehavior copy() {
        return new IlvMultiRepBehavior(this);
    }

    @Override
    public String toString() {
        String string = "multi-rep:";
        for (int i = 0; i < this.a.length; ++i) {
            string = string + " ";
            if (this.a[i] instanceof String[]) {
                String[] stringArray = (String[])this.a[i];
                string = string + "(";
                for (int j = 0; j < stringArray.length; ++j) {
                    string = string + stringArray[j] + (j < stringArray.length - 1 ? "," : "");
                }
                string = string + ")";
                continue;
            }
            string = string + this.a[i];
        }
        return string;
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    protected void set(IlvGroup ilvGroup, String string, Object object) throws IlvValueException {
        int n = IlvValueConverter.convertToInt(object);
        if (n < 0) {
            throw new IlvValueException("Representation index out of bounds: " + n + " < 0");
        }
        if (n >= this.a.length) {
            throw new IlvValueException("Representation index out of bounds: " + n + " >= " + this.a.length);
        }
        VisibilityCache visibilityCache = new VisibilityCache();
        for (int i = 0; i < this.a.length; ++i) {
            if (i == n) continue;
            this.a(ilvGroup, i, Boolean.FALSE, visibilityCache);
        }
        this.a(ilvGroup, n, Boolean.TRUE, visibilityCache);
        visibilityCache.a();
    }

    private void a(IlvGroup ilvGroup, int n, Boolean bl, VisibilityCache visibilityCache) throws IlvValueException {
        if (this.a[n] instanceof String[]) {
            String[] stringArray = (String[])this.a[n];
            for (int i = 0; i < stringArray.length; ++i) {
                visibilityCache.a(stringArray[i], bl, ilvGroup);
            }
        } else {
            visibilityCache.a((String)this.a[n], bl, ilvGroup);
        }
    }

    public void setRepresentations(Object[] objectArray) {
        this.a = objectArray;
    }

    public Object[] getRepresentations() {
        return this.a;
    }

    class VisibilityCache {
        IlvGroupElement[] a = new IlvGroupElement[10];
        Boolean[] b = new Boolean[10];
        int c = 0;

        VisibilityCache() {
        }

        void a(String string, Boolean bl, IlvGroup ilvGroup) {
            int n;
            string = string.intern();
            for (n = 0; n < this.c; ++n) {
                if (this.a[n].a != string) continue;
                this.b[n] = bl;
                return;
            }
            try {
                IlvGroupElement ilvGroupElement = ilvGroup.findElement(string);
                if (this.c >= this.a.length) {
                    int n2 = this.a.length + 10;
                    IlvGroupElement[] ilvGroupElementArray = new IlvGroupElement[n2];
                    Boolean[] booleanArray = new Boolean[n2];
                    for (n = 0; n < this.c; ++n) {
                        ilvGroupElementArray[n] = this.a[n];
                        booleanArray[n] = this.b[n];
                    }
                    this.a = ilvGroupElementArray;
                    this.b = booleanArray;
                }
                this.a[this.c] = ilvGroupElement;
                this.b[this.c] = bl;
                ++this.c;
            }
            catch (IlvGroupException ilvGroupException) {
                // empty catch block
            }
        }

        void a() throws IlvValueException {
            for (int i = 0; i < this.c; ++i) {
                Serializable serializable;
                IlvGroupElement ilvGroupElement = this.a[i];
                if (ilvGroupElement instanceof IlvGraphicElement) {
                    serializable = (IlvGraphicElement)ilvGroupElement;
                    boolean bl = this.b[i];
                    if (((IlvGraphicElement)serializable).isVisible() == bl) continue;
                    ((IlvGraphicElement)serializable).setVisible(bl);
                    continue;
                }
                serializable = this.b[i];
                if (((Boolean)ilvGroupElement.get("visible")).booleanValue() == ((Boolean)serializable).booleanValue()) continue;
                ilvGroupElement.set("visible", serializable);
            }
        }
    }
}

