/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvPolylineLinkImage
extends IlvLinkImage {
    private IlvPoint[] a = null;

    public IlvPolylineLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, IlvPoint[] ilvPointArray) {
        super(ilvGraphic, ilvGraphic2, bl);
        this.a(ilvPointArray);
    }

    public IlvPolylineLinkImage(IlvPolylineLinkImage ilvPolylineLinkImage) {
        super(ilvPolylineLinkImage);
        this.a(ilvPolylineLinkImage.a);
    }

    public IlvPolylineLinkImage(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        IlvPoint[] ilvPointArray = ilvInputStream.readPointArray("points");
        this.a(ilvPointArray);
    }

    private void a(IlvPoint[] ilvPointArray) {
        if (ilvPointArray == null) {
            return;
        }
        int n = ilvPointArray.length;
        if (n < 1) {
            return;
        }
        this.a = new IlvPoint[n];
        for (int i = 0; i < n; ++i) {
            this.a[i] = new IlvPoint(ilvPointArray[i].x, ilvPointArray[i].y);
        }
    }

    @Override
    public IlvGraphic copy() {
        return new IlvPolylineLinkImage(this);
    }

    @Override
    public int getPointsCardinal() {
        return this.a == null ? 2 : this.a.length + 2;
    }

    @Override
    public IlvPoint[] getLinkPoints(IlvTransformer ilvTransformer) {
        int n = this.getPointsCardinal();
        IlvPoint[] ilvPointArray = new IlvPoint[n];
        if (n > 2) {
            if (ilvTransformer == null || ilvTransformer.isIdentity()) {
                for (int i = 1; i < n - 1; ++i) {
                    ilvPointArray[i] = new IlvPoint(this.a[i - 1]);
                }
            } else {
                for (int i = 1; i < n - 1; ++i) {
                    ilvPointArray[i] = new IlvPoint(this.a[i - 1]);
                    ilvTransformer.apply(ilvPointArray[i]);
                }
            }
        }
        ilvPointArray[0] = new IlvPoint();
        ilvPointArray[n - 1] = new IlvPoint();
        this.getConnectionPoints(ilvPointArray[0], ilvPointArray[n - 1], ilvTransformer);
        return ilvPointArray;
    }

    @Override
    public void setIntermediateLinkPoints(IlvPoint[] ilvPointArray, int n, int n2) {
        if (ilvPointArray != null && n + n2 > ilvPointArray.length || n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid Argument");
        }
        if (n2 == 0 || ilvPointArray == null) {
            this.a = null;
        } else {
            int n3 = this.getPointsCardinal() - 2;
            int n4 = Math.min(n2, n3);
            if (n3 != n2) {
                IlvPoint[] ilvPointArray2 = this.a;
                this.a = new IlvPoint[n2];
                if (ilvPointArray2 != null) {
                    System.arraycopy(ilvPointArray2, 0, this.a, 0, n4);
                }
            }
            int n5 = 0;
            for (n5 = 0; n5 < n4; ++n5) {
                this.a[n5].move(ilvPointArray[n + n5].x, ilvPointArray[n + n5].y);
            }
            while (n5 < n2) {
                this.a[n5] = new IlvPoint(ilvPointArray[n + n5]);
                ++n5;
            }
        }
    }

    @Override
    public IlvPoint getPointAt(int n, IlvTransformer ilvTransformer) {
        int n2 = this.getPointsCardinal() - 1;
        if (n == 0 || n == n2) {
            IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint()};
            this.getConnectionPoints(ilvPointArray[0], ilvPointArray[1], ilvTransformer);
            return n == 0 ? ilvPointArray[0] : ilvPointArray[1];
        }
        if (n > 0 && n < n2) {
            IlvPoint ilvPoint = new IlvPoint(this.a[n - 1]);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvPoint);
            }
            return ilvPoint;
        }
        throw new ArrayIndexOutOfBoundsException("Invalid index: " + n + " (" + this + " has " + this.getPointsCardinal() + " points)");
    }

    @Override
    public boolean allowsPointInsertion() {
        return true;
    }

    @Override
    public boolean allowsPointRemoval() {
        return this.a != null && this.a.length >= 1;
    }

    @Override
    public void insertPoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
        if (n < 0) {
            throw new IllegalArgumentException("negative index: " + n);
        }
        if (n > this.getPointsCardinal()) {
            throw new IllegalArgumentException("bad index:" + n + " (> number of points = " + this.getPointsCardinal() + ")");
        }
        IlvPoint[] ilvPointArray = this.a;
        int n2 = this.a == null ? 0 : ilvPointArray.length;
        int n3 = this.getPointsCardinal();
        if (n == 0) {
            IlvPoint ilvPoint = this.getPointAt(0, null);
            this.a = new IlvPoint[n2 + 1];
            this.a[0] = ilvPoint;
            if (ilvPointArray != null) {
                System.arraycopy(ilvPointArray, 0, this.a, 1, n2);
            }
            this.movePoint(0, f, f2, ilvTransformer);
        } else if (n == n3) {
            IlvPoint ilvPoint = this.getPointAt(n3 - 1, null);
            this.a = new IlvPoint[n2 + 1];
            this.a[n2] = ilvPoint;
            if (ilvPointArray != null) {
                System.arraycopy(ilvPointArray, 0, this.a, 0, n2);
            }
            this.movePoint(n3, f, f2, ilvTransformer);
        } else {
            this.a = new IlvPoint[n2 + 1];
            --n;
            if (ilvPointArray != null) {
                if (n > 0) {
                    System.arraycopy(ilvPointArray, 0, this.a, 0, n);
                }
                System.arraycopy(ilvPointArray, n, this.a, n + 1, n2 - n);
            }
            this.a[n] = new IlvPoint(f, f2);
        }
    }

    @Override
    public void removePoint(int n, IlvTransformer ilvTransformer) {
        if (n == 0) {
            return;
        }
        if (n == this.getPointsCardinal() - 1) {
            return;
        }
        if (this.a != null && --n >= 0 && n < this.a.length) {
            int n2;
            IlvPoint[] ilvPointArray = this.a;
            this.a = new IlvPoint[ilvPointArray.length - 1];
            if (n > 0) {
                System.arraycopy(ilvPointArray, 0, this.a, 0, n);
            }
            if ((n2 = ilvPointArray.length - n - 1) > 0) {
                System.arraycopy(ilvPointArray, n + 1, this.a, n, n2);
            }
        } else {
            throw new IllegalArgumentException("bad index: " + n);
        }
    }

    @Override
    public void movePoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
        if (n == 0 || n == this.getPointsCardinal() - 1) {
            super.movePoint(n, f, f2, ilvTransformer);
        } else {
            if (this.a == null) {
                throw new IllegalArgumentException("bad index: " + n);
            }
            try {
                this.a[n - 1].move(f, f2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("bad index: " + n);
            }
        }
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null && !ilvTransformer.isIdentity() && this.a != null && this.getPointsCardinal() > 2) {
            int n = this.a.length;
            for (int i = 0; i < n; ++i) {
                ilvTransformer.apply(this.a[i]);
            }
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("points", this.a);
    }
}

