/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvPolyPoints;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;

public class IlvPolyline
extends IlvPolyPoints {
    private Color a;

    public IlvPolyline() {
        IlvPoint[] ilvPointArray = new IlvPoint[4];
        ilvPointArray[0] = new IlvPoint(0.0f, 0.0f);
        ilvPointArray[1] = new IlvPoint(10.0f, 10.0f);
        ilvPointArray[2] = new IlvPoint(0.0f, 20.0f);
        ilvPointArray[3] = new IlvPoint(10.0f, 30.0f);
        this(ilvPointArray);
    }

    public IlvPolyline(IlvPoint[] ilvPointArray) {
        super(ilvPointArray);
        this.a = null;
    }

    public IlvPolyline(IlvPoint[] ilvPointArray, boolean bl) {
        super(ilvPointArray, bl);
        this.a = null;
    }

    public IlvPolyline(IlvPolyline ilvPolyline) {
        super(ilvPolyline);
        this.a = null;
        this.setForeground(ilvPolyline.a);
        this.setLineWidth(ilvPolyline.getLineWidth());
        this.setLineJoin(ilvPolyline.getLineJoin());
        this.setMaximumLineWidth(ilvPolyline.getMaximumLineWidth());
        this.setEndCap(ilvPolyline.getEndCap());
        this.setLineStyle(ilvPolyline.getLineStyle());
    }

    public IlvPolyline(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = null;
        this.setForeground(ilvInputStream.readColor("foreground"));
        try {
            this.setLineWidth(ilvInputStream.readFloat("lineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setMaximumLineWidth(ilvInputStream.readFloat("maximumLineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLineJoin(ilvInputStream.readInt("lineJoin"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setEndCap(ilvInputStream.readInt("endCap"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLineStyle(ilvInputStream.readFloatArray("lineStyle"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public IlvGraphic copy() {
        return new IlvPolyline(this);
    }

    @Override
    public boolean pointsInBBox() {
        return true;
    }

    public float getLineWidth() {
        return IlvStrokeInfo.GetLineWidth(this);
    }

    public void setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("bad line Width " + f);
        }
        if (f != this.getLineWidth()) {
            IlvStrokeInfo.SetLineWidth(this, f);
            this.a();
        }
    }

    public int getEndCap() {
        return IlvStrokeInfo.GetEndCap(this);
    }

    public void setEndCap(int n) {
        if (n != 1 && n != 2 && n != 0) {
            throw new IllegalArgumentException("bad end cap");
        }
        if (n != this.getEndCap()) {
            IlvStrokeInfo.SetEndCap(this, n);
            this.a();
        }
    }

    public int getLineJoin() {
        return IlvStrokeInfo.GetLineJoin(this);
    }

    public void setLineJoin(int n) {
        if (n != 0 && n != 2 && n != 1) {
            throw new IllegalArgumentException("bad line join");
        }
        if (n != this.getLineJoin()) {
            IlvStrokeInfo.SetLineJoin(this, n);
            this.a();
        }
    }

    public float getMaximumLineWidth() {
        return IlvStrokeInfo.GetMaximumLineWidth(this);
    }

    public void setMaximumLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("limit must be greater or equal to 0 " + f);
        }
        if (f != this.getMaximumLineWidth()) {
            IlvStrokeInfo.SetMaximumLineWidth(this, f);
            this.a();
        }
    }

    public float[] getLineStyle() {
        return IlvStrokeInfo.GetLineStyle(this);
    }

    public void setLineStyle(float[] fArray) {
        IlvStrokeInfo.SetLineStyle(this, fArray);
    }

    @Override
    protected void computeBBox(IlvRect ilvRect) {
        float f = this.getLineWidth();
        if (f == 0.0f) {
            super.computeBBox(ilvRect);
        } else {
            f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), null, true);
            IlvPoint[] ilvPointArray = this.getPoints();
            IlvRect ilvRect2 = IlvGraphicUtil.PolylineBBox(ilvPointArray, ilvPointArray.length, f, this.getLineJoin(), this.getEndCap(), null);
            ilvRect.x = ilvRect2.x;
            ilvRect.y = ilvRect2.y;
            ilvRect.width = ilvRect2.width;
            ilvRect.height = ilvRect2.height;
        }
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        float f = this.getLineWidth();
        if (f == 0.0f) {
            return super.boundingBox(ilvTransformer);
        }
        f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, true);
        IlvPoint[] ilvPointArray = this.getPoints();
        IlvRect ilvRect = IlvGraphicUtil.PolylineBBox(ilvPointArray, ilvPointArray.length, f, this.getLineJoin(), this.getEndCap(), ilvTransformer);
        return ilvRect;
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        float f = this.getLineWidth();
        if (f == 0.0f) {
            IlvRect ilvRect = this.boundingBox(ilvTransformer);
            ilvRect.expand(IlvUtil.GetDeltaLine());
            if (!ilvRect.inside(ilvPoint2.x, ilvPoint2.y)) {
                return false;
            }
            return IlvGraphicUtil.PointInPolyline(ilvPoint2, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, 0.0f, 1, 0, ilvTransformer);
        }
        f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, false);
        return IlvGraphicUtil.PointInPolyline(ilvPoint2, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, f, this.getLineJoin(), this.getEndCap(), ilvTransformer);
    }

    @Override
    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        double d;
        double d2;
        double d3;
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint[] ilvPointArray = IlvGraphicUtil.GetPolyPoints(this, ilvTransformer);
        IlvPoint[] ilvPointArray2 = new IlvPoint[ilvPointArray.length];
        int n = IlvClippingUtil.LineIntersectsPolyPoints(ilvPoint, ilvPoint2, ilvPointArray, false, ilvPointArray2);
        IlvPoint ilvPoint3 = IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray2, n);
        float f = this.getLineWidth(ilvTransformer);
        if (f > 0.0f && n > 0 && (d3 = Math.sqrt((d2 = (double)(ilvPoint2.x - ilvPoint.x)) * d2 + (d = (double)(ilvPoint2.y - ilvPoint.y)) * d)) != 0.0) {
            ilvPoint3.x += (float)(0.5 * (double)f * d2 / d3);
            ilvPoint3.y += (float)(0.5 * (double)f * d / d3);
        }
        return ilvPoint3;
    }

    public float getLineWidth(IlvTransformer ilvTransformer) {
        float f = this.getLineWidth();
        if (f == 0.0f) {
            return 1.0f;
        }
        f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, false);
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        return Math.max(1.0f, (float)((double)f * d));
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        graphics.setColor(this.getForeground());
        float f = this.getLineWidth();
        float[] fArray = this.getLineStyle();
        if (f == 0.0f && fArray == null) {
            IlvGraphicUtil.DrawPolyline(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, 0.0f, 1, 0, null, ilvTransformer);
        } else {
            float f2 = this.getMaximumLineWidth();
            fArray = IlvStrokeInfo.zoomedLineStyle(fArray, f, f2, ilvTransformer);
            f = IlvStrokeInfo.zoomedLineWidth(f, f2, ilvTransformer, false);
            IlvGraphicUtil.DrawPolyline(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, f, this.getLineJoin(), this.getEndCap(), fArray, ilvTransformer);
        }
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.a;
        this.a = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        if (this.a != null) {
            return this.a;
        }
        return Color.black;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float[] fArray;
        int n;
        int n2;
        float f;
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        float f2 = this.getLineWidth();
        if (f2 != 0.0f) {
            ilvOutputStream.write("lineWidth", f2);
        }
        if ((f = this.getMaximumLineWidth()) != 0.0f) {
            ilvOutputStream.write("maximumLineWidth", f);
        }
        if ((n2 = this.getLineJoin()) != 2) {
            ilvOutputStream.write("lineJoin", n2);
        }
        if ((n = this.getEndCap()) != 2) {
            ilvOutputStream.write("endCap", n);
        }
        if ((fArray = this.getLineStyle()) != null) {
            ilvOutputStream.write("lineStyle", fArray);
        }
    }

    @Override
    public boolean zoomable() {
        if (this.getLineJoin() == 1) {
            float f = this.getMaximumLineWidth();
            if (0.0f < f && f < 1.0f) {
                return true;
            }
            return this.getLineWidth() == 0.0f;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        IlvStrokeInfo.DisposeStroke(this);
    }
}

