/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvOneLinkImage
extends IlvLinkImage {
    public static final int VerticalLink = 0;
    public static final int HorizontalLink = 1;
    private int a = 0;

    public IlvOneLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        this(ilvGraphic, ilvGraphic2, 1, bl);
    }

    public IlvOneLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, int n, boolean bl) {
        super(ilvGraphic, ilvGraphic2, bl);
        this.a = n;
    }

    public IlvOneLinkImage(IlvOneLinkImage ilvOneLinkImage) {
        super(ilvOneLinkImage);
        this.a = ilvOneLinkImage.a;
    }

    public IlvOneLinkImage(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readInt("orientation");
    }

    @Override
    public IlvGraphic copy() {
        return new IlvOneLinkImage(this);
    }

    public void setOrientation(int n) {
        this.a = n;
    }

    public int getOrientation() {
        return this.a;
    }

    @Override
    public int getPointsCardinal() {
        return 2;
    }

    @Override
    public IlvPoint getPointAt(int n, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("index should be 0 or 1");
        }
        if (n == 0) {
            return ilvPointArray[0];
        }
        return ilvPointArray[ilvPointArray.length - 1];
    }

    final boolean a(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.getToBoundingBox(ilvTransformer);
        IlvRect ilvRect2 = this.getFromBoundingBox(ilvTransformer);
        if (this.a == 0) {
            return ilvRect2.x + ilvRect2.width / 2.0f >= ilvRect.x && ilvRect2.x + ilvRect2.width / 2.0f <= ilvRect.x + ilvRect.width || ilvRect.y + ilvRect.height / 2.0f >= ilvRect2.y && ilvRect.y + ilvRect.height / 2.0f <= ilvRect2.y + ilvRect2.height;
        }
        return ilvRect2.y + ilvRect2.height / 2.0f >= ilvRect.y && ilvRect2.y + ilvRect2.height / 2.0f <= ilvRect.y + ilvRect.height || ilvRect.x + ilvRect.width / 2.0f >= ilvRect2.x && ilvRect.x + ilvRect.width / 2.0f <= ilvRect2.x + ilvRect2.width;
    }

    @Override
    public void getConnectionPoints(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        boolean bl = this.getLinkConnectorConnectionPoint(true, ilvPoint, ilvTransformer);
        boolean bl2 = this.getLinkConnectorConnectionPoint(false, ilvPoint2, ilvTransformer);
        if (!bl || !bl2) {
            if (this.a(ilvTransformer)) {
                IlvPoint ilvPoint3 = new IlvPoint();
                IlvPoint ilvPoint4 = new IlvPoint();
                super.getConnectionPoints(ilvPoint3, ilvPoint4, ilvTransformer);
                if (!bl) {
                    ilvPoint.move(ilvPoint3.x, ilvPoint3.y);
                }
                if (!bl2) {
                    ilvPoint2.move(ilvPoint4.x, ilvPoint4.y);
                }
                return;
            }
            IlvRect ilvRect = this.getToBoundingBox(ilvTransformer);
            IlvRect ilvRect2 = this.getFromBoundingBox(ilvTransformer);
            if (this.a == 0) {
                if (!bl2) {
                    if (ilvRect.x + ilvRect.width / 2.0f >= ilvRect2.x + ilvRect2.width / 2.0f) {
                        ilvPoint2.move(ilvRect.x, ilvRect.y + ilvRect.height / 2.0f);
                    } else {
                        ilvPoint2.move(ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height / 2.0f);
                    }
                }
                if (!bl) {
                    if (ilvRect.y + ilvRect.height / 2.0f <= ilvRect2.y + ilvRect2.height / 2.0f) {
                        ilvPoint.move(ilvRect2.x + ilvRect2.width / 2.0f, ilvRect2.y);
                    } else {
                        ilvPoint.move(ilvRect2.x + ilvRect2.width / 2.0f, ilvRect2.y + ilvRect2.height);
                    }
                }
            } else {
                if (!bl) {
                    if (ilvRect.x + ilvRect.width / 2.0f >= ilvRect2.x + ilvRect2.width / 2.0f) {
                        ilvPoint.move(ilvRect2.x + ilvRect2.width, ilvRect2.y + ilvRect2.height / 2.0f);
                    } else {
                        ilvPoint.move(ilvRect2.x, ilvRect2.y + ilvRect2.height / 2.0f);
                    }
                }
                if (!bl2) {
                    if (ilvRect.y + ilvRect.height / 2.0f <= ilvRect2.y + ilvRect2.height / 2.0f) {
                        ilvPoint2.move(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height);
                    } else {
                        ilvPoint2.move(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y);
                    }
                }
            }
        }
    }

    @Override
    public IlvPoint[] getLinkPoints(IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint(), new IlvPoint()};
        this.getConnectionPoints(ilvPointArray[0], ilvPointArray[2], ilvTransformer);
        if (this.a(ilvTransformer)) {
            ilvPointArray[1].x = ilvPointArray[0].x;
            ilvPointArray[1].y = ilvPointArray[0].y;
        } else if (this.a == 0) {
            ilvPointArray[1].x = ilvPointArray[0].x;
            ilvPointArray[1].y = ilvPointArray[2].y;
        } else {
            ilvPointArray[1].x = ilvPointArray[2].x;
            ilvPointArray[1].y = ilvPointArray[0].y;
        }
        return ilvPointArray;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("orientation", this.a);
    }
}

