/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvPolyPoints;
import ilog.views.graphic.IlvPolyline;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvArrowPolyline
extends IlvPolyline {
    private boolean a = false;
    private float b = 1.0f;
    static final Boolean c = new Boolean(true);
    static final IlvPoint d = new IlvPoint();
    static final IlvPoint[] e = new IlvPoint[3];

    public IlvArrowPolyline(IlvPoint[] ilvPointArray, boolean bl, float f) {
        this(ilvPointArray, bl, f, true);
    }

    public IlvArrowPolyline(IlvPoint[] ilvPointArray, boolean bl, float f, boolean bl2) {
        super(ilvPointArray, bl2);
        this.a = bl;
        this.setArrowPosition(f);
    }

    public IlvArrowPolyline(IlvPoint[] ilvPointArray, boolean bl) {
        this(ilvPointArray, bl, 1.0f);
    }

    public IlvArrowPolyline(IlvPoint[] ilvPointArray) {
        this(ilvPointArray, false);
    }

    public IlvArrowPolyline(IlvArrowPolyline ilvArrowPolyline) {
        super(ilvArrowPolyline);
        this.a = ilvArrowPolyline.a;
        this.b = ilvArrowPolyline.b;
    }

    public IlvArrowPolyline(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setUsingAllLines(ilvInputStream.readBoolean("usingAllLines"));
        this.setArrowPosition(ilvInputStream.readFloat("arrowPosition"));
    }

    @Override
    public IlvGraphic copy() {
        return new IlvArrowPolyline(this);
    }

    public void setArrowPosition(float f) {
        this.b = f;
        this.b = Math.min(1.0f, this.b);
        this.b = Math.max(0.0f, this.b);
    }

    public float getArrowPosition() {
        return this.b;
    }

    public boolean isUsingAllLines() {
        return this.a;
    }

    public void setUsingAllLines(boolean bl) {
        this.a = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f = this.getArrowSize(this.a(ilvTransformer, false), ilvTransformer);
        int n = ((IlvPolyPoints)this).a.length;
        Boolean bl = c;
        synchronized (bl) {
            int n2;
            if (f > 4.0f && this.b == 1.0f) {
                if (n > 1) {
                    n2 = this.getEndCap();
                    float f2 = ((IlvPolyPoints)this).a[n - 1].x;
                    float f3 = ((IlvPolyPoints)this).a[n - 1].y;
                    IlvArrowPolyline.d.x = f2;
                    IlvArrowPolyline.d.y = f3;
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(d);
                    }
                    double d = IlvArrowPolyline.d.x;
                    double d2 = IlvArrowPolyline.d.y;
                    IlvArrowPolyline.d.x = ((IlvPolyPoints)this).a[n - 2].x;
                    IlvArrowPolyline.d.y = ((IlvPolyPoints)this).a[n - 2].y;
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(IlvArrowPolyline.d);
                    }
                    double d3 = IlvArrowPolyline.d.x;
                    double d4 = IlvArrowPolyline.d.y;
                    double d5 = d - d3;
                    double d6 = d2 - d4;
                    double d7 = Math.sqrt(d5 * d5 + d6 * d6);
                    double d8 = n2 != 0 ? 2.0 * (double)f : 1.5 * (double)f;
                    double d9 = 0.0;
                    double d10 = 0.0;
                    if (d7 != 0.0) {
                        d9 = -d8 * d6 / d7;
                        d10 = d8 * d5 / d7;
                    }
                    IlvArrowPolyline.d.x = (float)(d - d10);
                    IlvArrowPolyline.d.y = (float)(d2 + d9);
                    if (ilvTransformer != null) {
                        ilvTransformer.inverse(IlvArrowPolyline.d);
                    }
                    ((IlvPolyPoints)this).a[n - 1].x = IlvArrowPolyline.d.x;
                    ((IlvPolyPoints)this).a[n - 1].y = IlvArrowPolyline.d.y;
                    super.draw(graphics, ilvTransformer);
                    ((IlvPolyPoints)this).a[n - 1].x = f2;
                    ((IlvPolyPoints)this).a[n - 1].y = f3;
                }
            } else {
                super.draw(graphics, ilvTransformer);
            }
            graphics.setColor(this.getForeground());
            if (this.a) {
                for (int i = 1; i < n; ++i) {
                    d.move(((IlvPolyPoints)this).a[i - 1].x, ((IlvPolyPoints)this).a[i - 1].y);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(d);
                    }
                    n2 = (int)Math.floor(IlvArrowPolyline.d.x);
                    int n3 = (int)Math.floor(IlvArrowPolyline.d.y);
                    d.move(((IlvPolyPoints)this).a[i].x, ((IlvPolyPoints)this).a[i].y);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(d);
                    }
                    int n4 = (int)Math.floor(IlvArrowPolyline.d.x);
                    int n5 = (int)Math.floor(IlvArrowPolyline.d.y);
                    IlvUtility.drawArrow(graphics, n2, n3, n4, n5, this.b, f);
                }
            } else if (n >= 2) {
                d.move(((IlvPolyPoints)this).a[n - 2].x, ((IlvPolyPoints)this).a[n - 2].y);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(d);
                }
                n2 = (int)Math.floor(IlvArrowPolyline.d.x);
                int n6 = (int)Math.floor(IlvArrowPolyline.d.y);
                d.move(((IlvPolyPoints)this).a[n - 1].x, ((IlvPolyPoints)this).a[n - 1].y);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(d);
                }
                int n7 = (int)Math.floor(IlvArrowPolyline.d.x);
                int n8 = (int)Math.floor(IlvArrowPolyline.d.y);
                IlvUtility.drawArrow(graphics, n2, n6, n7, n8, this.b, f);
            }
        }
    }

    protected float getArrowSize(float f, IlvTransformer ilvTransformer) {
        return IlvUtility.arrowSize(f, ilvTransformer);
    }

    private static IlvRect a(IlvPoint[] ilvPointArray) {
        IlvRect ilvRect = new IlvRect();
        IlvUtil.BoundingBox(ilvRect, ilvPointArray, 3);
        return ilvRect;
    }

    private float a(IlvTransformer ilvTransformer, boolean bl) {
        float f = this.getLineWidth();
        if (f == 0.0f) {
            return 0.0f;
        }
        return IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = super.boundingBox(ilvTransformer);
        int n = ((IlvPolyPoints)this).a.length;
        float f = this.getArrowSize(this.a(ilvTransformer, true), ilvTransformer);
        Boolean bl = c;
        synchronized (bl) {
            if (this.a) {
                for (int i = 1; i < n; ++i) {
                    d.move(((IlvPolyPoints)this).a[i - 1].x, ((IlvPolyPoints)this).a[i - 1].y);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(d);
                    }
                    float f2 = IlvArrowPolyline.d.x;
                    float f3 = IlvArrowPolyline.d.y;
                    d.move(((IlvPolyPoints)this).a[i].x, ((IlvPolyPoints)this).a[i].y);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(d);
                    }
                    float f4 = IlvArrowPolyline.d.x;
                    float f5 = IlvArrowPolyline.d.y;
                    IlvUtility.ComputeArrow(f2, f3, f4, f5, this.b, e, f);
                    ilvRect.add(IlvArrowPolyline.a(e));
                }
            } else if (n >= 2) {
                d.move(((IlvPolyPoints)this).a[n - 2].x, ((IlvPolyPoints)this).a[n - 2].y);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(d);
                }
                float f6 = IlvArrowPolyline.d.x;
                float f7 = IlvArrowPolyline.d.y;
                d.move(((IlvPolyPoints)this).a[n - 1].x, ((IlvPolyPoints)this).a[n - 1].y);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(d);
                }
                float f8 = IlvArrowPolyline.d.x;
                float f9 = IlvArrowPolyline.d.y;
                IlvUtility.ComputeArrow(f6, f7, f8, f9, this.b, e, f);
                ilvRect.add(IlvArrowPolyline.a(e));
            }
        }
        return ilvRect;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("usingAllLines", this.isUsingAllLines());
        ilvOutputStream.write("arrowPosition", this.getArrowPosition());
    }

    static {
        for (int i = 0; i < 3; ++i) {
            IlvArrowPolyline.e[i] = new IlvPoint();
        }
    }
}

