/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.wizard;

import ilog.views.applications.util.wizard.IlvWizardPanel;
import ilog.views.builder.wizard.IlvBuilderWizardPage;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.swing.SwingFactories;
import ilog.views.util.swing.internal.IlvTextField;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class IlvFileConnectionPage
extends IlvBuilderWizardPage {
    private JTextField a;
    private JFileChooser b;
    private JButton c;
    private JButton d;

    public IlvFileConnectionPage(String string) {
        super(string);
    }

    @Override
    public boolean wantsEnter() {
        return true;
    }

    @Override
    public void init() {
        Box box = SwingFactories.createHorizontalBox();
        JLabel jLabel = new JLabel(IlvWizardPanel.getMessage("FileConnectionPage.Label"));
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(3));
        this.a = new IlvTextField();
        this.a.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.a.getPreferredSize().height));
        box.add(this.a);
        box.add(Box.createHorizontalStrut(5));
        this.c = new JButton(IlvWizardPanel.getMessage("FileConnectionPage.Browse.Label"));
        this.c.setToolTipText(IlvWizardPanel.getMessage("FileConnectionPage.Browse.ToolTip"));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (IlvFileConnectionPage.this.b == null) {
                    IlvFileConnectionPage.this.b = IlvFileConnectionPage.this.createFileChooser();
                    object = IlvFileConnectionPage.this.getFileFilter();
                    if (object != null) {
                        IlvFileConnectionPage.this.b.addChoosableFileFilter((FileFilter)object);
                    }
                }
                if (IlvFileConnectionPage.this.b.showOpenDialog(IlvFileConnectionPage.this) == 0) {
                    object = null;
                    try {
                        object = IlvURLUtil.convertFileToAbsoluteURL(IlvFileConnectionPage.this.b.getSelectedFile());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (object != null) {
                        IlvFileConnectionPage.this.a.setText(((URL)object).toString());
                        IlvFileConnectionPage.this.fileSelected((URL)object);
                    }
                }
            }
        });
        box.add(this.c);
        if (this.isRefreshAvailable()) {
            box.add(Box.createHorizontalStrut(5));
            this.d = new JButton(IlvWizardPanel.getMessage("FileConnectionPage.Refresh.Label"));
            this.d.setToolTipText(IlvWizardPanel.getMessage("FileConnectionPage.Refresh.ToolTip"));
            this.d.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = IlvFileConnectionPage.this.a.getText();
                    if (string != null) {
                        string = string.trim();
                        if (string.equals("")) {
                            IlvFileConnectionPage.this.fileSelected(null);
                        } else {
                            URL uRL = IlvFileConnectionPage.this.verifyFile(string);
                            IlvFileConnectionPage.this.fileSelected(uRL);
                        }
                    }
                }
            });
            box.add(this.d);
        }
        box.add(Box.createHorizontalGlue());
        this.add(box);
        this.add(Box.createVerticalStrut(3));
    }

    protected JFileChooser createFileChooser() {
        return new JFileChooser(this.getExamplesDirectory());
    }

    public File getExamplesDirectory() {
        File file = new File("data/examples");
        if (file.exists()) {
            return file;
        }
        File file2 = new File("../jviews-chart/demos/gallery/data");
        if (file2.exists()) {
            return file2;
        }
        File file3 = new File("../../samples/gallery/data");
        if (file3.exists()) {
            return file3;
        }
        return null;
    }

    protected void fileSelected(URL uRL) {
    }

    protected FileFilter getFileFilter() {
        return null;
    }

    protected JTextField getURLField() {
        return this.a;
    }

    protected JFileChooser getFileChooser() {
        return this.b;
    }

    protected JButton getBrowseButton() {
        return this.c;
    }

    protected boolean isRefreshAvailable() {
        return false;
    }

    protected JButton getRefreshButton() {
        return this.d;
    }

    protected URL verifyFile(String string) {
        return null;
    }
}

