/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.docview.IlvDocumentView;
import ilog.views.appframe.event.ApplicationEvent;
import ilog.views.appframe.event.ApplicationListener;
import ilog.views.appframe.event.IlvApplicationAdapter;
import ilog.views.appframe.event.MessageEvent;
import ilog.views.appframe.event.MessageListener;
import ilog.views.appframe.plugin.IlvPlugin;
import ilog.views.appframe.plugin.IlvPluginInstaller;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.builder.IlvBuilder;
import ilog.views.builder.IlvBuilderMode;
import ilog.views.builder.docview.IlvSampleView;
import ilog.views.util.IlvFrameworkProduct;
import java.awt.EventQueue;

public abstract class IlvBuilderPluginInstaller
implements ApplicationListener,
IlvPluginInstaller {
    private static final String a = "__Ilv_PluginInstaller_";
    protected IlvApplication application;
    public IlvBuilderMode styleEditingMode;
    public IlvBuilderMode dataEditingMode;
    public IlvBuilderMode runMode;
    protected boolean _allowWizard = true;

    @Override
    public void applicationEventReceived(ApplicationEvent applicationEvent) {
        if (applicationEvent.getID() == 124) {
            applicationEvent.getApplication().removeApplicationListener(this);
            this._allowWizard = Boolean.TRUE.equals(applicationEvent.getApplication().getProperty("allow-startup-wizard"));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IlvBuilderPluginInstaller.this.applicationReady();
                }
            });
        }
    }

    protected void applicationReady() {
    }

    @Override
    public void install(IlvApplication ilvApplication, IlvPlugin ilvPlugin) {
        this.application = ilvApplication;
        this.application.setProperty(a, this);
        ilvApplication.addMessageListener(new MessageListener(){

            @Override
            public void receiveMessage(MessageEvent messageEvent) {
                if (messageEvent.getMessageName().equals("BUILDER_MODE_CHANGED")) {
                    IlvBuilderPluginInstaller.this.a((IlvBuilderMode)messageEvent.getMessageParameters()[0], (IlvBuilderMode)messageEvent.getMessageParameters()[1]);
                }
            }
        }, "BUILDER_MODE_CHANGED");
        this.styleEditingMode = new IlvBuilderMode(ilvApplication, "StyleEditingMode", "default", null, "Builder.Title.StyleEditingMode");
        this.dataEditingMode = new IlvBuilderMode(ilvApplication, "DataEditingMode", "dataEditing", "dataEditing", "Builder.Title.DataEditingMode");
        this.runMode = new IlvBuilderMode(ilvApplication, "RunMode", "run", "run", "Builder.Title.RunMode");
        ilvApplication.addApplicationListener(new IlvApplicationAdapter(){

            @Override
            public void documentViewInitialized(ApplicationEvent applicationEvent) {
                IlvBuilderMode ilvBuilderMode;
                if (applicationEvent.getView() instanceof IlvSampleView && (ilvBuilderMode = IlvBuilderMode.getCurrentMode()) != IlvBuilderPluginInstaller.this.styleEditingMode) {
                    ((IlvSampleView)applicationEvent.getView()).modeChanged(IlvBuilderPluginInstaller.this.styleEditingMode, IlvBuilderMode.getCurrentMode());
                }
            }
        });
    }

    public final void setShowWizardAtStartup(boolean bl) {
        this.setPreferencesSetting("wizard", "showAtStartup", new Boolean(bl));
    }

    public final boolean isShowWizardAtStartup() {
        Object object = this.getPreferencesSetting("wizard", "showAtStartup");
        return object != null ? Boolean.valueOf((String)object) : true;
    }

    public final void setPreferencesSetting(String string, String string2, Object object) {
        IlvSettingsElement ilvSettingsElement = this.application.selectElement("preferences", null, null);
        IlvSettingsElement ilvSettingsElement2 = ilvSettingsElement.ensureChildElement(string);
        ilvSettingsElement2.setAttributeValue(string2, object);
    }

    public final Object getPreferencesSetting(String string, String string2) {
        IlvSettingsElement ilvSettingsElement = this.application.selectElement("preferences", null, null);
        IlvSettingsElement ilvSettingsElement2 = ilvSettingsElement.ensureChildElement(string);
        return ilvSettingsElement2.getAttributeValue(string2);
    }

    public static IlvBuilderPluginInstaller getInstaller(IlvBuilder ilvBuilder) {
        return (IlvBuilderPluginInstaller)ilvBuilder.getApplication().getProperty(a);
    }

    private void a(IlvBuilderMode ilvBuilderMode, IlvBuilderMode ilvBuilderMode2) {
        this.modeChanged(ilvBuilderMode, ilvBuilderMode2);
        IlvDocument[] ilvDocumentArray = this.application.getOpenDocuments();
        for (int i = 0; i < ilvDocumentArray.length; ++i) {
            IlvDocument ilvDocument = ilvDocumentArray[i];
            for (int j = 0; j < ilvDocument.getViewCount(); ++j) {
                IlvDocumentView ilvDocumentView = ilvDocument.getView(j);
                if (!(ilvDocumentView instanceof IlvSampleView)) continue;
                ((IlvSampleView)ilvDocumentView).modeChanged(ilvBuilderMode, ilvBuilderMode2);
            }
        }
    }

    protected void modeChanged(IlvBuilderMode ilvBuilderMode, IlvBuilderMode ilvBuilderMode2) {
        if (ilvBuilderMode2 == this.styleEditingMode) {
            this.styleEditingMode();
        } else if (ilvBuilderMode2 == this.dataEditingMode) {
            this.dataEditingMode();
        } else if (ilvBuilderMode2 == this.runMode) {
            this.runMode();
        }
    }

    protected void runMode() {
    }

    protected void dataEditingMode() {
    }

    protected void styleEditingMode() {
    }

    public int getMajorVersion() {
        return IlvFrameworkProduct.getVersion();
    }

    public int getMinorVersion() {
        return IlvFrameworkProduct.getMinorVersion();
    }

    public int getSubMinorVersion() {
        return IlvFrameworkProduct.getSubMinorVersion();
    }

    public int getPatchLevel() {
        return IlvFrameworkProduct.getPatchLevel();
    }

    public long getBuildNumber() {
        return IlvFrameworkProduct.getBuildNumber();
    }

    public int getReleaseDate() {
        return IlvFrameworkProduct.getReleaseDate();
    }
}

