/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.util.xml;

import ilog.views.appframe.settings.IlvSettings;
import ilog.views.appframe.settings.IlvSettingsModel;
import ilog.views.appframe.settings.xml.IlvXMLSettings;
import ilog.views.appframe.util.IlvUtil;
import ilog.views.appframe.util.logging.IlvLog;
import java.awt.Color;
import java.awt.Font;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class IlvXMLWriter {
    protected static final boolean DEFAULT_CANONICAL = false;
    protected PrintWriter stream;
    protected boolean fCanonical = false;
    protected String encoding = "UTF-8";
    protected String header = null;
    IlvSettings a = null;
    String b = IlvXMLSettings.DEFAULT_TAG_TEXT_ATTRIBUTE;
    private static String c = "     ";
    public static boolean SORT_ATTRIBUTES = true;
    public static final String DEFAULT_OUTPUT_ENCODING = "UTF-8";

    public IlvXMLWriter() {
    }

    public IlvXMLWriter(boolean bl) {
        this.fCanonical = bl;
    }

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string != null) {
            this.encoding = string;
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
        this.stream = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(OutputStream outputStream) throws UnsupportedEncodingException {
        this.setOutput(outputStream, null);
    }

    public void setOutput(Writer writer) throws UnsupportedEncodingException {
        this.stream = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void writeSettings(IlvSettings ilvSettings, IlvSettingsModel ilvSettingsModel) {
        if (!this.fCanonical) {
            this.stream.println("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            if (this.header != null) {
                this.stream.println(this.header);
            }
            this.stream.flush();
        }
        this.a(ilvSettings, ilvSettingsModel, "", true);
    }

    public void writeDocument(Document document) {
        if (!this.fCanonical) {
            this.stream.println("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            if (this.header != null) {
                this.stream.println(this.header);
            }
            this.stream.flush();
        }
        this.writeElement(document.getDocumentElement(), "");
    }

    void a(IlvSettings ilvSettings, IlvSettingsModel ilvSettingsModel, String string, boolean bl) {
        IlvSettings ilvSettings2 = this.a;
        this.a = ilvSettings;
        String string2 = this.b;
        if (ilvSettings instanceof IlvXMLSettings) {
            this.b = ((IlvXMLSettings)ilvSettings).getTagTextAttributeName();
        }
        if (ilvSettings instanceof IlvXMLSettings) {
            this.writeElement(((IlvXMLSettings)ilvSettings).getDocumentElement(), ilvSettingsModel, string);
        } else {
            Object[] objectArray = ilvSettingsModel.getChildren(null);
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            if (bl) {
                this.writeElement(objectArray[0], ilvSettingsModel, string);
                if (objectArray.length > 1) {
                    IlvLog.Log("ilog.views.appframe", IlvLog.WARNING, "Logging.XMLSettings.MoreThanOneRootNode", new Object[]{ilvSettings.getName()});
                }
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.writeElement(objectArray[i], ilvSettingsModel, string);
                }
            }
        }
        this.stream.flush();
        this.a = ilvSettings2;
        this.b = string2;
    }

    public void setHeaderComment(String string) {
        this.header = string;
    }

    public String getHeaderComment() {
        return this.header;
    }

    public void writeElement(Element element, String string) {
        int n;
        boolean bl;
        String string2;
        boolean bl2;
        NodeList nodeList;
        block18: {
            block19: {
                String string3 = "<" + element.getTagName();
                this.stream.print(string + string3);
                String string4 = "";
                for (int i = 0; i < string3.length() + 1; ++i) {
                    string4 = string4 + " ";
                }
                nodeList = element.getChildNodes();
                bl2 = nodeList != null && nodeList.getLength() > 0;
                string2 = IlvXMLWriter.a(element);
                bl = false;
                NamedNodeMap namedNodeMap = element.getAttributes();
                if (namedNodeMap != null && namedNodeMap.getLength() > 0) {
                    Attr[] attrArray = new Attr[namedNodeMap.getLength()];
                    for (n = 0; n < attrArray.length; ++n) {
                        attrArray[n] = (Attr)namedNodeMap.item(n);
                    }
                    if (SORT_ATTRIBUTES) {
                        Arrays.sort(attrArray, new AttributeComparator());
                    }
                    for (n = 0; n < attrArray.length; ++n) {
                        if (attrArray[n].getName().equals(this.b)) continue;
                        if (bl) {
                            this.stream.println("");
                            this.stream.print(string + string4);
                        } else {
                            this.stream.print(" ");
                        }
                        this.a(attrArray[n]);
                        bl = true;
                    }
                }
                if (bl2) break block18;
                if (string2 == null) break block19;
                if (string2.length() != 0) break block18;
            }
            this.stream.println("/>");
            return;
        }
        this.stream.print(">");
        boolean bl3 = false;
        if (bl2) {
            int n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                Node node;
                if (!bl3) {
                    this.stream.println("");
                }
                if (!((node = nodeList.item(n)) instanceof Element)) continue;
                this.writeElement((Element)node, string + c);
                bl3 = true;
            }
        }
        if (string2 != null && string2.length() > 0) {
            if (bl3) {
                this.stream.print(string + c);
            }
            this.stream.print(string2);
            bl3 = false;
        }
        if (bl3) {
            this.stream.print(string);
        } else if (bl) {
            this.stream.println("");
            this.stream.print(string);
        }
        this.stream.println("</" + element.getTagName() + ">");
    }

    public void writeElement(Object object, IlvSettingsModel ilvSettingsModel, String string) {
        int n;
        boolean bl;
        String string2;
        boolean bl2;
        Object[] objectArray;
        block17: {
            block18: {
                String string3 = "<" + ilvSettingsModel.getType(object);
                this.stream.print(string + string3);
                String string4 = "";
                for (int i = 0; i < string3.length() + 1; ++i) {
                    string4 = string4 + " ";
                }
                objectArray = ilvSettingsModel.getChildren(object);
                bl2 = objectArray != null && objectArray.length > 0;
                string2 = IlvXMLWriter.a(object, ilvSettingsModel);
                bl = false;
                String[] stringArray = ilvSettingsModel.getAttributes(object);
                if (stringArray != null && stringArray.length > 0) {
                    if (SORT_ATTRIBUTES) {
                        Object[] objectArray2 = new Object[stringArray.length];
                        System.arraycopy(stringArray, 0, objectArray2, 0, stringArray.length);
                        Arrays.sort(objectArray2);
                        System.arraycopy(objectArray2, 0, stringArray, 0, stringArray.length);
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        if (stringArray[n].equals(this.b)) continue;
                        if (bl) {
                            this.stream.println("");
                            this.stream.print(string + string4);
                        } else {
                            this.stream.print(" ");
                        }
                        this.a(stringArray[n], object, ilvSettingsModel);
                        bl = true;
                    }
                }
                if (bl2) break block17;
                if (string2 == null) break block18;
                if (string2.length() != 0) break block17;
            }
            this.stream.println("/>");
            return;
        }
        this.stream.print(">");
        n = 0;
        if (bl2) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (n == 0) {
                    this.stream.println("");
                }
                this.writeElement(objectArray[i], ilvSettingsModel, string + c);
                n = 1;
            }
        }
        if (string2 != null && string2.length() > 0) {
            if (n != 0) {
                this.stream.print(string + c);
            }
            this.stream.print(string2);
            n = 0;
        }
        if (n != 0) {
            this.stream.print(string);
        } else if (bl) {
            this.stream.println("");
            this.stream.print(string);
        }
        this.stream.println("</" + ilvSettingsModel.getType(object) + ">");
    }

    void a(Attr attr) {
        this.stream.print(attr.getName());
        this.stream.print("=\"");
        this.a(IlvXMLWriter.GetStringValue(attr.getValue()));
        this.stream.print('\"');
    }

    void a(String string, Object object, IlvSettingsModel ilvSettingsModel) {
        this.stream.print(string);
        this.stream.print("=\"");
        this.a(IlvXMLWriter.GetStringValue(ilvSettingsModel.getAttributeValue(object, string)));
        this.stream.print('\"');
    }

    void a(String string) {
        int n = string != null ? string.length() : 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.a(c);
        }
    }

    void a(char c) {
        switch (c) {
            case '<': {
                this.stream.print("&lt;");
                break;
            }
            case '>': {
                this.stream.print("&gt;");
                break;
            }
            case '&': {
                this.stream.print("&amp;");
                break;
            }
            case '\"': {
                this.stream.print("&quot;");
                break;
            }
            case '\n': 
            case '\r': {
                if (this.fCanonical) {
                    this.stream.print("&#");
                    this.stream.print(Integer.toString(c));
                    this.stream.print(';');
                    break;
                }
            }
            default: {
                this.stream.print(c);
            }
        }
    }

    public static String NormalizeString(String string, boolean bl) {
        int n = string != null ? string.length() : 0;
        StringBuffer stringBuffer = new StringBuffer(string.length() * 4);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (bl) {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        continue block7;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    static String a(Object object, IlvSettingsModel ilvSettingsModel) {
        NodeList nodeList;
        Object object2 = ilvSettingsModel.getAttributeValue(object, IlvXMLSettings.DEFAULT_TAG_TEXT_ATTRIBUTE);
        if (object2 != null && object2.toString().length() != 0) {
            return object2.toString();
        }
        String string = "";
        if (object instanceof Element && (nodeList = ((Element)object).getChildNodes()) != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 3 || (string2 = ((Text)node).getData()) == null) continue;
                int n = 0;
                for (n = 0; n < string2.length() && Character.isWhitespace(string2.charAt(n)); ++n) {
                }
                if (n == string2.length()) continue;
                string = string + string2;
            }
        }
        return string;
    }

    static String a(Element element) {
        NodeList nodeList = element.getChildNodes();
        String string = "";
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 3 || (string2 = ((Text)node).getData()) == null) continue;
                int n = 0;
                for (n = 0; n < string2.length() && Character.isWhitespace(string2.charAt(n)); ++n) {
                }
                if (n == string2.length()) continue;
                string = string + string2;
            }
        }
        return string;
    }

    public static String ElementString(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Element)) {
            return object.getClass().getName();
        }
        Element element = (Element)object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(' ');
                Attr attr = (Attr)namedNodeMap.item(i);
                stringBuffer.append(attr.getName());
                stringBuffer.append('=');
                stringBuffer.append('\"');
                stringBuffer.append(IlvXMLWriter.NormalizeString(element.getAttribute(attr.getName()), true));
                stringBuffer.append('\"');
            }
        }
        stringBuffer.append(' ');
        stringBuffer.append('/');
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String GetStringValue(Object object) {
        if (object instanceof Color) {
            return IlvUtil.EncodeColor((Color)object);
        }
        if (object instanceof Font) {
            return IlvUtil.EncodeFont((Font)object);
        }
        return object.toString();
    }

    static class AttributeComparator
    implements Comparator {
        AttributeComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Attr)object).getName().compareTo(((Attr)object2).getName());
        }
    }
}

