/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.util;

import ilog.views.appframe.IlvAction;
import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.form.IlvFormException;
import ilog.views.appframe.form.services.IlvServicesProvider;
import ilog.views.appframe.form.swing.IlvSwingForm;
import ilog.views.appframe.form.swing.IlvSwingFormReader;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.settings.internal.IlvSettingsUtils;
import ilog.views.appframe.swing.util.IlvAppFrameServicesProvider;
import ilog.views.appframe.swing.util.IlvJDKWorkaroundPopupListener;
import ilog.views.appframe.util.IlvUtil;
import ilog.views.util.swing.IlvSwingUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class IlvSwingUtil {
    private static IlvSwingUtil.Version a = null;
    private static IlvSwingUtil.Version b = null;
    private static HashMap c = new HashMap();
    static ImageIcon d = null;
    public static final String MAIN_WINDOW_INITIALIZED_PROPERTY = "MainWindowInitialized";

    private IlvSwingUtil() {
    }

    public static void EnsureComponentOrientation(Component component, IlvApplication ilvApplication) {
        ComponentOrientation componentOrientation;
        if (component == null) {
            return;
        }
        ComponentOrientation componentOrientation2 = component.getComponentOrientation();
        if (componentOrientation2.equals(componentOrientation = ilvApplication.getComponentOrientation())) {
            return;
        }
        ilog.views.util.swing.IlvSwingUtil.updateComponentTreeOrientation(component, componentOrientation);
    }

    public static JMenuItem CreateMenuItem(Action action, IlvApplication ilvApplication, JMenuItem jMenuItem) {
        JMenuItem jMenuItem2;
        if (IlvSwingUtil.HasBooleanProperty(action, "checkable") && IlvSwingUtil.IsStandardCheckActionLook(action, ilvApplication)) {
            if (jMenuItem != null) {
                if (JCheckBoxMenuItem.class.isAssignableFrom(jMenuItem.getClass())) {
                    return jMenuItem;
                }
            }
            jMenuItem2 = new JCheckBoxMenuItem();
        } else if (IlvSwingUtil.HasBooleanProperty(action, "listInSubmenu")) {
            if (jMenuItem != null) {
                if (JMenu.class.isAssignableFrom(jMenuItem.getClass())) {
                    return jMenuItem;
                }
            }
            jMenuItem2 = new JMenu();
            ((JMenu)jMenuItem2).getPopupMenu().addPopupMenuListener(IlvJDKWorkaroundPopupListener.LISTENER);
        } else {
            if (jMenuItem != null) {
                return jMenuItem;
            }
            jMenuItem2 = new JMenuItem();
        }
        IlvAction.SetAction(jMenuItem2, action, ilvApplication, 0);
        return jMenuItem2;
    }

    public static boolean IsJDK1_4_1_OrHigher() {
        if (a == null) {
            a = new IlvSwingUtil.Version(1, 4, 1);
        }
        return ilog.views.util.swing.IlvSwingUtil.getSwingVersion().intValue() >= a.intValue();
    }

    public static boolean IsJDK1_4_OrHigher() {
        if (b == null) {
            b = new IlvSwingUtil.Version(1, 4, 0);
        }
        return ilog.views.util.swing.IlvSwingUtil.getSwingVersion().intValue() >= b.intValue();
    }

    public static Container GetContentPane(Container container) {
        if (container instanceof JWindow) {
            return ((JWindow)container).getContentPane();
        }
        if (container instanceof JApplet) {
            return ((JApplet)container).getContentPane();
        }
        if (container instanceof JDialog) {
            return ((JDialog)container).getContentPane();
        }
        if (container instanceof JInternalFrame) {
            return ((JInternalFrame)container).getContentPane();
        }
        if (container instanceof JFrame) {
            return ((JFrame)container).getContentPane();
        }
        if (container instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)container)).getContentPane();
        }
        if (container instanceof JRootPane) {
            return ((JRootPane)container).getContentPane();
        }
        return container;
    }

    public static boolean HasBooleanProperty(Action action, String string) {
        Boolean bl = (Boolean)action.getValue(string);
        return bl == null ? false : bl;
    }

    public static boolean IsLeftToRight(Locale locale) {
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(locale);
        return componentOrientation != null ? componentOrientation.isLeftToRight() : true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean IsStandardCheckActionLook(Action action, IlvApplication ilvApplication) {
        String string = (String)action.getValue("checkLook");
        if (string == null) {
            string = (String)ilvApplication.getProperty("checkLook");
        }
        if (string == null) return true;
        if (!string.equals("standard")) return false;
        return true;
    }

    public static void UpdateWithActions(MenuElement[] menuElementArray, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Component component;
        int n;
        if (menuElementArray == null || menuElementArray.length == 0) {
            return;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        Object[] objectArray = null;
        for (n = 0; n < menuElementArray.length; ++n) {
            component = menuElementArray[n].getComponent();
            if (component instanceof JMenuItem) {
                object2 = (JMenuItem)component;
                if (((AbstractButton)object2).getIcon() != null) {
                    bl3 = true;
                } else {
                    bl4 = true;
                }
                if (bl && (object = ((AbstractButton)object2).getAction()) != null) {
                    if (object.getValue("isList") != null && IlvUtil.IndexOf(objectArray, object) == -1) {
                        objectArray = IlvUtil.AddToArray(objectArray, object);
                    }
                }
            }
            if (!bl2) continue;
            IlvSwingUtil.UpdateWithActions(menuElementArray[n].getSubElements(), bl, true);
        }
        if (bl4 && bl3) {
            for (n = 0; n < menuElementArray.length; ++n) {
                component = menuElementArray[n].getComponent();
                if (!(component instanceof JMenuItem) || ((AbstractButton)(object2 = (JMenuItem)component)).getIcon() != null) continue;
                ((AbstractButton)object2).setIcon(IlvSwingUtil.a());
            }
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                object2 = (Action)objectArray[i];
                object = object2.getValue("listItems");
                if (object == null) {
                    object2.putValue("listItems", new Object[0]);
                    continue;
                }
                object2.putValue("listItems", null);
                object2.putValue("listItems", object);
            }
        }
    }

    public static void DoCursor(Component component, Cursor cursor) {
        if (cursor != null) {
            IlvSwingUtil.SetCursor(component, cursor);
        } else {
            IlvSwingUtil.RestoreCursors(component);
        }
    }

    public static void RestoreCursors(Component component) {
        Serializable serializable;
        if (c.containsKey(component)) {
            serializable = (Cursor)c.remove(component);
            component.setCursor((Cursor)serializable);
        }
        if (component instanceof Container) {
            serializable = (Container)component;
            int n = ((Container)serializable).getComponentCount();
            for (int i = 0; i < n; ++i) {
                IlvSwingUtil.RestoreCursors(((Container)serializable).getComponent(i));
            }
        }
    }

    public static void SetCursor(Component component, Cursor cursor) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                IlvSwingUtil.SetCursor(container.getComponent(i), cursor);
            }
        }
        if (!c.containsKey(component)) {
            c.put(component, component.isCursorSet() ? component.getCursor() : null);
        }
        component.setCursor(cursor);
    }

    static ImageIcon a() {
        if (d != null) {
            return d;
        }
        URL uRL = IlvApplication.class.getResource("images/empty.gif");
        if (uRL == null) {
            return null;
        }
        d = new ImageIcon(uRL);
        return d;
    }

    public static Color CreateAlphaColor(Color color, float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Alpha value must be in the range [0,1]");
        }
        int n = (int)(f * 255.0f + 0.5f);
        if (color.getAlpha() == n) {
            return color;
        }
        return new Color(color.getRGB() & 0xFFFFFF | n << 24, true);
    }

    public static boolean IsGradientsOn() {
        boolean bl = UIManager.getLookAndFeel().getName().equals("Windows");
        if (bl) {
            Boolean bl2 = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.frame.captionGradientsOn");
            if (bl2 == null) {
                return false;
            }
            return bl2;
        }
        return false;
    }

    public static String GetComponentParamString(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Action action = abstractButton.getAction();
            if (action != null) {
                return IlvSwingUtil.GetShortClassName(component) + "[" + action.getValue("ActionCommandKey") + "]";
            }
            return IlvSwingUtil.GetShortClassName(component) + "[" + abstractButton.getText() + "]";
        }
        if (component instanceof JLabel) {
            return IlvSwingUtil.GetShortClassName(component) + "[" + ((JLabel)component).getText() + "]";
        }
        if (component instanceof JTextComponent) {
            String string = ((JTextComponent)component).getText();
            if (string != null && string.length() != 0) {
                return IlvSwingUtil.GetShortClassName(component) + "[" + string + "]";
            }
            return IlvSwingUtil.GetShortClassName(component);
        }
        return IlvSwingUtil.GetShortClassName(component);
    }

    public static String GetShortClassName(Object object) {
        return IlvSwingUtil.GetShortClassName(object.getClass());
    }

    public static String GetShortClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static Component ReadComponent(IlvSettingsElement ilvSettingsElement, IlvApplication ilvApplication) throws IlvFormException {
        IlvSwingFormReader ilvSwingFormReader = new IlvSwingFormReader();
        return ilvSwingFormReader.readComponent(IlvSettingsUtils.GetDOMElement(ilvSettingsElement), IlvAppFrameServicesProvider.GetServicesProvider(ilvApplication));
    }

    public static IlvSwingForm ReadComponentContent(Component component, IlvSettingsElement ilvSettingsElement, IlvApplication ilvApplication) throws IlvFormException {
        IlvSwingFormReader ilvSwingFormReader = new IlvSwingFormReader();
        return ilvSwingFormReader.readComponentContent(component, IlvSettingsUtils.GetDOMElement(ilvSettingsElement), IlvAppFrameServicesProvider.GetServicesProvider(ilvApplication));
    }

    public static IlvSwingForm ReadForm(Container container, URL uRL, IlvApplication ilvApplication) throws IlvFormException {
        IlvSwingFormReader ilvSwingFormReader = new IlvSwingFormReader();
        return ilvSwingFormReader.readForm(container, uRL, (IlvServicesProvider)IlvAppFrameServicesProvider.GetServicesProvider(ilvApplication));
    }

    public static boolean IsMainWindowInitialized(IlvApplication ilvApplication) {
        return IlvSwingUtil.a(ilvApplication) == 0;
    }

    public static void LockMainWindowInitialized(IlvApplication ilvApplication) {
        ilvApplication.setProperty(MAIN_WINDOW_INITIALIZED_PROPERTY, new Integer(IlvSwingUtil.a(ilvApplication) + 1));
    }

    public static void UnLockMainWindowInitialized(IlvApplication ilvApplication) {
        int n = IlvSwingUtil.a(ilvApplication);
        if (n == 0) {
            throw new IllegalStateException("The unlock count on the main window exceeds the lock count");
        }
        ilvApplication.setProperty(MAIN_WINDOW_INITIALIZED_PROPERTY, new Integer(n - 1));
    }

    private static int a(IlvApplication ilvApplication) {
        Integer n = (Integer)ilvApplication.getProperty(MAIN_WINDOW_INITIALIZED_PROPERTY);
        return n == null ? 0 : n;
    }

    public static Action GetAssociatedAction(Component component) {
        if (component instanceof AbstractButton) {
            return ((AbstractButton)component).getAction();
        }
        if (component instanceof JComboBox) {
            return ((JComboBox)component).getAction();
        }
        if (component instanceof JTextField) {
            return ((JTextField)component).getAction();
        }
        return null;
    }
}

