/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.plugin;

import ilog.views.appframe.plugin.IlvPluginVersion;
import ilog.views.appframe.plugin.IlvPluginVersionFilter;
import ilog.views.appframe.plugin.PluginMessages;
import ilog.views.appframe.settings.IlvSettingsElement;

class PredefinedVersionFilter {
    private static String a = "perfect";
    private static String b = "equivalent";
    private static String c = "compatible";
    private static String d = "greaterOrEqual";

    PredefinedVersionFilter() {
    }

    public static IlvPluginVersionFilter CreatePredefinedFilter(String string) {
        if (a.equalsIgnoreCase(string)) {
            return new PerfectVersionFilter();
        }
        if (b.equalsIgnoreCase(string)) {
            return new EquivalentVersionFilter();
        }
        if (c.equalsIgnoreCase(string)) {
            return new CompatibleVersionFilter();
        }
        if (d.equalsIgnoreCase(string)) {
            return new GreaterOrEqualVersionFilter();
        }
        return null;
    }

    public static IlvPluginVersionFilter CreateDefaultFilter() {
        return new CompatibleVersionFilter();
    }

    private static class GreaterOrEqualVersionFilter
    extends AbstractPluginVersionFilter {
        private GreaterOrEqualVersionFilter() {
        }

        @Override
        public short match(IlvPluginVersion ilvPluginVersion) {
            return ilvPluginVersion.isGreaterOrEqualTo(this.a) ? (short)3 : 0;
        }

        public String toString() {
            return PluginMessages.a("Plugin.Filter.IsGreaterOrEqualTo", new Object[]{this.a.toString()});
        }
    }

    private static class CompatibleVersionFilter
    extends AbstractPluginVersionFilter {
        private CompatibleVersionFilter() {
        }

        @Override
        public short match(IlvPluginVersion ilvPluginVersion) {
            return ilvPluginVersion.isCompatibleWith(this.a) ? (short)1 : 0;
        }

        public String toString() {
            return PluginMessages.a("Plugin.Filter.CompatibleFormat", new Object[]{this.a.toString()});
        }
    }

    private static class EquivalentVersionFilter
    extends AbstractPluginVersionFilter {
        private EquivalentVersionFilter() {
        }

        @Override
        public short match(IlvPluginVersion ilvPluginVersion) {
            return ilvPluginVersion.isEquivalentTo(this.a) ? (short)2 : 0;
        }

        public String toString() {
            return PluginMessages.a("Plugin.Filter.EquivalentFormat", new Object[]{this.a.toString()});
        }
    }

    private static class PerfectVersionFilter
    extends AbstractPluginVersionFilter {
        private PerfectVersionFilter() {
        }

        @Override
        public short match(IlvPluginVersion ilvPluginVersion) {
            return ilvPluginVersion.isPerfect(this.a) ? (short)3 : 0;
        }

        public String toString() {
            return PluginMessages.a("Plugin.Filter.PerfectFormat", new Object[]{this.a.toString()});
        }
    }

    private static abstract class AbstractPluginVersionFilter
    implements IlvPluginVersionFilter {
        IlvPluginVersion a;

        private AbstractPluginVersionFilter() {
        }

        @Override
        public abstract short match(IlvPluginVersion var1);

        @Override
        public void read(IlvSettingsElement ilvSettingsElement) throws Exception {
            this.a = new IlvPluginVersion(ilvSettingsElement.getString("version"));
        }

        protected IlvPluginVersion getVersion() {
            return this.a;
        }
    }
}

