/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.util.text.IlvBidiUtil;
import ilog.views.util.text.IlvWrappedICUBreakIterator;
import java.awt.ComponentOrientation;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.BreakIterator;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class IlvGraphicBidiUtil {
    private IlvGraphicBidiUtil() {
    }

    public static KeyListener getTextKeyListener(int n) {
        return new TextKeyListener(n);
    }

    public static KeyListener getJTextKeyListener(IlvGraphic ilvGraphic, JTextComponent jTextComponent) {
        return new JTextKeyListener(ilvGraphic, jTextComponent, true);
    }

    public static KeyListener getJTextKeyListener(IlvGraphic ilvGraphic, JTextComponent jTextComponent, boolean bl) {
        return new JTextKeyListener(ilvGraphic, jTextComponent, bl);
    }

    public static TextField getBidiTextField(int n, int n2) {
        return new BidiTextField(n, n2);
    }

    public static TextArea getBidiTextArea(String string, int n, int n2, int n3) {
        return new BidiTextArea(string, n, n2, n3);
    }

    private static class BidiTextArea
    extends TextArea {
        int a = 516;

        public BidiTextArea(String string, int n, int n2, int n3) {
            super(string, n, n2, 3);
            this.a = n3;
            this.addKeyListener(new TextKeyListener(n3));
        }

        public boolean isRTL() {
            if (this.a == 516) {
                return false;
            }
            if (this.a == 520) {
                return true;
            }
            return IlvBidiUtil.isStringRTL(this.getText(), null);
        }
    }

    private static class BidiTextField
    extends TextField {
        int a = 516;

        public BidiTextField(int n, int n2) {
            super(n);
            this.a = n2;
            this.addKeyListener(new TextKeyListener(n2));
        }

        public boolean isRTL() {
            if (this.a == 516) {
                return false;
            }
            if (this.a == 520) {
                return true;
            }
            return IlvBidiUtil.isStringRTL(this.getText(), null);
        }
    }

    private static class JTextKeyListener
    extends KeyAdapter {
        IlvGraphic a;
        int b = 516;
        boolean c = true;
        JTextComponent d;

        JTextKeyListener(IlvGraphic ilvGraphic, JTextComponent jTextComponent, boolean bl) {
            this.a = ilvGraphic;
            this.b = ilvGraphic.getResolvedBaseTextDirection();
            this.c = bl;
            this.d = jTextComponent;
            boolean bl2 = false;
            if (ilvGraphic instanceof IlvLabelInterface) {
                ComponentOrientation componentOrientation = this.a.getComponentOrientation();
                bl2 = IlvBidiUtil.isStringRTL(ilvGraphic, ((IlvLabelInterface)((Object)ilvGraphic)).getLabel(), componentOrientation);
            }
            switch (this.b) {
                case 527: {
                    this.d.applyComponentOrientation(bl2 ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
                    this.a(true);
                    break;
                }
                case 520: {
                    this.d.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                    this.a(false);
                    break;
                }
                default: {
                    this.d.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                    this.a(false);
                }
            }
        }

        private void a(boolean bl) {
            DocumentFilter documentFilter = bl ? IlvBidiUtil.getBidiDocumentHandler(this.d, this.a.getComponentOrientation()) : null;
            AbstractDocument abstractDocument = (AbstractDocument)this.d.getDocument();
            abstractDocument.setDocumentFilter(documentFilter);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            int n2 = keyEvent.getKeyCode();
            int n3 = this.d.getSelectionEnd();
            int n4 = this.d.getText().length();
            BreakIterator breakIterator = IlvWrappedICUBreakIterator.getCharacterInstance();
            breakIterator.setText(this.d.getText());
            for (n = this.d.getSelectionStart(); n < n4 && !breakIterator.isBoundary(n); ++n) {
            }
            while (n3 < n4 && !breakIterator.isBoundary(n3)) {
                ++n3;
            }
            if (n2 == 127 && n == n3 && n3 < n4) {
                ++n3;
                while (n3 < n4 && !breakIterator.isBoundary(n3)) {
                    ++n3;
                }
            }
            this.d.select(n, n3);
            if (!this.c) {
                return;
            }
            if (keyEvent.getModifiers() != 3) {
                return;
            }
            String string = this.d.getText();
            switch (n2) {
                case 40: {
                    if (this.b == 527) {
                        return;
                    }
                    this.b = 527;
                    this.a.setBaseTextDirection(this.b);
                    this.a(true);
                    boolean bl = IlvBidiUtil.isStringRTL(this.d.getText(), this.b, this.a.getComponentOrientation());
                    this.d.applyComponentOrientation(bl ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
                    break;
                }
                case 39: {
                    if (this.b == 516) {
                        return;
                    }
                    this.b = 516;
                    this.a.setBaseTextDirection(this.b);
                    this.a(false);
                    this.d.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                    break;
                }
                case 37: {
                    if (this.b == 520) {
                        return;
                    }
                    this.b = 520;
                    this.a.setBaseTextDirection(this.b);
                    this.a(false);
                    this.d.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                    break;
                }
                case 38: {
                    if (this.b == 514) {
                        return;
                    }
                    this.b = 514;
                    this.a.setBaseTextDirection(this.b);
                    this.a(false);
                    this.d.applyComponentOrientation(this.a.getComponentOrientation());
                    break;
                }
                default: {
                    return;
                }
            }
            this.d.setText(this.d.getText());
        }
    }

    private static class TextKeyListener
    extends KeyAdapter {
        int a = 514;

        public TextKeyListener(int n) {
            this.a = n;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (!this.a(keyEvent)) {
                keyEvent.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!this.a(keyEvent)) {
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.a(keyEvent);
            if (this.a != 527) {
                return;
            }
            TextComponent textComponent = (TextComponent)keyEvent.getComponent();
            String string = IlvBidiUtil.removeMarksFromString(textComponent.getText());
            boolean bl = IlvBidiUtil.isStringRTL(string, this.a, null);
            if (IlvBidiUtil.checkStrongDir(textComponent.getText(), IlvBidiUtil.isStringRTL(string, this.a, null))) {
                return;
            }
            int n = textComponent.getSelectionStart();
            int n2 = textComponent.getSelectionEnd();
            string = IlvBidiUtil.getStringWithMarks(string, bl, true, false, true);
            textComponent.setText(string);
            textComponent.select(n, n2);
        }

        private boolean a(KeyEvent keyEvent) {
            TextComponent textComponent = (TextComponent)keyEvent.getComponent();
            int n = textComponent.getSelectionStart();
            if (n > 1) {
                return true;
            }
            int n2 = textComponent.getSelectionEnd();
            if (keyEvent.getKeyCode() == 8) {
                if (n == n2) {
                    return false;
                }
                ++n;
            } else if (n == 0) {
                n = 1;
                n2 = Math.min(1, n2);
            }
            textComponent.select(n, n2);
            return true;
        }
    }
}

