/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.print.ui.Dialog;

abstract class Chooser
extends Dialog {
    private Object myValue;
    private PropertyEditor myEditor;

    private Chooser(String title, Object value, boolean doCheck, boolean isResizable) {
        super(title);
        this.setEditor(PropertyEditorManager.findEditor(value.getClass()), value, doCheck, isResizable);
    }

    private Chooser(String title) {
        super(title);
    }

    protected final void setEditor(PropertyEditor editor, Object value, boolean doCheck, boolean isResizable) {
        if (doCheck && editor.getClass().getName().startsWith("sun.beans.editors.")) {
            this.myEditor = null;
        } else {
            this.myEditor = editor;
            this.myEditor.setValue(value);
            this.myValue = value;
            this.init(isResizable);
            this.setVisible(true);
        }
    }

    @Override
    protected Component getInnerComponent() {
        return this.myEditor.getCustomEditor();
    }

    @Override
    protected JButton[] getButtons() {
        JButton ok = this.createButton(new Dialog.ButtonAction(this.i18n("LBL_OK"), this.i18n("TLT_OK")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Chooser.this.myValue = Chooser.this.myEditor.getValue();
                Chooser.this.close();
            }
        });
        JButton cancel = this.createButton(new Dialog.ButtonAction(this.i18n("LBL_Cancel"), this.i18n("TLT_Cancel")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Chooser.this.close();
            }
        });
        this.markAsDefault(ok);
        return new JButton[]{ok, cancel};
    }

    protected final PropertyEditor getEditor() {
        return this.myEditor;
    }

    private Object getValue() {
        return this.myValue;
    }

    static final class FontDialog
    extends Chooser {
        private static final int MIN_SIZE = 1;
        private static final int MAX_SIZE = 98;
        private static final int STYLE_WIDTH = 77;
        private static final int SIZE_WIDTH = 57;
        private static final int TEXT_HEIGHT = 87;
        private static final Integer[] SIZES = new Integer[98];

        FontDialog(Font font, boolean enabled) {
            super("LBL_Choose_Font");
            this.setEditor(new FontEditor(enabled), font, false, true);
        }

        @Override
        Font getValue() {
            return (Font)super.getValue();
        }

        @Override
        protected String getHelpTopic() {
            return "f1_idedprintchoosefont_html";
        }

        private final class FontEditor
        extends JComponent
        implements PropertyEditor,
        ListSelectionListener {
            private JList myFontList;
            private JList myStyleList;
            private JList mySizeList;
            private JTextArea myPreview;
            private boolean myFireEvent;

            private FontEditor(boolean enabled) {
                this.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 18;
                for (int i = 1; i <= 98; ++i) {
                    FontDialog.SIZES[i - 1] = i;
                }
                ++c.gridy;
                c.weightx = 1.0;
                c.insets = new Insets(8, 3, 2, 13);
                JLabel fontLabel = FontDialog.this.createLabel(FontDialog.this.i18n("LBL_Font"));
                this.add((Component)fontLabel, c);
                JLabel styleLabel = FontDialog.this.createLabel(FontDialog.this.i18n("LBL_Style"));
                styleLabel.setEnabled(enabled);
                this.add((Component)styleLabel, c);
                JLabel sizeLabel = FontDialog.this.createLabel(FontDialog.this.i18n("LBL_Size"));
                this.add((Component)sizeLabel, c);
                ++c.gridy;
                c.weighty = 1.0;
                c.fill = 1;
                c.insets = new Insets(5, 3, 2, 13);
                this.myFontList = new JList<String>(this.getFonts());
                fontLabel.setLabelFor(this.myFontList);
                this.myFontList.addListSelectionListener(this);
                JScrollPane fontScroll = new JScrollPane(this.myFontList);
                fontScroll.setVerticalScrollBarPolicy(22);
                this.add((Component)fontScroll, c);
                this.myStyleList = new JList<String>(new String[]{FontDialog.this.i18n("LBL_Plain"), FontDialog.this.i18n("LBL_Bold"), FontDialog.this.i18n("LBL_Italic"), FontDialog.this.i18n("LBL_Bold_Italic")});
                this.myStyleList.setEnabled(enabled);
                FontDialog.this.setWidth(this.myStyleList, 77);
                styleLabel.setLabelFor(this.myStyleList);
                this.myStyleList.addListSelectionListener(this);
                JScrollPane styleScroll = new JScrollPane(this.myStyleList);
                styleScroll.setVerticalScrollBarPolicy(22);
                this.add((Component)styleScroll, c);
                this.mySizeList = new JList<Integer>(SIZES);
                FontDialog.this.setWidth(this.mySizeList, 57);
                sizeLabel.setLabelFor(this.mySizeList);
                c.insets = new Insets(5, 2, 2, 3);
                this.mySizeList.addListSelectionListener(this);
                JScrollPane sizeScroll = new JScrollPane(this.mySizeList);
                sizeScroll.setVerticalScrollBarPolicy(22);
                this.add((Component)sizeScroll, c);
                ++c.gridy;
                c.gridwidth = 3;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.fill = 1;
                c.insets = new Insets(13, 0, 8, 0);
                this.myPreview = FontDialog.this.createTextArea(FontDialog.this.i18n("MSG_Text"), FontDialog.this.i18n("LBL_Preview"), 87);
                this.add((Component)this.myPreview, c);
            }

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (this.myFireEvent) {
                    this.updatePreview((Font)this.getValue());
                }
            }

            @Override
            public void setValue(Object value) {
                if (!(value instanceof Font)) {
                    return;
                }
                this.myFireEvent = false;
                Font font = (Font)value;
                ListModel fontModel = this.myFontList.getModel();
                int i = fontModel.getSize();
                while (--i >= 0) {
                    if (!fontModel.getElementAt(i).equals(font.getFamily())) continue;
                    this.myFontList.setSelectedIndex(i);
                    break;
                }
                this.myStyleList.setSelectedIndex(this.getIndex(font));
                ListModel sizeModel = this.mySizeList.getModel();
                for (int i2 = 0; i2 < sizeModel.getSize(); ++i2) {
                    if ((Integer)sizeModel.getElementAt(i2) < font.getSize()) continue;
                    this.mySizeList.setSelectedIndex(i2);
                    break;
                }
                this.myFireEvent = true;
                this.updatePreview(font);
            }

            private int getIndex(Font font) {
                int index = 0;
                if (font.isBold()) {
                    index |= 1;
                }
                if (font.isItalic()) {
                    index |= 2;
                }
                return index;
            }

            @Override
            public Object getValue() {
                String font = (String)this.myFontList.getSelectedValue();
                int style = this.myStyleList.getSelectedIndex();
                int size = (Integer)this.mySizeList.getSelectedValue();
                return new Font(font, style, size);
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public String getAsText() {
                return null;
            }

            @Override
            public Component getCustomEditor() {
                return this;
            }

            @Override
            public String getJavaInitializationString() {
                return null;
            }

            @Override
            public String[] getTags() {
                return null;
            }

            @Override
            public boolean isPaintable() {
                return true;
            }

            @Override
            public void paintValue(Graphics g, Rectangle box) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void setAsText(String text) {
            }

            @Override
            public boolean supportsCustomEditor() {
                return true;
            }

            private String[] getFonts() {
                return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            }

            private void updatePreview(Font font) {
                this.myPreview.setFont(font);
                this.revalidate();
                this.repaint();
            }
        }
    }

    static final class ColorDialog
    extends Chooser {
        private Color myColor;

        ColorDialog(Color color) {
            super("LBL_Choose_Color", color, true, false);
            this.myColor = color;
        }

        @Override
        Color getValue() {
            if (this.getEditor() != null) {
                return (Color)super.getValue();
            }
            Color value = JColorChooser.showDialog(this, this.getTitle(), this.myColor);
            return value == null ? this.myColor : value;
        }

        @Override
        protected String getHelpTopic() {
            return "f1_idedprintcolorchooser_html";
        }
    }
}

