/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.misc;

import javax.swing.AbstractButton;
import javax.swing.JLabel;

public final class Mnemonics {
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC = "mnemonic";

    private Mnemonics() {
    }

    public static void setTextAndToolTip(Object item, String text, String toolTip) {
        Object value = text == null ? toolTip : text;
        int i = Mnemonics.findAmpersand((String)value);
        if (i < 0) {
            Mnemonics.setTextAndToolTip(item, (String)text, 0, (String)toolTip);
        } else {
            if (text == null) {
                toolTip = ((String)value).substring(0, i) + ((String)value).substring(i + 1);
            } else {
                text = ((String)value).substring(0, i) + ((String)value).substring(i + 1);
            }
            Mnemonics.setTextAndToolTip(item, (String)text, ((String)value).charAt(i + 1), (String)toolTip);
        }
    }

    private static int findAmpersand(String text) {
        int i = -1;
        do {
            if ((i = text.indexOf(38, i + 1)) < 0 || i + 1 >= text.length() || text.charAt(i + 1) == ' ' || text.charAt(i + 1) == '\'' && i > 0 && text.charAt(i - 1) == '\'') continue;
            return i;
        } while (i >= 0);
        return -1;
    }

    private static void setTextAndToolTip(Object item, String text, int mnemonic, String toolTip) {
        if (mnemonic >= 97 && mnemonic <= 122) {
            mnemonic += -32;
        }
        if (item instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)item;
            button.putClientProperty(PROP_MNEMONIC, mnemonic);
            button.setMnemonic(mnemonic);
            button.setToolTipText(Mnemonics.cutMnemonicAndAmpersand(toolTip));
            button.putClientProperty(PROP_TEXT, text);
            button.setText(Mnemonics.cutMnemonicAndAmpersand(text));
        } else {
            JLabel label = (JLabel)item;
            label.setText(Mnemonics.cutMnemonicAndAmpersand(text));
            label.setDisplayedMnemonic(mnemonic);
        }
    }

    private static String cutMnemonicAndAmpersand(String value) {
        if (value == null) {
            return null;
        }
        int k = value.lastIndexOf("//");
        if (k != -1) {
            value = value.substring(0, k).trim();
        }
        if ((k = value.indexOf("&")) == -1) {
            return value;
        }
        return value.substring(0, k) + value.substring(k + 1);
    }
}

