/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.io.InputStream;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import oracle.security.xmlsec.c14n.StreamingC14NImpl;
import oracle.security.xmlsec.util.NodeReader;
import oracle.security.xmlsec.util.NodeReaderException;
import org.w3c.dom.Node;

public class NodeReaderForStAX
extends NodeReader {
    XMLStreamReader rd;
    private AttribIterator iter = new AttribIterator();
    private char[] text;

    public NodeReaderForStAX(InputStream is, String systemId) throws NodeReaderException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this.rd = factory.createXMLStreamReader(systemId, is);
        }
        catch (XMLStreamException e) {
            throw new NodeReaderException(e);
        }
    }

    public NodeReaderForStAX(Source is) throws NodeReaderException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this.rd = factory.createXMLStreamReader(is);
        }
        catch (XMLStreamException e) {
            throw new NodeReaderException(e);
        }
    }

    public NodeReaderForStAX(XMLStreamReader streamReader) {
        this.rd = streamReader;
    }

    @Override
    public final boolean hasNext() throws NodeReaderException {
        try {
            return this.rd.hasNext();
        }
        catch (XMLStreamException e) {
            throw new NodeReaderException(e);
        }
    }

    @Override
    public final int next() throws NodeReaderException {
        this.text = null;
        try {
            return this.rd.next();
        }
        catch (XMLStreamException e) {
            throw new NodeReaderException(e);
        }
    }

    @Override
    public final int getEventType() {
        return this.rd.getEventType();
    }

    @Override
    public final String getLocalName() {
        return this.rd.getLocalName();
    }

    @Override
    public final String getNamespaceURI() {
        return this.rd.getNamespaceURI();
    }

    @Override
    public final String getPrefix() {
        return this.rd.getPrefix();
    }

    @Override
    public final char[] getText() {
        if (this.text == null) {
            this.text = this.rd.getText().toCharArray();
        }
        return this.text;
    }

    @Override
    public final int getTextStart() {
        return 0;
    }

    @Override
    public final int getTextLength() {
        if (this.text == null) {
            this.text = this.rd.getText().toCharArray();
        }
        return this.text.length;
    }

    @Override
    public final String getPIData() {
        return this.rd.getPIData();
    }

    @Override
    public final String getPITarget() {
        return this.rd.getPITarget();
    }

    @Override
    public final boolean isElementIncluded() {
        return true;
    }

    @Override
    public final Node getNode() {
        return null;
    }

    @Override
    public final Iterator getAttributes() {
        this.iter.init();
        return this.iter;
    }

    private class AttribIterator
    implements Iterator {
        int attribCount;
        int attribIndex;
        int nsCount;
        int nsIndex;

        private AttribIterator() {
        }

        void init() {
            this.attribCount = NodeReaderForStAX.this.rd.getAttributeCount();
            this.attribIndex = 0;
            this.nsCount = NodeReaderForStAX.this.rd.getNamespaceCount();
            this.nsIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.attribIndex < this.attribCount || this.nsIndex < this.nsCount;
        }

        public Object next() {
            if (this.nsIndex < this.nsCount) {
                String nsPrefix = NodeReaderForStAX.this.rd.getNamespacePrefix(this.nsIndex);
                String nsValue = NodeReaderForStAX.this.rd.getNamespaceURI(this.nsIndex);
                StreamingC14NImpl.AttrObj ns = new StreamingC14NImpl.AttrObj("http://www.w3.org/2000/xmlns/", "xmlns", nsPrefix == null ? "" : nsPrefix, null, nsValue == null ? "" : nsValue);
                ++this.nsIndex;
                return ns;
            }
            StreamingC14NImpl.AttrObj nd = new StreamingC14NImpl.AttrObj(NodeReaderForStAX.this.rd.getAttributeNamespace(this.attribIndex), NodeReaderForStAX.this.rd.getAttributePrefix(this.attribIndex), NodeReaderForStAX.this.rd.getAttributeLocalName(this.attribIndex), null, NodeReaderForStAX.this.rd.getAttributeValue(this.attribIndex));
            ++this.attribIndex;
            return nd;
        }

        @Override
        public void remove() {
        }
    }
}

