/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Node;

public class NodeIterator
implements Iterator {
    protected Node nextNode;
    private Iterator iterator;
    private NodeFilter filter;
    private static final boolean debugFilter = System.getProperty("xml.debug.filter") != null;

    public NodeIterator(Collection c) {
        this.iterator = c.iterator();
    }

    public NodeIterator(Collection c, NodeFilter filter) {
        this(c);
        this.filter = filter;
    }

    public NodeIterator(Collection c, short nodeType) {
        this(c, new NodeTypeFilter(nodeType));
    }

    public NodeIterator(Collection c, String nsURI, String localName) {
        this(c, new ElementFilter(nsURI, localName));
    }

    @Override
    public boolean hasNext() {
        if (this.nextNode != null) {
            return true;
        }
        while (this.iterator.hasNext()) {
            Object obj = this.iterator.next();
            if (obj == null || !(obj instanceof Node)) continue;
            Node node = (Node)obj;
            if (this.filter != null && !this.filter.matches(node)) continue;
            this.nextNode = node;
            return true;
        }
        return false;
    }

    public Object next() {
        if (this.nextNode != null) {
            Node node = this.nextNode;
            this.nextNode = null;
            return node;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static abstract class NodeFilter {
        public abstract boolean matches(Node var1);
    }

    public static class NodeTypeFilter
    extends NodeFilter {
        private short nodeType;

        public NodeTypeFilter(short nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public boolean matches(Node node) {
            boolean match;
            boolean bl = match = this.nodeType == node.getNodeType();
            if (debugFilter && match) {
                System.err.println("\n+++ NodeTypeFilter: match=" + match + ", type=" + XMLUtils.getNodeTypeName(node));
            }
            return match;
        }
    }

    public static class ElementFilter
    extends NodeTypeFilter {
        private String nsURI;
        private String localName;

        public ElementFilter(String nsURI, String localName) {
            super((short)1);
            this.nsURI = nsURI;
            this.localName = localName;
        }

        @Override
        public boolean matches(Node node) {
            boolean match;
            String nsURI = XMLUtils.getNamespaceURI(node);
            String localName = QName.getLocalPart(node.getNodeName());
            boolean bl = match = super.matches(node) && this.equals(this.nsURI, nsURI) && this.equals(this.localName, localName);
            if (debugFilter) {
                System.err.println("+++ ElementFilter: match=" + match + ", nsURI=" + nsURI + ", localName=" + localName);
            }
            return match;
        }

        private boolean equals(String s1, String s2) {
            if (s1 == null) {
                return s2 == null;
            }
            return s1.equals(s2);
        }
    }
}

