/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.security.xmlsec.c14n.Canonicalizer;
import oracle.security.xmlsec.c14n.StreamingC14NImpl;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.NodeToStreamTransform;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.NodeReader;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XPathException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExcC14NTransform
extends XSTransformer
implements NodeToStreamTransform {
    private Canonicalizer c14n;

    public ExcC14NTransform() {
        this.c14n = Canonicalizer.getInstance(false, false);
    }

    ExcC14NTransform(boolean withComments) {
        this.c14n = Canonicalizer.getInstance(false, withComments);
    }

    public ExcC14NTransform(String inclusiveNSList) {
        this.c14n = Canonicalizer.getInstance(false, false);
        this.c14n.setInclusiveNSPrefixList(inclusiveNSList);
    }

    ExcC14NTransform(boolean withComments, String inclusiveNSList) {
        this.c14n = Canonicalizer.getInstance(false, withComments);
        this.c14n.setInclusiveNSPrefixList(inclusiveNSList);
    }

    public ExcC14NTransform(XSAlgorithmIdentifier trans) {
        super(trans);
        if (!"http://www.w3.org/2001/10/xml-exc-c14n#".equals(trans.getAlgorithm())) {
            throw new IllegalArgumentException("Algorithm URI invalid for exclusiveC14N");
        }
        String inclusiveNSList = ExcC14NTransform.processParameter(trans);
        this.c14n = Canonicalizer.getInstance(false, false);
        this.c14n.setInclusiveNSPrefixList(inclusiveNSList);
    }

    static String processParameter(XSAlgorithmIdentifier trans) throws IllegalArgumentException {
        NodeList pList = trans.getParameters();
        if (pList.getLength() == 1) {
            Element param = (Element)pList.item(0);
            if (!"InclusiveNamespaces".equals(param.getLocalName()) && !"InclusiveNamespaces".equals(param.getTagName())) {
                throw new IllegalArgumentException("Illegal Transform parameter");
            }
            if (param.hasAttribute("PrefixList")) {
                return param.getAttribute("PrefixList");
            }
            return null;
        }
        if (pList.getLength() > 0) {
            throw new IllegalArgumentException("Illegal Transform parameter");
        }
        return null;
    }

    @Override
    public String getAlgorithmURI() {
        return "http://www.w3.org/2001/10/xml-exc-c14n#";
    }

    @Override
    public XMLContainer transform(XMLContainer source) throws TransformationException {
        byte[] res = null;
        try {
            res = source.subTreeAvailable() ? ("http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this.getAlgorithmURI()) && !source.getWithComments() ? this.c14n.canonicalize(source.getNodeSet()) : this.c14n.canonicalize(source.getSubTree())) : (source.nodeSetAvailable() ? this.c14n.canonicalize(source.getNodeSet()) : this.c14n.canonicalize(source.getOctetStream(), source.getSystemId()));
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
        catch (SAXException ex) {
            throw new TransformationException(ex);
        }
        catch (XPathException ex) {
            throw new TransformationException(ex);
        }
        if (res == null) {
            res = new byte[]{};
        }
        try {
            return new XMLContainer(new ByteArrayInputStream(res));
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
    }

    @Override
    public InputStream transformToStream(NodeReader source) throws TransformationException {
        StreamingC14NImpl sc14n = (StreamingC14NImpl)this.c14n;
        return sc14n.canonicalizeToStream(source);
    }
}

