/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys.retrieval;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Vector;
import javax.crypto.SecretKey;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.retrieval.CertificateValidator;
import oracle.security.xmlsec.keys.retrieval.CertificateValidatorException;
import oracle.security.xmlsec.keys.retrieval.KeyInfoTool;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.StorageAuthenticator;
import oracle.security.xmlsec.util.XMLUtils;

public abstract class KeyRetriever {
    private static ArrayList retrieverList = new ArrayList();
    private static KeyRetriever keyInfoTool = new KeyInfoTool();
    private static CertificateValidator certValidator = null;
    private StorageAuthenticator authenticator;

    protected KeyRetriever() {
    }

    public void setAuthenticator(StorageAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public StorageAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public static void addKeyRetriever(KeyRetriever retriever) {
        retrieverList.add(retriever);
    }

    public static void removeKeyRetriever(KeyRetriever retriever) {
        retrieverList.remove(retriever);
    }

    public static void setCertificateValidator(CertificateValidator cv) {
        certValidator = cv;
    }

    public static void validateCertificate(X509Certificate cert) throws KeyRetrievalException {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(1);
        certList.add(cert);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CertPath cp = cf.generateCertPath(certList);
            KeyRetriever.validateCertificate(cp);
        }
        catch (CertificateException ex) {
            throw new KeyRetrievalException(ex);
        }
    }

    public static void validateCertificate(Vector certs) throws KeyRetrievalException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CertPath cp = cf.generateCertPath(certs);
            KeyRetriever.validateCertificate(cp);
        }
        catch (CertificateException ex) {
            throw new KeyRetrievalException(ex);
        }
    }

    public static void validateCertificate(CertPath cp) throws KeyRetrievalException {
        if (XMLUtils.getAllowUnvalidatedCertFlag() || XMLUtils.getAllowAllFlag()) {
            return;
        }
        if (certValidator == null) {
            throw new KeyRetrievalException("ERROR: CertificateValidator must be set, or set the JVM variable osdt.allow.unvalidatedCert  to true, or osdt.allow.all to true");
        }
        try {
            certValidator.validateCert(cp);
        }
        catch (CertificateValidatorException ex) {
            throw new KeyRetrievalException(ex);
        }
    }

    public static PublicKey getPublicKey(XSKeyInfo keyInfo) throws KeyRetrievalException {
        PublicKey pubKey = keyInfoTool.retrievePublicKey(keyInfo);
        if (pubKey == null) {
            int n = retrieverList.size();
            for (int i = 0; i < n && pubKey == null; ++i) {
                KeyRetriever r = (KeyRetriever)retrieverList.get(i);
                pubKey = r.retrievePublicKey(keyInfo);
            }
        }
        return pubKey;
    }

    public static X509Certificate getCertificate(XSKeyInfo keyInfo) throws KeyRetrievalException {
        X509Certificate cert = keyInfoTool.retrieveCertificate(keyInfo);
        if (cert == null) {
            int n = retrieverList.size();
            for (int i = 0; i < n && cert == null; ++i) {
                KeyRetriever r = (KeyRetriever)retrieverList.get(i);
                cert = r.retrieveCertificate(keyInfo);
            }
        }
        return cert;
    }

    public static PrivateKey getPrivateKey(XSKeyInfo keyInfo) throws KeyRetrievalException {
        PrivateKey privKey = keyInfoTool.retrievePrivateKey(keyInfo);
        if (privKey == null) {
            int n = retrieverList.size();
            for (int i = 0; i < n && privKey == null; ++i) {
                KeyRetriever r = (KeyRetriever)retrieverList.get(i);
                privKey = r.retrievePrivateKey(keyInfo);
            }
        }
        return privKey;
    }

    public static SecretKey getSymmetricKey(XSKeyInfo keyInfo) throws KeyRetrievalException {
        SecretKey symmKey = keyInfoTool.retrieveSymmetricKey(keyInfo);
        if (symmKey == null) {
            int n = retrieverList.size();
            for (int i = 0; i < n && symmKey == null; ++i) {
                KeyRetriever r = (KeyRetriever)retrieverList.get(i);
                symmKey = r.retrieveSymmetricKey(keyInfo);
            }
        }
        return symmKey;
    }

    public static PublicKey getPublicKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        PublicKey pubKey = keyInfoTool.retrievePublicKey(keyInfo);
        if (pubKey == null) {
            int n = retrieverList.size();
            for (int i = 0; i < n && pubKey == null; ++i) {
                KeyRetriever r = (KeyRetriever)retrieverList.get(i);
                pubKey = r.retrievePublicKey(keyInfo);
            }
        }
        return pubKey;
    }

    public static X509Certificate getCertificate(KeyInfoData keyInfo) throws KeyRetrievalException {
        X509Certificate cert = keyInfoTool.retrieveCertificate(keyInfo);
        if (cert == null) {
            int n = retrieverList.size();
            for (int i = 0; i < n && cert == null; ++i) {
                KeyRetriever r = (KeyRetriever)retrieverList.get(i);
                cert = r.retrieveCertificate(keyInfo);
            }
        }
        return cert;
    }

    public static PrivateKey getPrivateKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        PrivateKey privKey = keyInfoTool.retrievePrivateKey(keyInfo);
        int n = retrieverList.size();
        for (int i = 0; i < n && privKey == null; ++i) {
            KeyRetriever r = (KeyRetriever)retrieverList.get(i);
            privKey = r.retrievePrivateKey(keyInfo);
        }
        return privKey;
    }

    public static SecretKey getSymmetricKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        SecretKey symmKey = keyInfoTool.retrieveSymmetricKey(keyInfo);
        int n = retrieverList.size();
        for (int i = 0; i < n && symmKey == null; ++i) {
            KeyRetriever r = (KeyRetriever)retrieverList.get(i);
            symmKey = r.retrieveSymmetricKey(keyInfo);
        }
        return symmKey;
    }

    protected PublicKey retrievePublicKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        return null;
    }

    protected X509Certificate retrieveCertificate(KeyInfoData keyInfo) throws KeyRetrievalException {
        return null;
    }

    protected PrivateKey retrievePrivateKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        return null;
    }

    protected SecretKey retrieveSymmetricKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        return null;
    }

    protected PublicKey retrievePublicKey(XSKeyInfo keyInfo) throws KeyRetrievalException {
        PublicKey pubKey = null;
        Vector kids = keyInfo.getKeyInfoData();
        int x = kids.size();
        for (int i = 0; i < x && pubKey == null; ++i) {
            pubKey = this.retrievePublicKey((KeyInfoData)kids.elementAt(i));
        }
        return pubKey;
    }

    protected X509Certificate retrieveCertificate(XSKeyInfo keyInfo) throws KeyRetrievalException {
        X509Certificate cert = null;
        Vector kids = keyInfo.getKeyInfoData();
        int x = kids.size();
        for (int i = 0; i < x && cert == null; ++i) {
            cert = this.retrieveCertificate((KeyInfoData)kids.elementAt(i));
        }
        return cert;
    }

    protected PrivateKey retrievePrivateKey(XSKeyInfo keyInfo) throws KeyRetrievalException {
        PrivateKey privKey = null;
        Vector kids = keyInfo.getKeyInfoData();
        int x = kids.size();
        for (int i = 0; i < x && privKey == null; ++i) {
            privKey = this.retrievePrivateKey((KeyInfoData)kids.elementAt(i));
        }
        return privKey;
    }

    protected SecretKey retrieveSymmetricKey(XSKeyInfo keyInfo) throws KeyRetrievalException {
        SecretKey symmKey = null;
        Vector kids = keyInfo.getKeyInfoData();
        int x = kids.size();
        for (int i = 0; i < x && symmKey == null; ++i) {
            symmKey = this.retrieveSymmetricKey((KeyInfoData)kids.elementAt(i));
        }
        return symmKey;
    }
}

