/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.keys.ConcatKDFParams;
import oracle.security.xmlsec.keys.PBKDF2params;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class KeyDerivationParams
extends XMLElement {
    public KeyDerivationParams(Document owner, String nsURI, String localName, String systemId) throws DOMException {
        super(owner, nsURI, localName, systemId);
    }

    public KeyDerivationParams(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    public KeyDerivationParams(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public KeyDerivationParams(Element element) throws DOMException {
        super(element);
    }

    public abstract String getType();

    public abstract byte[] deriveKey(byte[] var1, int var2) throws XECipherException;

    public abstract void setToDefaultParameters();

    public static KeyDerivationParams getInstance(Document doc, String algURI) {
        if (algURI.equals("http://www.w3.org/2009/xmlenc11#ConcatKDF")) {
            return new ConcatKDFParams(doc);
        }
        if (algURI.equals("http://www.w3.org/2009/xmlenc11#pbkdf2")) {
            return new PBKDF2params(doc);
        }
        throw new IllegalArgumentException("Unsupported key derviation algorithm: " + algURI);
    }
}

