/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.security.xmlsec.dsig.ObjectReference;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.enc.XEEncryptedObject;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class XEReference
extends ObjectReference {
    protected XEReference(Element element) throws DOMException {
        super(element);
    }

    protected XEReference(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected XEReference(Document doc, String tagName) throws DOMException {
        this(doc, tagName, null);
    }

    protected XEReference(Document doc, String tagName, String uri) throws DOMException {
        super(doc, "http://www.w3.org/2001/04/xmlenc#", tagName, uri);
    }

    public XEEncryptedObject getEncryptedObject() throws ReferenceException {
        XMLContainer result = (XMLContainer)this.dereference();
        Node encNode = null;
        if (result.subTreeAvailable() || result.octetsAvailable()) {
            try {
                encNode = result.getSubTree();
            }
            catch (IOException ex) {
                throw new ReferenceException(ex);
            }
            catch (SAXException ex) {
                throw new ReferenceException("Dereference expected node-set, got octet stream");
            }
            if (encNode != null && encNode.getNodeType() == 9) {
                encNode = ((Document)encNode).getDocumentElement();
            }
        } else if (result.nodeSetAvailable()) {
            Set nodeSet = null;
            try {
                nodeSet = result.getNodeSet();
            }
            catch (IOException ex) {
                throw new ReferenceException(ex);
            }
            catch (SAXException ex) {
                throw new ReferenceException(ex);
            }
            catch (XPathException ex) {
                throw new ReferenceException(ex);
            }
            if (nodeSet != null) {
                List list = XMLUtils.toDocumentOrderList(nodeSet);
                Iterator it = list.iterator();
                while (encNode == null && it.hasNext()) {
                    Node node = (Node)it.next();
                    if (node.getNodeType() != 1) continue;
                    encNode = node;
                }
            }
        }
        if (encNode != null && ((Element)encNode).getLocalName().equals("EncryptedHeader") && ((Element)encNode).getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) {
            encNode = ((Element)encNode).getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
        }
        if (encNode != null) {
            String uri = this.getURI();
            return XEEncryptedObject.getInstance((Element)encNode, uri.length() == 0 || uri.startsWith("#") ? this.systemId : uri);
        }
        throw new ReferenceException("Bad or missing referenced element");
    }
}

