/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.c14n;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.util.DocOrderComparator;
import oracle.security.xmlsec.util.NodeListImpl;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class C14NImpl {
    private static final boolean xmlDebugC14N = System.getProperty("xml.debug.c14n") != null;
    private static final boolean xmlDebugNS = System.getProperty("xml.debug.ns") != null;
    private static DocumentNavigator docNavigator = XMLUtils.getDocumentNavigator();
    protected StringBuffer output = new StringBuffer();
    private boolean withComments;
    private boolean exclusiveMode;
    private TreeSet incNSPrefs;
    private Set documentSubset;
    private Node subTree;
    private Element documentElement;
    private boolean followsDocElement = false;
    private LinkedList outputElements;
    private HashMap namespacesInNodeSet;
    private HashMap attributesInNodeSet;
    private static DocumentBuilderFactory dbf;
    private static Object dbfLock;
    private static final Boolean FALSE;
    private static final Boolean TRUE;

    protected C14NImpl() {
        this(false, false);
    }

    protected C14NImpl(boolean withComments) {
        this(withComments, false);
    }

    protected C14NImpl(boolean withComments, boolean exclusiveMode) {
        this.withComments = withComments;
        this.exclusiveMode = exclusiveMode;
    }

    protected void setInclusiveNamespacePrefixList(String list) {
        this.exclusiveMode = true;
        StringTokenizer st = new StringTokenizer(list);
        this.incNSPrefs = new TreeSet();
        while (st.hasMoreTokens()) {
            this.incNSPrefs.add(st.nextToken());
        }
    }

    private void reset() {
        this.output.setLength(0);
        this.documentSubset = null;
        this.subTree = null;
        this.documentElement = null;
        this.followsDocElement = false;
        if (this.outputElements != null) {
            this.outputElements.clear();
        }
        if (this.namespacesInNodeSet != null) {
            this.namespacesInNodeSet.clear();
        }
        if (this.attributesInNodeSet != null) {
            this.attributesInNodeSet.clear();
        }
    }

    protected byte[] canonicalize(InputStream source) throws CanonicalizationException {
        if (xmlDebugC14N) {
            System.err.println("\n+++ C14NImpl.canonicalize(InputStream source)");
        }
        return this.canonicalize(source, null);
    }

    protected byte[] canonicalize(InputStream source, String systemId) throws CanonicalizationException {
        if (xmlDebugC14N) {
            System.err.println("\n+++ C14NImpl.canonicalize(InputStream source, String systemId)");
        }
        InputSource is = new InputSource(source);
        is.setSystemId(systemId);
        return this.canonicalize(is);
    }

    protected byte[] canonicalize(InputSource source) throws CanonicalizationException {
        if (xmlDebugC14N) {
            System.err.println("\n+++ C14NImpl.canonicalize(InputSource source)");
        }
        return this.canonicalize(this.parseDocument(source));
    }

    protected byte[] canonicalize(NodeList source) throws CanonicalizationException {
        if (xmlDebugC14N) {
            System.err.println("\n+++ C14NImpl.canonicalize(NodeList source)");
        }
        return this.canonicalize(C14NImpl.cleanCopy(new NodeListImpl(source)));
    }

    protected byte[] canonicalize(Collection source) throws CanonicalizationException {
        if (xmlDebugC14N) {
            System.err.println("\n+++ C14NImpl.canonicalize(List source)");
        }
        this.reset();
        this.processNodeSet(C14NImpl.cleanCopy(source));
        return Utils.toUTF8((String)this.output.toString());
    }

    protected byte[] canonicalize(Node source) throws CanonicalizationException {
        if (xmlDebugC14N) {
            System.err.println("\n+++ C14NImpl.canonicalize(Node source)");
        }
        this.reset();
        if (source.getNodeType() != 9) {
            this.subTree = source;
        }
        this.processNode(source, null, null);
        return Utils.toUTF8((String)this.output.toString());
    }

    protected void processNodeSet(Set nodeset) throws CanonicalizationException {
        if (xmlDebugC14N) {
            System.err.println("\n+++ C14NImpl._canonicalize(NodeSet source)");
        }
        this.documentSubset = nodeset;
        if (this.documentSubset.size() > 0) {
            this.outputElements = new LinkedList();
            this.namespacesInNodeSet = new HashMap();
            this.attributesInNodeSet = new HashMap();
            if (xmlDebugC14N) {
                System.err.println("+++   Input node-set in document order:");
                System.err.println(this.documentSubset.toString());
                System.err.println("+++   Ordered node-set size = " + this.documentSubset.size());
            }
            if (this.documentElement == null) {
                this.documentElement = XMLUtils.getOwnerDocument((Node)this.documentSubset.iterator().next()).getDocumentElement();
            }
            this.processNode(this.documentElement.getOwnerDocument(), null, null);
        }
    }

    protected void processNode(Node node, SortedMap inScopeNamespaces, SortedMap xmlAttributes) throws CanonicalizationException {
        if (xmlDebugC14N) {
            System.err.println("+++ processNode(): " + XMLUtils.toStringNode(node));
        }
        if (this.documentElement == null) {
            this.documentElement = XMLUtils.getOwnerDocument(node).getDocumentElement();
        }
        if (!this.followsDocElement) {
            try {
                this.followsDocElement = DocOrderComparator.compareNodes(node, this.documentElement) == 1;
            }
            catch (XPathException ex) {
                throw new CanonicalizationException(ex);
            }
        }
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                this.processDocument((Document)node);
                break;
            }
            case 7: {
                this.processPI((ProcessingInstruction)node);
                break;
            }
            case 8: {
                if (!this.withComments) break;
                this.processComment((Comment)node);
                break;
            }
            case 3: 
            case 4: {
                this.processText((Text)node);
                break;
            }
            case 2: {
                this.processAttribute((Attr)node);
                break;
            }
            case 13: {
                if (((NamespaceNode)node).getNodeName() == null || this.exclusiveMode && !this.inIncNSPrefs(node.getNodeName()) || C14NImpl.isXMLNamespaceDecl((NamespaceNode)node)) break;
                this.processNamespace((NamespaceNode)node);
                break;
            }
            case 1: {
                this.processElement((Element)node, inScopeNamespaces, xmlAttributes);
                break;
            }
            case 10: 
            case 11: {
                this.processNonXPathNode(node);
                break;
            }
            default: {
                throw new CanonicalizationException("Unsupported node type: " + nodeType);
            }
        }
        if (this.documentSubset != null) {
            this.documentSubset.remove(node);
        }
    }

    protected void processNonXPathNode(Node node) {
        if (xmlDebugC14N) {
            System.err.println("\nprocessNonXPathNode(" + node.getNodeType() + ")");
        }
    }

    protected void processDocument(Document doc) throws CanonicalizationException {
        this.processChildAxis(doc, null, null);
    }

    protected void processPI(ProcessingInstruction pi) {
        if (!"xml".equals(pi.getTarget())) {
            boolean rootLevel;
            boolean bl = rootLevel = pi.getParentNode() == pi.getOwnerDocument();
            if (rootLevel && this.followsDocElement) {
                this.output.append('\n');
            }
            this.output.append("<?");
            this.output.append(pi.getTarget());
            String value = pi.getData();
            if (value != null && value.length() > 0) {
                this.output.append(' ');
                this.output.append(value);
            }
            this.output.append("?>");
            if (rootLevel && !this.followsDocElement) {
                this.output.append('\n');
            }
        }
    }

    protected void processComment(Comment comment) {
        boolean rootLevel;
        boolean bl = rootLevel = comment.getParentNode() == comment.getOwnerDocument();
        if (rootLevel && this.followsDocElement) {
            this.output.append('\n');
        }
        this.output.append("<!--");
        String value = comment.getData();
        if (value != null) {
            this.output.append(value);
        }
        this.output.append("-->");
        if (rootLevel && !this.followsDocElement) {
            this.output.append('\n');
        }
    }

    protected void processText(Text text) {
        String value = text.getData();
        if (value != null) {
            boolean rootLevel = text.getParentNode() == text.getOwnerDocument();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (rootLevel && Character.isWhitespace(c)) continue;
                if (c == '\r') {
                    this.output.append("&#xD;");
                    continue;
                }
                if (c == '&') {
                    this.output.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    this.output.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    this.output.append("&gt;");
                    continue;
                }
                this.output.append(c);
            }
        }
    }

    protected void processAttribute(Attr attr) {
        String name = attr.getName();
        this.output.append(' ');
        this.output.append(name);
        this.output.append("=\"");
        String value = attr.getValue();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '&') {
                this.output.append("&amp;");
                continue;
            }
            if (c == '<') {
                this.output.append("&lt;");
                continue;
            }
            if (c == '\"') {
                this.output.append("&quot;");
                continue;
            }
            if (c == '\t') {
                this.output.append("&#x9;");
                continue;
            }
            if (c == '\n') {
                this.output.append("&#xA;");
                continue;
            }
            if (c == '\r') {
                this.output.append("&#xD;");
                continue;
            }
            this.output.append(c);
        }
        this.output.append('\"');
    }

    protected void processNamespace(NamespaceNode ns) throws CanonicalizationException {
        String prefix = ns.getNodeName();
        String value = ns.getNodeValue();
        if (C14NImpl.isRelativeNS(value)) {
            throw new CanonicalizationException("Node-set contains relative namespace URI " + prefix + "=" + value);
        }
        this.output.append(' ');
        String name = "xmlns" + (prefix.length() > 0 ? ":" + prefix : prefix);
        this.output.append(name);
        this.output.append("=\"");
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '&') {
                this.output.append("&amp;");
                continue;
            }
            if (c == '<') {
                this.output.append("&lt;");
                continue;
            }
            if (c == '\"') {
                this.output.append("&quot;");
                continue;
            }
            if (c == '\t') {
                this.output.append("&#x9;");
                continue;
            }
            if (c == '\n') {
                this.output.append("&#xA;");
                continue;
            }
            if (c == '\r') {
                this.output.append("&#xD;");
                continue;
            }
            this.output.append(c);
        }
        this.output.append('\"');
    }

    protected void processElement(Element element, SortedMap inScopeNamespaces, SortedMap xmlAttributes) throws CanonicalizationException {
        NamespaceNode ns;
        Iterator nsAxis;
        boolean elementInNodeSet = this.documentSubset == null || this.documentSubset.contains(element);
        ArrayList<Object> processedNodes = this.documentSubset != null ? new ArrayList<Object>() : null;
        inScopeNamespaces = inScopeNamespaces != null ? new TreeMap<NamespaceNode, NamespaceNode>((SortedMap<NamespaceNode, NamespaceNode>)inScopeNamespaces) : new TreeMap(new NSComparator());
        TreeMap<NamespaceNode, NamespaceNode> outOfScopeNamespaces = new TreeMap<NamespaceNode, NamespaceNode>(new NSComparator());
        if (xmlDebugNS) {
            System.err.println("\nElement: " + XMLUtils.toStringNode(element));
            System.err.println("inScopeNamespaces:\n" + XMLUtils.toStringNodes(inScopeNamespaces.keySet()).replace(',', '\n'));
        }
        String qname = element.getTagName();
        if (elementInNodeSet) {
            this.output.append('<');
            this.output.append(qname);
        }
        TreeSet<NamespaceNode> nsSet = new TreeSet<NamespaceNode>(new NSPrefixComparator());
        if (this.documentSubset != null) {
            nsAxis = docNavigator.getNamespaceAxisIterator((Object)element);
            while (nsAxis.hasNext()) {
                ns = (NamespaceNode)nsAxis.next();
                if (ns.getNodeName() == null) continue;
                if (this.documentSubset.contains(ns)) {
                    nsSet.add(ns);
                    processedNodes.add(ns);
                    continue;
                }
                if (!elementInNodeSet) continue;
                outOfScopeNamespaces.put(ns, ns);
            }
        } else {
            nsAxis = docNavigator.getNamespaceAxisIterator((Object)element);
            while (nsAxis.hasNext()) {
                ns = (NamespaceNode)nsAxis.next();
                if (ns.getNodeName() == null) continue;
                nsSet.add(ns);
            }
        }
        if (xmlDebugNS) {
            System.err.println("outOfScopeNamespaces:\n" + XMLUtils.toStringNodes(outOfScopeNamespaces.keySet()).replace(',', '\n'));
            System.err.println("nsSet:\n" + XMLUtils.toStringNodes(nsSet).replace(',', '\n'));
        }
        if (xmlAttributes != null) {
            xmlAttributes = new TreeMap(xmlAttributes);
        } else if (!(this.documentSubset == null && this.subTree == null || this.exclusiveMode)) {
            xmlAttributes = C14NImpl.getAncestorXMLAttrs(element);
        }
        TreeSet<Attr> attrSet = new TreeSet<Attr>(new AttrComparator());
        Iterator attrAxis = docNavigator.getAttributeAxisIterator((Object)element);
        while (attrAxis.hasNext()) {
            Attr attr = (Attr)attrAxis.next();
            String attrName = attr.getName();
            if (attrName.startsWith("xmlns")) continue;
            if (this.documentSubset != null) {
                if (this.documentSubset.contains(attr)) {
                    attrSet.add(attr);
                    processedNodes.add(attr);
                }
            } else {
                attrSet.add(attr);
            }
            if (this.documentSubset == null && this.subTree == null || this.exclusiveMode || !"xml".equals(QName.getPrefixPart(attrName))) continue;
            xmlAttributes.put(attrName, attr);
        }
        if (elementInNodeSet && !this.exclusiveMode) {
            if (this.documentSubset != null) {
                Node parent = element.getParentNode();
                if (parent != null && !this.documentSubset.contains(parent)) {
                    attrSet.addAll(xmlAttributes.values());
                }
            } else if (this.subTree != null && element == this.subTree) {
                attrSet.addAll(xmlAttributes.values());
            }
        }
        TreeSet<NamespaceNode> nsToRender = new TreeSet<NamespaceNode>(new NSPrefixComparator());
        NamespaceNode defaultNS = null;
        for (NamespaceNode ns2 : nsSet) {
            String prefix = ns2.getNodeName();
            if (C14NImpl.isXMLNamespaceDecl(ns2) || "".equals(prefix) && "".equals(ns2.getNodeValue())) continue;
            if ("".equals(prefix)) {
                defaultNS = ns2;
            }
            boolean render = false;
            if (!this.exclusiveMode) {
                if (!inScopeNamespaces.containsKey(ns2)) {
                    render = true;
                }
            } else if (this.inIncNSPrefs(prefix)) {
                if (!inScopeNamespaces.containsKey(ns2)) {
                    render = true;
                }
            } else if (elementInNodeSet && C14NImpl.visiblyUtilizes(element, attrSet, prefix) && (!C14NImpl.prefixRenderedByAncestor(ns2, inScopeNamespaces) || !this.inSubsetForOutputAncestor(element, ns2))) {
                render = true;
            }
            if (!render) continue;
            nsToRender.add(ns2);
            if (!elementInNodeSet) continue;
            inScopeNamespaces.put(ns2, ns2);
        }
        if (xmlDebugNS) {
            System.err.println("defaultNS: " + XMLUtils.toStringNode(defaultNS));
        }
        boolean outputEmptyDefaultNS = false;
        if (defaultNS == null && elementInNodeSet && (!this.exclusiveMode || this.inIncNSPrefs("") || "".equals(QName.getPrefixPart(element.getNodeName())))) {
            for (NamespaceNode ns3 : inScopeNamespaces.keySet()) {
                if (!"".equals(ns3.getNodeName())) continue;
                outputEmptyDefaultNS = true;
                inScopeNamespaces.remove(ns3);
                break;
            }
        }
        if (xmlDebugNS) {
            System.err.println("nsToRender:\n" + XMLUtils.toStringNodes(nsToRender).replace(',', '\n'));
            System.err.println("outputEmptyDefaultNS: " + outputEmptyDefaultNS);
        }
        if (outputEmptyDefaultNS) {
            this.processNamespace(new NamespaceNode((Node)element, "", ""));
        }
        Iterator nsIter = nsToRender.iterator();
        while (nsIter.hasNext()) {
            this.processNamespace((NamespaceNode)nsIter.next());
        }
        Iterator attrIter = attrSet.iterator();
        while (attrIter.hasNext()) {
            this.processAttribute((Attr)attrIter.next());
        }
        if (elementInNodeSet) {
            this.output.append('>');
        }
        if (element.hasChildNodes()) {
            if (this.documentSubset != null && elementInNodeSet) {
                this.outputElements.addFirst(element);
                this.namespacesInNodeSet.put(element, nsSet);
                this.attributesInNodeSet.put(element, attrSet);
            }
            if (!this.exclusiveMode) {
                inScopeNamespaces.keySet().removeAll(outOfScopeNamespaces.keySet());
            }
            this.processChildAxis(element, inScopeNamespaces, xmlAttributes);
            if (this.documentSubset != null && elementInNodeSet) {
                this.outputElements.removeFirst();
                this.namespacesInNodeSet.remove(element);
                this.attributesInNodeSet.remove(element);
            }
        }
        if (elementInNodeSet) {
            this.output.append("</");
            this.output.append(qname);
            this.output.append('>');
        }
        if (this.documentSubset != null) {
            this.documentSubset.removeAll(processedNodes);
            if (elementInNodeSet) {
                this.documentSubset.remove(element);
            }
        }
    }

    protected void processChildAxis(Node node, SortedMap inScopeNamespaces, SortedMap xmlAttributes) throws CanonicalizationException {
        Iterator childAxis = docNavigator.getChildAxisIterator((Object)node);
        if (this.documentSubset == null) {
            while (childAxis.hasNext()) {
                this.processNode((Node)childAxis.next(), inScopeNamespaces, xmlAttributes);
            }
        } else {
            while (childAxis.hasNext()) {
                Node child = (Node)childAxis.next();
                if (child.getNodeType() != 1 && !this.documentSubset.contains(child)) continue;
                this.processNode(child, inScopeNamespaces, xmlAttributes);
            }
        }
    }

    protected static boolean isEmptyDefaultNS(NamespaceNode nsNode) {
        return "".equals(nsNode.getNodeName()) && "".equals(nsNode.getNodeValue());
    }

    protected static boolean isXMLNamespaceDecl(NamespaceNode nsNode) {
        return "xml".equals(nsNode.getNodeName()) && "http://www.w3.org/XML/1998/namespace".equals(nsNode.getNodeValue());
    }

    private boolean inIncNSPrefs(String prefix) {
        if (this.incNSPrefs != null) {
            if (prefix == null || prefix.equals("")) {
                prefix = "#default";
            }
            return this.incNSPrefs.contains(prefix);
        }
        return false;
    }

    public static boolean isRelativeNS(String nsURI) {
        if (nsURI.length() == 0) {
            return false;
        }
        int len = nsURI.length();
        for (int i = 0; i < len; ++i) {
            char c = nsURI.charAt(i);
            if (c == ':') {
                return false;
            }
            if (c != '/') continue;
            return true;
        }
        return true;
    }

    private static boolean prefixRenderedByAncestor(NamespaceNode ns, SortedMap inScopeNamespaces) {
        String prefix = ns.getNodeName();
        Iterator it = inScopeNamespaces.keySet().iterator();
        while (it.hasNext()) {
            if (!prefix.equals(((NamespaceNode)it.next()).getNodeName())) continue;
            return true;
        }
        return false;
    }

    private static boolean visiblyUtilizes(Element element, TreeSet attrSet, String prefix) {
        String ePref;
        if (prefix == null) {
            prefix = "";
        }
        if ((ePref = QName.getPrefixPart(element.getNodeName())) == null) {
            ePref = "";
        }
        if (prefix.equals(ePref)) {
            return true;
        }
        if (!prefix.equals("")) {
            for (Attr attr : attrSet) {
                String aPref = QName.getPrefixPart(attr.getName());
                if (aPref == null) {
                    aPref = "";
                }
                if (!prefix.equals(aPref)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean visiblyUtilizes(Element element, String prefix) {
        String ePref;
        if (prefix == null) {
            prefix = "";
        }
        if ((ePref = QName.getPrefixPart(element.getNodeName())) == null) {
            ePref = "";
        }
        if (prefix.equals(ePref)) {
            return true;
        }
        if (!prefix.equals("")) {
            Iterator attrAxis = docNavigator.getAttributeAxisIterator((Object)element);
            while (attrAxis.hasNext()) {
                Attr attr = (Attr)attrAxis.next();
                String aPref = QName.getPrefixPart(attr.getName());
                if (aPref == null) {
                    aPref = "";
                }
                if (!prefix.equals(aPref)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean inSubsetForOutputAncestor(Element element, NamespaceNode ns) {
        block4: {
            String uri;
            String prefix;
            block5: {
                prefix = ns.getNodeName();
                uri = ns.getNodeValue();
                if (this.documentSubset == null) break block5;
                for (Element outputAncestor : this.outputElements) {
                    TreeSet attrSet;
                    if (!C14NImpl.visiblyUtilizes(outputAncestor, attrSet = (TreeSet)this.attributesInNodeSet.get(outputAncestor), prefix)) continue;
                    TreeSet nsSet = (TreeSet)this.namespacesInNodeSet.get(outputAncestor);
                    for (NamespaceNode nsInSubset : nsSet) {
                        if (!prefix.equals(nsInSubset.getNodeName()) || !uri.equals(nsInSubset.getNodeValue())) continue;
                        return true;
                    }
                    break block4;
                }
                break block4;
            }
            if (this.subTree != null && element == this.subTree) break block4;
            for (Node ancestor = element.getParentNode(); ancestor != null; ancestor = ancestor.getParentNode()) {
                if (ancestor.getNodeType() != 1 || !C14NImpl.visiblyUtilizes((Element)ancestor, prefix)) continue;
                Iterator nsAxis = docNavigator.getNamespaceAxisIterator((Object)ancestor);
                while (nsAxis.hasNext()) {
                    NamespaceNode nsNode = (NamespaceNode)nsAxis.next();
                    if (!prefix.equals(nsNode.getNodeName()) || !uri.equals(nsNode.getNodeValue())) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    protected static SortedMap getAncestorXMLAttrs(Element element) {
        TreeMap<String, Attr> xmlAttributes = new TreeMap<String, Attr>();
        for (Node ancestor = element.getParentNode(); ancestor != null; ancestor = ancestor.getParentNode()) {
            Iterator ancestorAttrAxis = docNavigator.getAttributeAxisIterator((Object)ancestor);
            while (ancestorAttrAxis.hasNext()) {
                Attr attr = (Attr)ancestorAttrAxis.next();
                String attrName = attr.getName();
                if (!"xml".equals(QName.getPrefixPart(attrName))) continue;
                xmlAttributes.put(attrName, attr);
            }
        }
        return xmlAttributes;
    }

    private static Set cleanCopy(Collection nodeSet) {
        HashSet<Node> copy = new HashSet<Node>(nodeSet.size());
        for (Node node : nodeSet) {
            Attr attr;
            String attrName;
            if (node.getNodeType() == 2 && (attrName = (attr = (Attr)node).getName()).startsWith("xmlns")) {
                String nsPrefix = attrName.equals("xmlns") ? "" : QName.getLocalPart(attrName);
                String nsURI = attr.getValue();
                if (nsPrefix.equals("xml") && nsURI.equals("http://www.w3.org/XML/1998/namespace") || nsPrefix.equals("") && nsURI.equals("")) continue;
                node = new NamespaceNode((Node)attr.getOwnerElement(), nsPrefix, nsURI);
            }
            copy.add(node);
        }
        return copy;
    }

    private Document parseDocument(InputSource source) throws CanonicalizationException {
        try {
            return C14NImpl.createDocBuilder().parse(source);
        }
        catch (SAXNotRecognizedException ex) {
            throw new CanonicalizationException(ex);
        }
        catch (SAXNotSupportedException ex) {
            throw new CanonicalizationException(ex);
        }
        catch (SAXException ex) {
            throw new CanonicalizationException(ex);
        }
        catch (IOException ex) {
            throw new CanonicalizationException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new CanonicalizationException(ex);
        }
    }

    private static DocumentBuilder createDocBuilder() throws CanonicalizationException {
        Object object = dbfLock;
        synchronized (object) {
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setValidating(false);
                dbf.setNamespaceAware(true);
                dbf.setExpandEntityReferences(true);
                dbf.setCoalescing(true);
            }
            try {
                return dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new CanonicalizationException(ex);
            }
        }
    }

    static {
        dbfLock = new Object();
        FALSE = new Boolean(false);
        TRUE = new Boolean(true);
    }

    protected static class NSComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            NamespaceNode ns1 = (NamespaceNode)o1;
            NamespaceNode ns2 = (NamespaceNode)o2;
            int result = ns1.getNodeName().compareTo(ns2.getNodeName());
            if (result == 0) {
                result = ns1.getNodeValue().compareTo(ns2.getNodeValue());
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof NSComparator;
        }
    }

    protected static class NSPrefixComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            NamespaceNode ns1 = (NamespaceNode)o1;
            NamespaceNode ns2 = (NamespaceNode)o2;
            return ns1.getNodeName().compareTo(ns2.getNodeName());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof NSPrefixComparator;
        }
    }

    protected static class AttrComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int result;
            String ns2;
            Attr a1 = (Attr)o1;
            Attr a2 = (Attr)o2;
            String ns1 = XMLUtils.getNamespaceURI(a1);
            if (ns1 == null) {
                ns1 = "";
            }
            if ((ns2 = XMLUtils.getNamespaceURI(a2)) == null) {
                ns2 = "";
            }
            if ((result = ns1.compareTo(ns2)) == 0) {
                String loc1 = QName.getLocalPart(a1.getName());
                String loc2 = QName.getLocalPart(a2.getName());
                result = loc1.compareTo(loc2);
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof AttrComparator;
        }
    }
}

