/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.graphql;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parseable;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;

public class GQLParser
extends Earley
implements Parseable {
    static GQLParser instance = null;
    public String[] keywords = new String[]{"query", "mutation", "subscription", "fragment", "on", "schema", "type", "scalar", "interface", "implements", "enum", "union", "extend", "input", "directive", "repeatable"};
    int identifier;
    int digits;
    int document;
    int stringLiteral;
    private Set<Integer> _keywords = new TreeSet<Integer>();

    public GQLParser() throws IOException {
        super(GQLParser.getRules(), false);
        this.initKeywords();
        this.identifier = (Integer)this.symbolIndexes.get("identifier");
        this.digits = (Integer)this.symbolIndexes.get("digits");
        this.document = (Integer)this.symbolIndexes.get("document");
        this.stringLiteral = (Integer)this.symbolIndexes.get("stringLiteral");
    }

    public static GQLParser getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        instance = new GQLParser();
        GQLParser.instance.isCaseSensitive = true;
        return instance;
    }

    @Override
    protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
        if (suspect != null && this._keywords.contains(suspect)) {
            return false;
        }
        LexerToken token = src.get(y);
        return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING || symbol == this.digits && token.type == Token.DIGITS;
    }

    @Override
    protected boolean isOptimizable(int headSym, int preSym, int mid, int y) {
        if ("LabeledStatement".equals(this.allSymbols[headSym])) {
            return false;
        }
        return super.isOptimizable(headSym, preSym, mid, y);
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> src, Matrix m, Parser.EarleyCell cell, int x, int y) {
        int rule = -1;
        int pos = -1;
        for (int i = 0; i < cell.size(); ++i) {
            rule = cell.getRule(i);
            Parser.Tuple t = this.rules[rule];
            if (t.head != this.document || this.rules[rule].rhs.length != (pos = cell.getPosition(i))) continue;
            return this.tree(src, m, x, y, rule, pos);
        }
        return super.treeForACell(src, m, cell, x, y);
    }

    @Override
    protected void diagnose(Matrix m, int x, int y) {
    }

    void initKeywords() {
        for (String k : this.keywords) {
            this._keywords.add(this.getSymbol(k));
        }
    }

    public static Set<RuleTuple> getRules() throws IOException {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        String rulesTxt = Service.readFile(GQLParser.class, "gql.grammar");
        rulesTxt = rulesTxt.replace("'{'", "OPEN_CURLY");
        rulesTxt = rulesTxt.replace("'}'", "CLOSE_CURLY");
        rulesTxt = rulesTxt.replace("private ", "");
        rulesTxt = rulesTxt.replace("!(')'", "!('closed_paren");
        rulesTxt = Grammar.removeNestedBlock(rulesTxt, "/*", "*/");
        rulesTxt = Grammar.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = Grammar.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = Grammar.removeNestedBlock(rulesTxt, "!(", ")");
        rulesTxt = rulesTxt.replace("OPEN_CURLY", "'{'");
        rulesTxt = rulesTxt.replace("CLOSE_CURLY", "'}'");
        rulesTxt = rulesTxt.replace("'...'", "'.' '.' '.'");
        rulesTxt = rulesTxt.replace("'::='", "':' ':' '='");
        List<LexerToken> src = Lexer.parse(rulesTxt, false, 41);
        ParseNode root = Grammar.parseGrammarFile(src, rulesTxt);
        Grammar.grammar(root, src, rules);
        rules.add(new RuleTuple("selection", new String[]{"selection", "','"}));
        rules.add(new RuleTuple("selectionSet", new String[]{"'['", "selectionSet", "']'"}));
        GQLParser.insertDotIdentifier(rules, "gqlField");
        RuleTransforms.eliminateEmptyProductions(rules);
        return rules;
    }

    private static void insertDotIdentifier(Set<RuleTuple> rules, String head) {
        TreeSet<RuleTuple> addendum = new TreeSet<RuleTuple>();
        for (RuleTuple rule : rules) {
            int i;
            if (!head.equals(rule.head)) continue;
            int extra = 2;
            RuleTuple modified = new RuleTuple(rule.head, new String[rule.rhs.length + extra]);
            int pos = -1;
            for (i = 0; i < rule.rhs.length; ++i) {
                if (!"identifier".equals(rule.rhs[i])) continue;
                pos = i + 1;
                break;
            }
            for (i = 0; i < pos; ++i) {
                modified.rhs[i] = rule.rhs[i];
            }
            int incr = 0;
            modified.rhs[pos + incr++] = "'.'";
            modified.rhs[pos + incr++] = "identifier";
            for (int i2 = pos; i2 < rule.rhs.length; ++i2) {
                modified.rhs[i2 + extra] = rule.rhs[i2];
            }
            addendum.add(modified);
        }
        rules.addAll(addendum);
    }

    public static void main(String[] args) throws Exception {
        String input = Service.readFile("dbtools-libraries/dbtools-arbori/src/localtest/resources/oracle/dbtools/parser/graphql/example.gql");
        GQLParser earley = GQLParser.getInstance();
        boolean T = true;
        boolean F = false;
        earley.printOrderedRules("document", T, F);
        List<LexerToken> src = LexerToken.parse(input, "&`", 937);
        if (src.size() < 1200) {
            LexerToken.print(src);
        }
        Matrix matrix = new Matrix(earley);
        Visual visual = null;
        if (src.size() < 1200) {
            visual = new Visual(src, earley);
        }
        earley.parse(src, matrix);
        if (src.size() < 500) {
            visual.draw(matrix);
        }
        ParseNode out = earley.forest(src, matrix);
        SyntaxError err = SyntaxError.checkSyntax(input, new String[]{"document"}, src, earley, matrix);
        if (err != null) {
            System.out.println(err.getDetailedMessage());
            return;
        }
        out.printTree(5);
    }
}

