/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.List;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.ParsingCancelled;
import oracle.dbtools.parser.Substitutions;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.Yelrae;
import oracle.dbtools.parser.plsql.SyntaxError;

public class Parsed {
    public String input;
    protected List<LexerToken> src;
    protected ParseNode root;
    protected Earley earley;
    private String[] rootPayload = null;
    private SyntaxError err = null;
    public Substitutions replacements = null;
    public boolean debug = false;
    protected Lexer lexer = null;
    protected Matrix matrix = null;

    public Parsed(String input, Earley parser, String legitimateSymbol) {
        this.input = input;
        this.earley = parser;
        if (legitimateSymbol != null) {
            this.rootPayload = new String[]{legitimateSymbol};
        }
    }

    public Parsed(String input, List<LexerToken> src, Earley parser, String legitimateSymbol) {
        this.input = input;
        this.earley = parser;
        this.src = src;
        if (legitimateSymbol != null) {
            this.rootPayload = new String[]{legitimateSymbol};
        }
    }

    public Parsed(String input, List<LexerToken> src, Earley parser, String[] rootPayload) {
        this.input = input;
        this.earley = parser;
        this.src = src;
        this.rootPayload = rootPayload;
    }

    public Parsed(String input, List<LexerToken> src, ParseNode root) {
        this.input = input;
        this.src = src;
        this.root = root;
    }

    public String getInput() {
        return this.input;
    }

    public Earley getEarley() {
        return this.earley;
    }

    public synchronized List<LexerToken> getSrc() {
        if (this.src == null) {
            this.lexer = new Lexer();
            for (String payload : this.rootPayload) {
                if ("javascript".equals(payload)) {
                    this.src = this.lexer.doParse(this.input, "&", 553);
                    this.lexer = null;
                    return this.src;
                }
                if (!"program".equals(payload)) continue;
                this.src = this.lexer.doParse(this.input, "&", 57);
                this.lexer = null;
                return this.src;
            }
            this.src = this.lexer.doParse(this.input);
            this.lexer = null;
        }
        return this.src;
    }

    public Matrix getMatrix() {
        this.getRoot();
        return this.matrix;
    }

    public synchronized ParseNode getRoot() {
        this.getSrc();
        if (this.root == null) {
            if (this.src.size() == 0) {
                return new ParseNode(0, 0, -1, this.earley);
            }
            this.matrix = new Matrix(this.earley);
            if (this.debug) {
                boolean isCmdline = false;
                for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
                    if (!elem.toString().startsWith("oracle.dbtools.cmdline")) continue;
                    isCmdline = true;
                    break;
                }
                if (!isCmdline) {
                    this.matrix.visual = new Visual(this.src, this.earley);
                    this.matrix.visual.matrix = this.matrix;
                }
            }
            try {
                this.earley.doParse(this.src, this.matrix);
            }
            catch (ParsingCancelled e1) {
                throw new AssertionError((Object)"getRoot(): parse cancelled");
            }
            if (this.debug && this.matrix.visual != null) {
                this.matrix.visual.draw();
            }
            if (this.rootPayload != null && this.rootPayload.length == 1 && "parse with errors".equals(this.rootPayload[0])) {
                Earley e = this.earley;
                this.root = Yelrae.duplexParse(e, this.src, this.matrix);
            } else {
                this.root = this.earley.forest(this.src, this.matrix, true, this.input);
            }
            if (!(this.rootPayload == null || "parse with errors".equals(this.rootPayload[0]) || this.root.topLevel == null && this.matrix.get(0, this.src.size()) != null)) {
                this.err = SyntaxError.checkSyntax(this.input, this.rootPayload, this.src, this.earley, this.matrix);
            }
        }
        return this.root;
    }

    public SyntaxError getSyntaxError() {
        if (this.err != null) {
            return this.err;
        }
        this.getRoot();
        return this.err;
    }

    public void stop() {
        if (this.lexer != null) {
            this.lexer.stop();
        }
        if (this.earley != null) {
            this.earley.stop();
        }
    }

    public String content(ParseNode node) {
        return this.content(node, node);
    }

    public String content(ParseNode from, ParseNode to) {
        return this.getInput().substring(this.getSrc().get((int)from.from).begin, this.getSrc().get((int)(to.to - 1)).end);
    }
}

