/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.ParsingCancelled;
import oracle.dbtools.parser.Token;

public class LexerToken {
    public String content;
    public int begin;
    public int end;
    public Token type;
    public static boolean isSqlPlusCmd = false;
    public static String[] customLineCommentPrefixes = new String[0];
    @Deprecated
    public static final int QuotedStrings = 1;
    @Deprecated
    public static final int SqlPlusComments = 2;
    @Deprecated
    public static final int PlSqlMacros = 4;
    @Deprecated
    public static final int JavaLineComments = 8;
    @Deprecated
    public static final int SqlLineComments = 16;
    @Deprecated
    public static final int JavaSqlMultilineComments = 32;
    @Deprecated
    public static final int HtmlComments = 64;
    @Deprecated
    public static final int JsonStrings = 128;
    @Deprecated
    public static final int PoundComments = 256;
    @Deprecated
    public static final int RegExp = 512;
    @Deprecated
    public static final int SQL = 63;
    @Deprecated
    public static final int GRAMMAR = 49;
    @Deprecated
    public static final int ARBORI = 57;
    @Deprecated
    public static final int TEST = 49;
    @Deprecated
    public static final int JAVA = 41;
    @Deprecated
    public static final int JS = 937;

    public LexerToken(CharSequence text, int from, int to, Token t) {
        this.content = text.toString();
        this.begin = from;
        this.end = to;
        this.type = t;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return "[" + this.begin + "," + this.end + ") " + this.content + "   <" + this.type + ">";
    }

    public static void print(List<LexerToken> src) {
        int j = 0;
        for (LexerToken t : src) {
            System.out.print(j + "    ");
            t.print();
            ++j;
        }
    }

    public static void print(List<LexerToken> src, int from, int to) {
        LexerToken.print(src, from, to, false);
    }

    public static void print(List<LexerToken> src, int from, int to, boolean toErr) {
        for (int i = from; i < to; ++i) {
            if (toErr) {
                System.err.print(" " + src.get((int)i).content);
                continue;
            }
            System.out.print(" " + src.get((int)i).content);
        }
        if (toErr) {
            System.err.println();
        } else {
            System.out.println();
        }
    }

    static ArrayList<String> split(String input, String delimiters, boolean includeDelimiters) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder currentToken = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (0 <= delimiters.indexOf(c)) {
                if (0 < currentToken.length()) {
                    ret.add(currentToken.toString());
                }
                if (includeDelimiters) {
                    ret.add(Character.toString(c));
                }
                currentToken = new StringBuilder();
                continue;
            }
            currentToken.append(c);
        }
        if (0 < currentToken.length()) {
            ret.add(currentToken.toString());
        }
        return ret;
    }

    @Deprecated
    public static List<LexerToken> parse(String input) {
        return new Lexer().doParse(input, false);
    }

    @Deprecated
    public static List<LexerToken> parse(String input, String extraOper) {
        return new Lexer().doParse(input, extraOper);
    }

    @Deprecated
    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS) {
        return new Lexer().doParse(input, keepWSandCOMMENTS, 63);
    }

    @Deprecated
    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS, int flags) {
        return new Lexer().doParse(input, keepWSandCOMMENTS, flags);
    }

    @Deprecated
    public static List<LexerToken> parse(String input, String extraOper, int flags) {
        try {
            ArrayList<LexerToken> ret = new ArrayList<LexerToken>();
            new Lexer().doParse(input, false, flags, extraOper, ret);
            return ret;
        }
        catch (ParsingCancelled e) {
            throw new AssertionError((Object)"parse(...) has been interrupted with lexer.stop=true");
        }
    }

    @Deprecated
    private void parse(String input, boolean keepWSandCOMMENTS, int flags, String extraOper, ArrayList<LexerToken> ret) throws ParsingCancelled {
        new Lexer().doParse(input, keepWSandCOMMENTS, flags, extraOper, ret);
    }

    public static boolean incomplete(ArrayList<LexerToken> src) {
        if (src.size() == 0) {
            return false;
        }
        LexerToken t = src.get(src.size() - 1);
        return t.incomplete();
    }

    public boolean incomplete() {
        return this.type == Token.QUOTED_STRING && !this.content.endsWith("'") || this.type == Token.DQUOTED_STRING && !this.content.endsWith("\"") || this.type == Token.COMMENT && !this.content.endsWith("*/");
    }

    public boolean posInsideLiteral(int charOffset) {
        if (this.type == Token.QUOTED_STRING || this.type == Token.DQUOTED_STRING || this.type == Token.COMMENT) {
            return this.begin + 1 <= charOffset && charOffset <= this.end - 1;
        }
        return false;
    }

    public static int scanner2parserOffset(List<LexerToken> src, int start) {
        int offset = -1;
        for (LexerToken t : src) {
            ++offset;
            if (t.end <= start) continue;
            break;
        }
        return offset;
    }

    public static LexerToken getTokenAtCharOffset(List<LexerToken> src, int offset) throws Exception {
        for (LexerToken t : src) {
            if (t.begin <= offset && offset <= t.end) {
                return t;
            }
            if (offset > t.begin) continue;
            return t;
        }
        throw new Exception("VT: offset = " + offset);
    }

    public static int char2lex(List<LexerToken> src, int offset) {
        return LexerToken.char2lex(src, offset, false);
    }

    public static int char2lex(List<LexerToken> src, int offset, boolean strict) {
        if (src.size() == 0) {
            return 0;
        }
        int pos = -1;
        for (LexerToken t : src) {
            ++pos;
            if (t.begin <= offset && offset < t.end || !strict && t.begin <= offset && offset == t.end) {
                return pos;
            }
            if (offset > t.begin) continue;
            return pos;
        }
        return pos + 1;
    }

    private static char matchingDelimiter(char ch) {
        if ('<' == ch) {
            return '>';
        }
        if ('[' == ch) {
            return ']';
        }
        if ('{' == ch) {
            return '}';
        }
        if ('(' == ch) {
            return ')';
        }
        return ch;
    }

    boolean isStandardLiteral() {
        return this.isStandardLiteral(63);
    }

    boolean isStandardLiteral(int flags) {
        if (this.content.length() < 2) {
            return false;
        }
        if (this.content.charAt(0) != '\'' && this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N' && this.content.charAt(0) != 'u' && this.content.charAt(0) != 'U') {
            return false;
        }
        String text = this.content;
        if (text.charAt(0) == 'n' || text.charAt(0) == 'N' || text.charAt(0) == 'u' || text.charAt(0) == 'U') {
            if (text.length() < 3) {
                return false;
            }
            text = text.substring(1);
        }
        if (text.length() < 2) {
            return false;
        }
        return text.charAt(0) == '\'' && text.charAt(text.length() - 1) == '\'' && (flags != 937 || text.charAt(text.length() - 2) != '\\' || text.length() < 3 || text.charAt(text.length() - 3) == '\\');
    }

    boolean isAltLiteral() {
        if (this.content.length() < 5) {
            return false;
        }
        if (this.content.charAt(0) != 'q' && this.content.charAt(0) != 'Q' && this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N' && this.content.charAt(0) != 'u' && this.content.charAt(0) != 'U') {
            return false;
        }
        String text = this.content;
        if (!(this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N' && this.content.charAt(0) != 'u' && this.content.charAt(0) != 'U' || this.content.charAt(1) != 'q' && this.content.charAt(1) != 'Q')) {
            if (text.length() < 6) {
                return false;
            }
            text = text.substring(2);
        } else if (this.content.charAt(0) == 'q' || this.content.charAt(0) == 'Q' || this.content.charAt(0) == 'u' || this.content.charAt(0) == 'U') {
            text = text.substring(1);
        } else {
            return false;
        }
        if (text.charAt(0) != '\'' || text.charAt(text.length() - 1) != '\'') {
            return false;
        }
        text = text.substring(1, text.length() - 1);
        return LexerToken.matchingDelimiter(text.charAt(0)) == text.charAt(text.length() - 1);
    }

    public static void moveInterval(List<LexerToken> src, int offset) {
        for (LexerToken t : src) {
            t.begin += offset;
            t.end += offset;
        }
    }

    public static List<File> listFilesForFolder(File folder) {
        LinkedList<File> ret = new LinkedList<File>();
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) {
                ret.addAll(LexerToken.listFilesForFolder(fileEntry));
                continue;
            }
            ret.add(fileEntry);
        }
        return ret;
    }

    public static boolean equals(String cmp1, String cmp2) {
        List<LexerToken> src1 = Lexer.parse(cmp1);
        List<LexerToken> src2 = Lexer.parse(cmp2);
        if (src1.size() != src2.size()) {
            return false;
        }
        for (int j = 0; j < src1.size(); ++j) {
            if (src1.get((int)j).content.equals(src2.get((int)j).content)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String input = Service.readFile("/Users/VTROPASH/eclipse-workspace/sandbox/src/example.sql");
        long t1 = System.currentTimeMillis();
        long h = Runtime.getRuntime().totalMemory();
        long hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (h - hf));
        long nt = System.nanoTime();
        boolean F = false;
        boolean T = true;
        List<LexerToken> out = LexerToken.parse(input, T, 3);
        long incr = System.nanoTime() - nt;
        h = Runtime.getRuntime().totalMemory();
        hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem1=" + (h - hf));
        if (out.size() < 1000) {
            LexerToken.print(out);
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Lexer time = " + (t2 - t1));
        System.out.println("Nano time = " + incr);
    }
}

