/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.bookmarks;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.bookmarks.LineBookmark;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.buffer.ExpiredTextBufferException;

final class CodeEditorBookmark
extends LineBookmark {
    CodeEditorBookmark(URL url, int line) {
        super(url, line);
    }

    public void gotoBookmark() {
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        Project activeProject = Ide.getActiveProject();
        Context context = new Context(activeWorkspace, activeProject);
        try {
            Node node = NodeFactory.findOrCreate((URL)this.getURL());
            context.setNode(node);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
            EditorManager editorManager = EditorManager.getEditorManager();
            Editor editor = editorManager.openEditor(openEditorOptions);
            if (editor instanceof CodeEditor) {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                Context editorContext = editor.getContext();
                LineNavigationPoint point = new LineNavigationPoint(editorContext, this.getLine(), 0, false);
                mgr.navigateTo((NavigationPoint)point);
            }
        }
        catch (ExpiredTextBufferException node) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getLineFromContext(Context context) {
        if (context.getView() instanceof CodeEditor) {
            return ((CodeEditor)context.getView()).getCaretLine();
        }
        return -1;
    }
}

