/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.utils;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;

public class TableColumnSizer {
    public static int getColumnPreferredWidthToFit(JTable jTable, int n, boolean bl, boolean bl2) {
        int n2 = bl ? TableColumnSizer.getColumnHeaderPreferredWidth(jTable, n) : 0;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            n2 = Math.max(TableColumnSizer.getColumnPreferredWidthAtRow(jTable, i, n, bl2), n2);
        }
        return n2;
    }

    private static int getColumnHeaderPreferredWidth(JTable jTable, int n) {
        return jTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)jTable, (Object)jTable.getModel().getColumnName((int)n), (boolean)false, (boolean)false, (int)0, (int)n).getPreferredSize().width + 2;
    }

    private static int getColumnPreferredWidthAtRow(JTable jTable, int n, int n2, boolean bl) {
        Component component;
        int n3 = jTable.getCellRenderer((int)n, (int)n2).getTableCellRendererComponent((JTable)jTable, (Object)jTable.getModel().getValueAt((int)n, (int)TableColumnSizer.getModelColumnIndex((JTable)jTable, (int)n2)), (boolean)false, (boolean)false, (int)n, (int)TableColumnSizer.getModelColumnIndex((JTable)jTable, (int)n2)).getPreferredSize().width + 4;
        if (bl && jTable.isCellEditable(n, n2) && (component = jTable.getCellEditor(n, n2).getTableCellEditorComponent(jTable, jTable.getModel().getValueAt(n, TableColumnSizer.getModelColumnIndex(jTable, n2)), false, n, TableColumnSizer.getModelColumnIndex(jTable, n2))) != null) {
            n3 = Math.max(n3, component.getPreferredSize().width);
        }
        return n3;
    }

    private static int getModelColumnIndex(JTable jTable, int n) {
        return jTable.getColumnModel().getColumn(n).getModelIndex();
    }

    public static Dimension getPreferredScrollableViewportSize(JTable jTable, int n) {
        Dimension dimension = new Dimension(0, 0);
        int n2 = TableColumnSizer.getMaxColumnCountForSizingColumns(jTable);
        for (int i = 0; i < n2; ++i) {
            dimension.width = dimension.width + TableColumnSizer.getColumnPreferredWidthToFit(jTable, i, true, jTable.getRowCount() > 0 ? jTable.getModel().isCellEditable(0, i) : false);
        }
        dimension.height = n * jTable.getRowHeight();
        return dimension;
    }

    public static void setColumnsWidthToFit(JTable jTable, boolean bl, boolean bl2) {
        int n = TableColumnSizer.getMaxColumnCountForSizingColumns(jTable);
        for (int i = 0; i < n; ++i) {
            if (!TableColumnSizer.preferredWidthIsSettable(jTable, i)) continue;
            TableColumnSizer.setColumnPreferredWidth(jTable, i, TableColumnSizer.getColumnPreferredWidthToFit(jTable, i, bl, bl2));
        }
    }

    private static int getMaxColumnCountForSizingColumns(JTable jTable) {
        return Math.min(jTable.getColumnModel().getColumnCount(), jTable.getModel().getColumnCount());
    }

    private static boolean preferredWidthIsSettable(JTable jTable, int n) {
        return jTable.getColumnModel().getColumn(n).getMaxWidth() != 0;
    }

    private static void setColumnPreferredWidth(JTable jTable, int n, int n2) {
        jTable.getColumnModel().getColumn(n).setPreferredWidth(n2);
    }

    public static void main(String[] stringArray) {
    }
}

