/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor;

import java.util.HashMap;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.util.Duration;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.performancemonitor.GaugeChart;
import oracle.dbtools.raptor.timesten.performancemonitor.InformationTile;
import oracle.dbtools.raptor.timesten.performancemonitor.JFXPerformanceMonitorPane;
import oracle.dbtools.raptor.timesten.performancemonitor.PerformanceBarChart;
import oracle.dbtools.raptor.timesten.performancemonitor.PerformancePieChart;
import oracle.dbtools.raptor.timesten.performancemonitor.TopSQLTile;
import oracle.dbtools.raptor.timesten.performancemonitor.data.DashboardSummaryInfo;
import oracle.dbtools.raptor.timesten.performancemonitor.data.SummaryDataProvider;
import oracle.dbtools.raptor.timesten.performancemonitor.data.TopSQLCmdBean;
import oracle.dbtools.raptor.timesten.utils.JavaFxWorker;

public class GridSummaryPane
extends BorderPane {
    public static final Font TITLE_FONT = Font.font(null, (FontWeight)FontWeight.BOLD, (double)(Font.getDefault().getSize() - 1.0));
    private SummaryDataProvider data;
    private GridPane centalpane;
    private GaugeChart cpuChart;
    private GaugeChart tempSpaceChart;
    private GaugeChart permSpaceChart;
    private PerformancePieChart txtlog;
    private PerformancePieChart chpk;
    private Background tilesBG;
    private InformationTile clientServerConnection;
    private InformationTile directConnection;
    private InformationTile selectRate;
    private InformationTile updateRate;
    private InformationTile insertRate;
    private InformationTile deleteRate;
    private static final double WIDTH_PERCENTAGE = 12.5;
    private static final Color TILES_BACKGROUND_COLOR = Color.LIGHTGREY;
    private final int ROW_HEIGHT = 125;
    private PerformanceBarChart networkChart;
    private TopSQLTile topSQL;
    private SummaryPane summary;
    private Timeline timeline;
    private int poolingInterval = 0;

    public GridSummaryPane(JFXPerformanceMonitorPane jFXPerformanceMonitorPane, SummaryDataProvider summaryDataProvider) {
        this.data = summaryDataProvider;
        this.getStyleClass().add((Object)"background");
        this.setPrefWidth(Double.MAX_VALUE);
        this.setPrefHeight(Double.MAX_VALUE);
        this.setMaxWidth(Double.MAX_VALUE);
        this.setMaxHeight(Double.MAX_VALUE);
        this.tilesBG = new Background(new BackgroundFill[]{new BackgroundFill((Paint)TILES_BACKGROUND_COLOR, null, null)});
        this.setTop((Node)new InformationPane());
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.getStyleClass().add((Object)"scrollpane");
        this.centalpane = new GridPane();
        this.centalpane.setHgap(10.0);
        this.centalpane.setVgap(10.0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(12.5);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(12.5);
        ColumnConstraints columnConstraints3 = new ColumnConstraints();
        columnConstraints3.setPercentWidth(12.5);
        ColumnConstraints columnConstraints4 = new ColumnConstraints();
        columnConstraints4.setPercentWidth(12.5);
        ColumnConstraints columnConstraints5 = new ColumnConstraints();
        columnConstraints5.setPercentWidth(12.5);
        ColumnConstraints columnConstraints6 = new ColumnConstraints();
        columnConstraints6.setPercentWidth(12.5);
        ColumnConstraints columnConstraints7 = new ColumnConstraints();
        columnConstraints7.setPercentWidth(12.5);
        ColumnConstraints columnConstraints8 = new ColumnConstraints();
        columnConstraints8.setPercentWidth(12.5);
        this.centalpane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints2, columnConstraints3, columnConstraints4, columnConstraints5, columnConstraints6, columnConstraints7, columnConstraints8});
        RowConstraints rowConstraints = new RowConstraints(125.0);
        RowConstraints rowConstraints2 = new RowConstraints(125.0);
        RowConstraints rowConstraints3 = new RowConstraints(125.0);
        RowConstraints rowConstraints4 = new RowConstraints(125.0);
        RowConstraints rowConstraints5 = new RowConstraints(125.0);
        RowConstraints rowConstraints6 = new RowConstraints(125.0);
        this.centalpane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints, rowConstraints2, rowConstraints3, rowConstraints4, rowConstraints5, rowConstraints6});
        this.centalpane.getStyleClass().add((Object)"scrollpane");
        this.cpuChart = new GaugeChart(true, Messages.getString("TimestenGrid.cpuUsage"));
        this.cpuChart.setBackgroungColor(Color.LIGHTGRAY);
        this.tempSpaceChart = new GaugeChart(true, Messages.getString("TimestenGrid.tempSpaceUsage"));
        this.tempSpaceChart.setBackgroungColor(Color.LIGHTGRAY);
        this.permSpaceChart = new GaugeChart(true, Messages.getString("TimestenGrid.permSpaceUsage"));
        this.permSpaceChart.setBackgroungColor(Color.LIGHTGRAY);
        this.networkChart = new PerformanceBarChart(Messages.getString("TimestenGrid.transmission"), Messages.getString("TimestenGrid.mbs"));
        this.networkChart.setBackground(this.tilesBG);
        this.clientServerConnection = new InformationTile(Messages.getString("TimesTenGrid.clientServer"), Messages.getString("TimestenGrid.connectionCount"), true);
        this.directConnection = new InformationTile(Messages.getString("TimesTenGrid.direct"), Messages.getString("TimestenGrid.connectionCount"), true);
        this.summary = new SummaryPane();
        this.chpk = new PerformancePieChart(Messages.getString("TimestenGrid.checkpointFileUsage"));
        this.txtlog = new PerformancePieChart(Messages.getString("TimestenGrid.transactionLogFileUsage"));
        this.clientServerConnection.setBackground(this.tilesBG);
        this.directConnection.setBackground(this.tilesBG);
        this.chpk.setBackground(this.tilesBG);
        this.txtlog.setBackground(this.tilesBG);
        this.topSQL = new TopSQLTile(Messages.getString("TimestenGrid.topSQLTitle"), summaryDataProvider.getConnection());
        this.topSQL.setBackground(this.tilesBG);
        this.selectRate = new InformationTile(Messages.getString("TimestenGrid.selectRatePerSecond"), "", false);
        this.selectRate.setBackground(this.tilesBG);
        this.updateRate = new InformationTile(Messages.getString("TimestenGrid.updateRatePerSecond"), "", false);
        this.updateRate.setBackground(this.tilesBG);
        this.insertRate = new InformationTile(Messages.getString("TimestenGrid.insertRatePerSecond"), "", false);
        this.insertRate.setBackground(this.tilesBG);
        this.deleteRate = new InformationTile(Messages.getString("TimestenGrid.deleteRatePerSecond"), "", false);
        this.deleteRate.setBackground(this.tilesBG);
        this.centalpane.add((Node)this.summary, 0, 0, 2, 2);
        this.centalpane.add((Node)this.networkChart, 0, 2, 2, 2);
        this.centalpane.add((Node)this.permSpaceChart, 4, 0, 2, 2);
        this.centalpane.add((Node)this.tempSpaceChart, 6, 0, 2, 2);
        this.centalpane.add((Node)this.cpuChart, 2, 0, 2, 2);
        this.centalpane.add((Node)this.clientServerConnection, 2, 2, 1, 1);
        this.centalpane.add((Node)this.directConnection, 3, 2, 1, 1);
        this.centalpane.add((Node)this.chpk, 4, 2, 2, 2);
        this.centalpane.add((Node)this.txtlog, 6, 2, 2, 2);
        this.centalpane.add((Node)this.topSQL, 2, 3, 2, 1);
        this.centalpane.add((Node)this.selectRate, 0, 4, 1, 1);
        this.centalpane.add((Node)this.updateRate, 1, 4, 1, 1);
        this.centalpane.add((Node)this.insertRate, 0, 5, 1, 1);
        this.centalpane.add((Node)this.deleteRate, 1, 5, 1, 1);
        scrollPane.setContent((Node)this.centalpane);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.viewportBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observableValue, Bounds bounds, Bounds bounds2) {
                GridSummaryPane.this.centalpane.setPrefWidth(bounds2.getWidth());
            }
        });
        scrollPane.autosize();
        this.setCenter((Node)scrollPane);
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.refreshAllPane();
    }

    private void setupRefresh() {
        if (this.poolingInterval == 0 && this.timeline != null) {
            this.timeline.stop();
            return;
        }
        if (this.timeline == null) {
            this.timeline = new Timeline();
            this.timeline.setCycleCount(-1);
        } else {
            this.timeline.stop();
        }
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)this.poolingInterval), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                GridSummaryPane.this.refreshAllPane();
            }
        }, new KeyValue[0]);
        this.timeline.getKeyFrames().add((Object)keyFrame);
        this.timeline.play();
    }

    private void refreshAllPane() {
        JavaFxWorker javaFxWorker = new JavaFxWorker(){
            HashMap<String, DashboardSummaryInfo> diskInfo;
            HashMap<String, DashboardSummaryInfo> networkInfo;
            HashMap<String, DashboardSummaryInfo> connInfo;
            HashMap<String, DashboardSummaryInfo> memInfo;
            ObservableList<TopSQLCmdBean> topCmds;
            HashMap<String, DashboardSummaryInfo> rates;
            int databaseState;

            @Override
            public void doInBackground() {
                GridSummaryPane.this.data.refreshStaticInfo();
                this.diskInfo = GridSummaryPane.this.data.getUsedDiskInfo();
                this.networkInfo = GridSummaryPane.this.data.getNetworkInformation();
                this.connInfo = GridSummaryPane.this.data.getConnectionInformation();
                this.memInfo = GridSummaryPane.this.data.getAvailableMemoryInfo();
                this.topCmds = GridSummaryPane.this.data.getTopSQLCmds("executions");
                this.rates = GridSummaryPane.this.data.getRates();
                this.databaseState = GridSummaryPane.this.data.getGridStatus();
            }

            @Override
            public void done() {
                GridSummaryPane.this.cpuChart.setValue(GridSummaryPane.this.data.getCPUInfo());
                GridSummaryPane.this.chpk.refreshPane(this.diskInfo.get("DISK_CHECKPOINT"));
                GridSummaryPane.this.txtlog.refreshPane(this.diskInfo.get("DISK_TXN_LOG"));
                GridSummaryPane.this.networkChart.refreshPane(this.networkInfo);
                GridSummaryPane.this.clientServerConnection.refreshPane(this.connInfo.get("CS_CONNECTIONS"));
                GridSummaryPane.this.directConnection.refreshPane(this.connInfo.get("DIRECT_CONNECTIONS"));
                GridSummaryPane.this.permSpaceChart.setValue(this.memInfo.get("PERM_SPACE"));
                GridSummaryPane.this.tempSpaceChart.setValue(this.memInfo.get("TEMP_SPACE"));
                GridSummaryPane.this.summary.refreshPane(this.databaseState);
                GridSummaryPane.this.requestLayout();
                GridSummaryPane.this.topSQL.setSQL(this.topCmds);
                GridSummaryPane.this.selectRate.refreshPane(this.rates.get("stmt.executes.selects"));
                GridSummaryPane.this.insertRate.refreshPane(this.rates.get("stmt.executes.inserts"));
                GridSummaryPane.this.updateRate.refreshPane(this.rates.get("stmt.executes.updates"));
                GridSummaryPane.this.deleteRate.refreshPane(this.rates.get("stmt.executes.deletes"));
            }
        };
        javaFxWorker.execute();
    }

    private class InformationPane
    extends HBox {
        public InformationPane() {
            GridPane gridPane = new GridPane();
            gridPane.setHgap(10.0);
            gridPane.setVgap(10.0);
            gridPane.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
            Text text = new Text(Messages.getString("TimestenGrid.PerformanceOverview"));
            text.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)20.0));
            gridPane.add((Node)text, 0, 0);
            HBox hBox = new HBox();
            hBox.setSpacing(10.0);
            final ComboBox comboBox = new ComboBox();
            comboBox.getItems().addAll((Object[])new String[]{Messages.getString("TimestenGrid.manual"), Messages.getString("TimestenGrid.everyOneMinute"), Messages.getString("TimestenGrid.everyThreeMinute")});
            comboBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    int n = comboBox.getSelectionModel().getSelectedIndex();
                    switch (n) {
                        case 0: {
                            GridSummaryPane.this.poolingInterval = 0;
                            break;
                        }
                        case 1: {
                            GridSummaryPane.this.poolingInterval = 60000;
                            break;
                        }
                        case 2: {
                            GridSummaryPane.this.poolingInterval = 180000;
                        }
                    }
                    GridSummaryPane.this.setupRefresh();
                }
            });
            Text text2 = new Text(Messages.getString("TimestenGrid.refresh"));
            ImageView imageView = new ImageView();
            imageView.setCursor(Cursor.HAND);
            imageView.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    GridSummaryPane.this.refreshAllPane();
                }
            });
            Image image = new Image(GridSummaryPane.class.getResourceAsStream("gtk_refresh.png"));
            imageView.setImage(image);
            hBox.getChildren().addAll((Object[])new Node[]{text2, comboBox, imageView});
            hBox.setAlignment(Pos.CENTER_RIGHT);
            this.getChildren().addAll((Object[])new Node[]{gridPane, hBox});
            HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        }
    }

    private class SummaryPane
    extends BorderPane {
        private Text elementCountValue;
        private Text replicaSetCount;
        private Text kValueValue;
        private Text dataStore;
        private int row = 0;
        private GridPane gridPane;
        private Label stateLabel;
        private Image clearImage = new Image(GridSummaryPane.class.getResourceAsStream("clear.png"));
        private Image alertImage = new Image(GridSummaryPane.class.getResourceAsStream("warning.png"));
        private Image errorImage = new Image(GridSummaryPane.class.getResourceAsStream("alert.png"));

        public SummaryPane() {
            this.gridPane = new GridPane();
            this.gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.gridPane.setHgap(15.0);
            this.gridPane.setVgap(10.0);
            this.setBackground(GridSummaryPane.this.tilesBG);
            this.dataStore = new Text(GridSummaryPane.this.data.getDataStore());
            this.elementCountValue = new Text(Integer.toString(GridSummaryPane.this.data.getElementCount()));
            this.replicaSetCount = new Text(Integer.toString(GridSummaryPane.this.data.getReplicaSetCount()));
            this.kValueValue = new Text(Integer.toString(GridSummaryPane.this.data.getDataSpaceGroupCount()));
            this.addComponentRow(Messages.getString("TimesTenGrid.databaseColumn"), (Node)this.dataStore);
            this.addComponentRow(Messages.getString("TimestenGrid.kValue"), (Node)this.kValueValue);
            this.addComponentRow(Messages.getString("TimestenGrid.replicasetCount"), (Node)this.replicaSetCount);
            this.stateLabel = new Label();
            this.addComponentRow(Messages.getString("TimestenGrid.databaseState"), (Node)this.stateLabel);
            this.gridPane.setAlignment(Pos.TOP_LEFT);
            this.setCenter((Node)this.gridPane);
        }

        public void addComponentRow(String string, Node node) {
            Text text = new Text(string);
            text.setFont(TITLE_FONT);
            this.gridPane.add((Node)text, 0, this.row);
            this.gridPane.add(node, 1, this.row);
            ++this.row;
        }

        public void refreshPane(int n) {
            this.elementCountValue.setText(Integer.toString(GridSummaryPane.this.data.getElementCount()));
            this.replicaSetCount.setText(Integer.toString(GridSummaryPane.this.data.getReplicaSetCount()));
            this.kValueValue.setText(Integer.toString(GridSummaryPane.this.data.getDataSpaceGroupCount()));
            if (n == 0) {
                this.stateLabel.setText(Messages.getString("TimestenGrid.clear"));
                this.stateLabel.setGraphic((Node)new ImageView(this.clearImage));
            } else if (n == 2) {
                this.stateLabel.setText(Messages.getString("TimestenGrid.alert"));
                this.stateLabel.setGraphic((Node)new ImageView(this.alertImage));
            } else if (n == 3) {
                this.stateLabel.setText(Messages.getString("TimestenGrid.majorIssue"));
                this.stateLabel.setGraphic((Node)new ImageView(this.errorImage));
            } else {
                this.stateLabel.setText(Messages.getString("TimesTen.common.unknown"));
                this.stateLabel.setGraphic(null);
            }
        }
    }
}

