/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.topology;

import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.transform.Scale;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.DataInstancesPanel;
import oracle.dbtools.raptor.timesten.grid.object.DistributionMap;
import oracle.dbtools.raptor.timesten.grid.object.Element;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.topology.Topology;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;

public class TopologyPanel
extends JFXPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(TopologyPanel.class.getName());
    private static int FIELD_WIDTH = 170;
    private static int FIELD_HEIGHT = 50;
    private static int COMPONENT_PADDING = 10;
    private static int MAX_TEXT_WIDTH = FIELD_WIDTH - COMPONENT_PADDING - COMPONENT_PADDING;
    private Scale scale;
    private Group root;
    private Scene scene;
    private ScrollPane scrollPane;
    private double zoomFactor = 1.0;
    private boolean readOnly;
    private boolean disableRightclick;
    private double orgSceneX;
    private double orgSceneY;
    private double orgTranslateX;
    private double orgTranslateY;
    private StackPane lastPaneSelected;
    private TopologyElement lastElementselected;
    private Runnable drawUpdater;
    private static final ElementDrawStyle[] elementStyle = new ElementDrawStyle[]{new ElementDrawStyle(Color.web((String)"0x0CA5B0")), new ElementDrawStyle(Color.web((String)"0x4E3F30")), new ElementDrawStyle(Color.web((String)"0x2E4057")), new ElementDrawStyle(Color.web((String)"0x607D8B")), new ElementDrawStyle(Color.web((String)"0xdb2b39")).setSelectedColor(Color.web((String)"0x2E4057"))};
    private static final ElementDrawStyle availableStyle = new ElementDrawStyle(Color.web((String)"0xF0ECC9")).setTextColor(Color.web((String)"0x4E3F30"));
    private static final ElementDrawStyle rsStyle = new ElementDrawStyle(Color.web((String)"0xE3A72F"));
    public static final Map<Paint, ElementDrawStyle> styleMap = new HashMap<Paint, ElementDrawStyle>();
    private List<StackPane> replicaSetPaneList = new ArrayList<StackPane>();
    private List<StackPane> dataSpaceGroupPaneList = new ArrayList<StackPane>();
    private List<StackPane> elementsPaneList = new ArrayList<StackPane>();
    private List<Arrow> arrowDrawingList = new ArrayList<Arrow>();
    private Tooltip tooltip;
    private boolean paintReplicaSets = true;
    private DistributionMap distributionMap;
    private Topology topology;
    private String replicationScheme;
    private TopologyType type;
    private final int AVAILABLE_INSTANCE_HOFFSET = 2 * COMPONENT_PADDING;
    private final Pattern dsgStringPattern = Pattern.compile(Messages.getString("TimesTenGrid.dsg").replace("{0}", "(.*?)"));
    private final EventHandler<MouseEvent> rootOnMousePressedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            TopologyPanel.this.orgSceneX = mouseEvent.getSceneX();
            TopologyPanel.this.orgSceneY = mouseEvent.getSceneY();
            TopologyPanel.this.orgTranslateX = TopologyPanel.this.root.getTranslateX();
            TopologyPanel.this.orgTranslateY = TopologyPanel.this.root.getTranslateY();
        }
    };
    private final EventHandler<MouseEvent> rsClicked = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
        }
    };
    private final EventHandler<MouseEvent> dsgClicked = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            StackPane stackPane = (StackPane)mouseEvent.getSource();
            TopologyPanel.this.highLightPane(stackPane, null);
            if (mouseEvent.getButton() != MouseButton.PRIMARY) {
                TopologyPanel.this.rightClickOnDataSpaceGroup(TopologyPanel.this.getFieldValue(stackPane), mouseEvent);
            }
            mouseEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> elementClicked = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            StackPane stackPane = (StackPane)mouseEvent.getSource();
            TopologyElement topologyElement = TopologyPanel.this.topology.getElementByName(TopologyPanel.this.getPaneLabel(stackPane));
            TopologyPanel.this.highLightPane(stackPane, topologyElement);
            if (mouseEvent.getButton() != MouseButton.PRIMARY && mouseEvent.getButton() == MouseButton.SECONDARY && topologyElement.isAddableToTopology() && !TopologyPanel.this.disableRightclick) {
                TopologyPanel.this.rightClickOnElement(topologyElement, mouseEvent);
            }
            mouseEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> rootClicked = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            TopologyPanel.this.clearLastPaneSelected();
            mouseEvent.consume();
        }
    };

    public TopologyPanel(Topology topology, boolean bl) {
        this.setTopology(topology);
        this.readOnly = bl;
        this.initFx();
    }

    public TopologyPanel(DistributionMap distributionMap, String string, boolean bl) {
        this.setDistributionMap(distributionMap, string);
        this.readOnly = bl;
        this.initFx();
    }

    private void initFx() {
        Platform.setImplicitExit((boolean)false);
        ShutdownHook shutdownHook = new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Platform.exit();
                    }
                });
            }
        };
        ExitCommand.removeShutdownHook((ShutdownHook)shutdownHook);
        ExitCommand.addShutdownHook((ShutdownHook)shutdownHook);
        if (Platform.isFxApplicationThread()) {
            this.init();
        } else {
            Platform.runLater(() -> this.init());
        }
    }

    private void init() {
        this.root = new Group();
        this.scrollPane = new ScrollPane();
        this.scrollPane.setContent((Node)this.root);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scene = new Scene((Parent)this.scrollPane);
        this.root.setOnMousePressed(this.rootOnMousePressedEventHandler);
        this.scale = new Scale(0.9, 0.9);
        this.root.getTransforms().add((Object)this.scale);
        this.setScene(this.scene);
        this.initDrawUpdater();
    }

    private void initDrawUpdater() {
        if (this.drawUpdater == null) {
            this.drawUpdater = new Runnable(){

                @Override
                public void run() {
                    try {
                        TopologyPanel.this.paintReplicaSets = TopologyPanel.this.type == TopologyType.HOST_ASSIG ? false : TopologyPanel.this.distributionMap.getReplicaSets().length > 0;
                        TopologyPanel.this.root.getChildren().removeAll(TopologyPanel.this.dataSpaceGroupPaneList);
                        TopologyPanel.this.dataSpaceGroupPaneList.clear();
                        TopologyPanel.this.doPaintDataSpaceGroups();
                        TopologyPanel.this.root.getChildren().addAll(TopologyPanel.this.dataSpaceGroupPaneList);
                        TopologyPanel.this.root.getChildren().removeAll(TopologyPanel.this.replicaSetPaneList);
                        TopologyPanel.this.replicaSetPaneList.clear();
                        if (TopologyPanel.this.type == TopologyType.DIST_MAP && TopologyPanel.this.paintReplicaSets) {
                            TopologyPanel.this.doPaintReplicaSets();
                            TopologyPanel.this.root.getChildren().addAll(TopologyPanel.this.replicaSetPaneList);
                        }
                        TopologyPanel.this.root.getChildren().removeAll(TopologyPanel.this.elementsPaneList);
                        TopologyPanel.this.elementsPaneList.clear();
                        TopologyPanel.this.doPaintElements();
                        TopologyPanel.this.root.getChildren().addAll(TopologyPanel.this.elementsPaneList);
                        for (Arrow arrow : TopologyPanel.this.arrowDrawingList) {
                            arrow.eraseThisArrow(TopologyPanel.this.root);
                        }
                        if (TopologyPanel.this.type == TopologyType.DIST_MAP && TopologyPanel.this.paintReplicaSets) {
                            TopologyPanel.this.doPaintReplicationArrows(TopologyPanel.this.root);
                        }
                    }
                    catch (Exception exception) {
                        logger.severe("Error+" + exception.getMessage());
                    }
                }
            };
        }
    }

    public void updateDraw() {
        this.initDrawUpdater();
        if (Platform.isFxApplicationThread()) {
            this.drawUpdater.run();
        } else {
            Platform.runLater((Runnable)this.drawUpdater);
        }
    }

    public void setDistributionMap(DistributionMap distributionMap, String string) {
        this.topology = distributionMap;
        this.distributionMap = distributionMap;
        this.replicationScheme = string;
        if (distributionMap != null) {
            this.paintReplicaSets = distributionMap.getReplicaSets().length > 0;
        }
        this.type = TopologyType.DIST_MAP;
    }

    public void setTopology(Topology topology) {
        this.topology = topology;
        this.type = TopologyType.HOST_ASSIG;
    }

    private void doPaintElements() {
        Object object;
        int n;
        this.elementsPaneList.clear();
        int n2 = this.paintReplicaSets ? FIELD_WIDTH + COMPONENT_PADDING : COMPONENT_PADDING;
        int n3 = 3 * COMPONENT_PADDING + FIELD_HEIGHT;
        for (int i = 0; i < this.topology.getDataSpaceGroups().length; ++i) {
            TopologyElement topologyElement;
            n = n3;
            Object object2 = new HashSet<TopologyElement>();
            if (this.type == TopologyType.DIST_MAP) {
                if (this.readOnly) {
                    object2.addAll(this.topology.getElementsInTopology(i + 1));
                } else {
                    object2.addAll(this.topology.getElementsInTopology(i + 1));
                    object2.addAll(this.topology.getElementsMarkedToAdd(i + 1));
                }
            } else {
                object2 = this.topology.getElementsInTopologyHideRemoved(i + 1);
            }
            int n4 = 0;
            object = object2.iterator();
            while (object.hasNext()) {
                topologyElement = (TopologyElement)object.next();
                if (!topologyElement.hasRS()) continue;
                n = n3 + (topologyElement.getReplicaSet() - 1) * (FIELD_HEIGHT + 3 * COMPONENT_PADDING);
                this.elementsPaneList.add(this.paintElement(topologyElement, FIELD_WIDTH, FIELD_HEIGHT, n2, n, this.getElementBoxStyle(i)));
                ++n4;
            }
            n = n3 + n4 * (FIELD_HEIGHT + 3 * COMPONENT_PADDING);
            object = object2.iterator();
            while (object.hasNext()) {
                topologyElement = (TopologyElement)object.next();
                if (topologyElement.hasRS()) continue;
                this.elementsPaneList.add(this.paintElement(topologyElement, FIELD_WIDTH, FIELD_HEIGHT, n2, n, this.getElementBoxStyle(i)));
                n += FIELD_HEIGHT + 3 * COMPONENT_PADDING;
            }
            n2 += FIELD_WIDTH + COMPONENT_PADDING;
        }
        if (!this.readOnly || this.type == TopologyType.HOST_ASSIG) {
            n2 = this.topology.getDataSpaceGroups().length * (FIELD_WIDTH + COMPONENT_PADDING) + this.AVAILABLE_INSTANCE_HOFFSET;
            n = FIELD_HEIGHT + 3 * COMPONENT_PADDING;
            n2 = this.paintReplicaSets ? (n2 += FIELD_WIDTH + COMPONENT_PADDING) : (n2 += COMPONENT_PADDING);
            Set<TopologyElement> set = this.type == TopologyType.DIST_MAP ? this.topology.getElementsNotAddMarked() : this.topology.getElementsNotIncludedShowRemoved();
            for (TopologyElement topologyElement : set) {
                object = this.type == TopologyType.DIST_MAP ? this.getElementBoxStyle(topologyElement.getDataSpaceGroup() - 1) : availableStyle;
                this.elementsPaneList.add(this.paintElement(topologyElement, FIELD_WIDTH, FIELD_HEIGHT, n2, n, (ElementDrawStyle)object));
                n += FIELD_HEIGHT + 3 * COMPONENT_PADDING;
            }
        }
    }

    private void doPaintDataSpaceGroups() {
        int n = this.paintReplicaSets ? FIELD_WIDTH + COMPONENT_PADDING : COMPONENT_PADDING;
        int n2 = COMPONENT_PADDING;
        int n3 = 0;
        for (String string : this.topology.getDataSpaceGroups()) {
            this.dataSpaceGroupPaneList.add(this.createDSGElement(string, FIELD_WIDTH, FIELD_HEIGHT, n, n2, this.getElementBoxStyle(n3)));
            n += FIELD_WIDTH + COMPONENT_PADDING;
            ++n3;
        }
        n += this.AVAILABLE_INSTANCE_HOFFSET;
        if (!this.readOnly || this.type == TopologyType.HOST_ASSIG) {
            String string = this.type == TopologyType.DIST_MAP ? Messages.getString("TimesTenGrid.availableLbl") : Messages.getString("TimesTenGrid.unassignedHosts");
            this.dataSpaceGroupPaneList.add(this.createDSGElement(string, FIELD_WIDTH, FIELD_HEIGHT, n, n2, availableStyle));
        }
    }

    public void doPaintReplicationArrows(Group group) {
        for (Arrow arrow : this.arrowDrawingList) {
            arrow.eraseThisArrow(group);
        }
        this.arrowDrawingList.clear();
        int n = 2 * COMPONENT_PADDING + FIELD_HEIGHT;
        int n2 = FIELD_WIDTH;
        int n3 = FIELD_WIDTH + COMPONENT_PADDING;
        int n4 = 2 * COMPONENT_PADDING + FIELD_HEIGHT;
        int n5 = n + n4 / 2;
        int n6 = n2 + FIELD_WIDTH + COMPONENT_PADDING + COMPONENT_PADDING / 2;
        for (int i = 0; i < this.distributionMap.getReplicaSets().length; ++i) {
            int n7 = n6;
            for (int j = 0; j < this.topology.getDataSpaceGroups().length - 1; ++j) {
                this.arrowDrawingList.add(new Arrow(n7 - 20, n5, n7 + 20, n5, true));
                n7 += n3;
            }
            n5 += n4 + COMPONENT_PADDING;
        }
        for (Arrow arrow : this.arrowDrawingList) {
            arrow.paintThisArrow(group);
        }
    }

    private void doPaintReplicaSets() {
        this.replicaSetPaneList.clear();
        int n = this.topology.getDataSpaceGroups().length;
        int n2 = (n + 1) * FIELD_WIDTH + n * COMPONENT_PADDING;
        int n3 = COMPONENT_PADDING + COMPONENT_PADDING + FIELD_HEIGHT;
        int n4 = COMPONENT_PADDING + COMPONENT_PADDING + FIELD_HEIGHT;
        for (String string : this.distributionMap.getReplicaSets()) {
            this.replicaSetPaneList.add(this.createRSElement(string, n2, n3, COMPONENT_PADDING, n4));
            n4 += n3 + COMPONENT_PADDING;
        }
    }

    private StackPane paintElement(TopologyElement topologyElement, int n, int n2, int n3, int n4, ElementDrawStyle elementDrawStyle) {
        String string = "";
        if (this.topology.isMarkedToAdd(topologyElement)) {
            if (topologyElement instanceof Element) {
                string = Messages.getString("TimesTenGrid.toBeAdded");
            }
        } else if (this.topology.isMarkedToRemove(topologyElement)) {
            if (topologyElement instanceof Element) {
                string = Messages.getString("TimesTenGrid.toBeRemoved");
            }
        } else if (!topologyElement.isAddableToTopology()) {
            string = topologyElement.getFailStateMessage();
        } else if (topologyElement instanceof HostObject && !((HostObject)topologyElement).canEditDSG()) {
            string = Messages.getString("TimesTenGrid.notReassign");
        } else if (topologyElement instanceof Element && ((Element)topologyElement).getId() > 0) {
            string = MessageFormat.format(Messages.getString("TimesTenGrid.elementID"), ((Element)topologyElement).getId());
        }
        StackPane stackPane = null;
        if (topologyElement instanceof Element) {
            stackPane = this.createHelper(((Element)topologyElement).getInstance().getName(), ((Element)topologyElement).getInstance().getHost().getName(), string, n, n2, n3, n4, elementDrawStyle);
        } else if (topologyElement instanceof HostObject) {
            stackPane = this.createHelper(((HostObject)topologyElement).getName(), "", string, n, n2, n3, n4, elementDrawStyle);
        } else if (topologyElement instanceof DataInstancesPanel.Host) {
            stackPane = this.createHelper(((DataInstancesPanel.Host)topologyElement).getName(), "", string, n, n2, n3, n4, elementDrawStyle);
        }
        stackPane.setOnMouseClicked(this.elementClicked);
        stackPane.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (!bl2.booleanValue()) {
                    TopologyPanel.this.clearLastPaneSelected();
                }
            }
        });
        stackPane.setFocusTraversable(true);
        return stackPane;
    }

    private StackPane createHelper(String string, int n, int n2, int n3, int n4, ElementDrawStyle elementDrawStyle) {
        return this.createHelper(string, "", "", n, n2, n3, n4, elementDrawStyle);
    }

    private StackPane createHelper(String string, String string2, String string3, int n, int n2, int n3, int n4, ElementDrawStyle elementDrawStyle) {
        StackPane stackPane = new StackPane();
        Rectangle rectangle = new Rectangle((double)n, (double)n2, (Paint)elementDrawStyle.backgroundColor);
        rectangle.setStyle("-fx-border-radius: 20 20 0 0;");
        stackPane.getChildren().addAll((Object[])new Node[]{rectangle});
        Label label = new Label(string);
        label.setTextFill((Paint)elementDrawStyle.textColor);
        label.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)13.0));
        label.setMaxWidth((double)MAX_TEXT_WIDTH);
        stackPane.getChildren().add((Object)label);
        label.setAlignment(Pos.CENTER);
        StackPane.setAlignment((Node)label, (Pos)Pos.CENTER);
        Label label2 = new Label(string2);
        label2.setTextFill((Paint)elementDrawStyle.textColor);
        label2.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)11.0));
        label2.setMaxWidth((double)MAX_TEXT_WIDTH);
        stackPane.getChildren().add((Object)label2);
        label2.setAlignment(Pos.TOP_CENTER);
        StackPane.setAlignment((Node)label2, (Pos)Pos.TOP_CENTER);
        Label label3 = new Label(string3);
        label3.setTextFill((Paint)elementDrawStyle.textColor);
        label3.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)11.0));
        label3.setMaxWidth((double)MAX_TEXT_WIDTH);
        stackPane.getChildren().add((Object)label3);
        label3.setAlignment(Pos.BOTTOM_CENTER);
        StackPane.setAlignment((Node)label3, (Pos)Pos.BOTTOM_CENTER);
        stackPane.setTranslateX((double)n3);
        stackPane.setTranslateY((double)n4);
        Tooltip tooltip = new Tooltip(string);
        Tooltip.install((Node)stackPane, (Tooltip)tooltip);
        return stackPane;
    }

    private StackPane createDSGElement(String string, int n, int n2, int n3, int n4, ElementDrawStyle elementDrawStyle) {
        StackPane stackPane = this.createHelper(string, n, n2, n3, n4, elementDrawStyle);
        stackPane.setOnMouseClicked(this.dsgClicked);
        return stackPane;
    }

    private StackPane createRSElement(String string, int n, int n2, int n3, int n4) {
        Label label = new Label(string);
        label.setTextFill((Paint)TopologyPanel.rsStyle.textColor);
        label.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)13.0));
        Rectangle rectangle = new Rectangle((double)n, (double)n2, (Paint)TopologyPanel.rsStyle.backgroundColor);
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER_LEFT);
        StackPane.setMargin((Node)label, (Insets)new Insets(0.0, 0.0, 0.0, (double)COMPONENT_PADDING));
        stackPane.getChildren().addAll((Object[])new Node[]{rectangle, label});
        stackPane.setTranslateX((double)n3);
        stackPane.setTranslateY((double)n4);
        stackPane.setOnMouseClicked(this.rsClicked);
        return stackPane;
    }

    private void highLightPane(StackPane stackPane, TopologyElement topologyElement) {
        this.clearLastPaneSelected();
        Rectangle rectangle = (Rectangle)stackPane.getChildren().get(0);
        ElementDrawStyle elementDrawStyle = this.getElementBoxStyle(rectangle.getFill());
        rectangle.setStroke((Paint)elementDrawStyle.selectedElementColor);
        rectangle.setStrokeWidth(2.2);
        this.lastPaneSelected = stackPane;
        this.lastElementselected = topologyElement;
    }

    private String getFieldValue(StackPane stackPane) {
        Label label = (Label)stackPane.getChildren().get(1);
        return label.getText();
    }

    private void clearLastPaneSelected() {
        if (this.lastPaneSelected != null) {
            Rectangle rectangle = (Rectangle)this.lastPaneSelected.getChildren().get(0);
            rectangle.setStroke(rectangle.getFill());
        }
    }

    private void rightClickOnElement(final TopologyElement topologyElement, MouseEvent mouseEvent) {
        ContextMenu contextMenu = new ContextMenu();
        boolean bl = this.topology.getElementsInTopology().contains(topologyElement);
        boolean bl2 = this.topology.isMarkedToAdd(topologyElement);
        if (this.readOnly) {
            return;
        }
        if (topologyElement instanceof HostObject && ((HostObject)topologyElement).isAppliedToCurrent() && topologyElement.hasDSG()) {
            return;
        }
        if (this.type == TopologyType.HOST_ASSIG) {
            int n = this.topology.getElementLocalDataspaceGroup(topologyElement);
            for (final String string : this.topology.getDataSpaceGroups()) {
                int n2 = this.dataSpaceNumber(string);
                if (n == n2) continue;
                MenuItem menuItem = new MenuItem(string);
                menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        int n = TopologyPanel.this.dataSpaceNumber(string);
                        TopologyPanel.this.topology.markToAdd(topologyElement, n);
                        TopologyPanel.this.topology.markToAdd(topologyElement, n);
                        TopologyPanel.this.updateDraw();
                    }
                });
                contextMenu.getItems().add((Object)menuItem);
            }
            MenuItem menuItem = new MenuItem(Messages.getString("TimesTenGrid.moveToUnassignedHosts"));
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TopologyPanel.this.topology.markToRemove(topologyElement);
                    if (TopologyPanel.this.topology.getElementLocalDataspaceGroup(topologyElement) != -1) {
                        TopologyPanel.this.topology.markToRemove(topologyElement);
                    }
                    TopologyPanel.this.updateDraw();
                }
            });
            if (n != -1) {
                contextMenu.getItems().add((Object)menuItem);
            }
        } else if (bl || bl2) {
            TopologyElement topologyElement22;
            Set<TopologyElement> set = this.topology.getAddableElements(topologyElement.getDataSpaceGroup());
            Menu menu = new Menu(Messages.getString("TimesTenGrid.replaceWith"));
            Menu menu2 = new Menu(Messages.getString("TimesTenGrid.evictReplace"));
            for (final TopologyElement object2 : set) {
                MenuItem menuItem = new MenuItem(object2.toString());
                menu.getItems().add((Object)menuItem);
                menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        TopologyPanel.this.distributionMap.markToReplace(topologyElement, object2);
                        TopologyPanel.this.updateDraw();
                    }
                });
            }
            for (final TopologyElement topologyElement22 : set) {
                MenuItem menuItem = new MenuItem(topologyElement22.toString());
                menu2.getItems().add((Object)menuItem);
                menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        TopologyPanel.this.distributionMap.markToEvictReplace(topologyElement, topologyElement22);
                        TopologyPanel.this.updateDraw();
                    }
                });
            }
            MenuItem menuItem = new MenuItem(Messages.getString("TimesTenGrid.remove"));
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TopologyPanel.this.topology.markToRemove(topologyElement);
                    TopologyPanel.this.updateDraw();
                }
            });
            topologyElement22 = new MenuItem(Messages.getString("TimesTenGrid.evict"));
            topologyElement22.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TopologyPanel.this.distributionMap.markToEvict(topologyElement);
                    TopologyPanel.this.updateDraw();
                }
            });
            if (set.isEmpty()) {
                menu.setDisable(true);
                menu2.setDisable(true);
            }
            contextMenu.getItems().add((Object)menuItem);
            if (bl) {
                contextMenu.getItems().add((Object)menu);
                contextMenu.getItems().add((Object)topologyElement22);
                contextMenu.getItems().add((Object)menu2);
            }
        } else {
            Menu menu = new Menu(Messages.getString("TimesTenGrid.addAndReplace"));
            Menu menu3 = new Menu(Messages.getString("TimesTenGrid.addAndEvict"));
            Set<TopologyElement> set = this.topology.getRemovableElements(topologyElement.getDataSpaceGroup());
            for (final TopologyElement topologyElement3 : set) {
                MenuItem menuItem = new MenuItem(topologyElement3.toString());
                menu.getItems().add((Object)menuItem);
                menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        TopologyPanel.this.distributionMap.markToReplace(topologyElement3, topologyElement);
                        TopologyPanel.this.updateDraw();
                    }
                });
            }
            for (final TopologyElement topologyElement4 : set) {
                MenuItem menuItem = new MenuItem(topologyElement4.toString());
                menu3.getItems().add((Object)menuItem);
                menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        TopologyPanel.this.distributionMap.markToEvictReplace(topologyElement4, topologyElement);
                        TopologyPanel.this.updateDraw();
                    }
                });
            }
            MenuItem menuItem = new MenuItem(Messages.getString("TimesTenGrid.add"));
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TopologyPanel.this.topology.markToAdd(topologyElement);
                    TopologyPanel.this.updateDraw();
                }
            });
            contextMenu.getItems().add((Object)menuItem);
            if (set.isEmpty()) {
                menu.setDisable(true);
                menu3.setDisable(true);
            }
            contextMenu.getItems().add((Object)menu);
            contextMenu.getItems().add((Object)menu3);
        }
        contextMenu.show((Node)mouseEvent.getSource(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
    }

    private void rightClickOnDataSpaceGroup(String string, MouseEvent mouseEvent) {
        ContextMenu contextMenu = new ContextMenu();
        if (this.readOnly) {
            return;
        }
        MenuItem menuItem = new MenuItem(Messages.getString("TimesTenGrid.addAll"));
        boolean bl = string.equals(Messages.getString("TimesTenGrid.availableLbl")) || string.equals(Messages.getString("TimesTenGrid.unassignedHosts"));
        int n = bl ? -1 : this.dataSpaceNumber(string);
        final Set<TopologyElement> set = n >= 1 ? this.topology.getAddableElements(n) : (this.type == TopologyType.DIST_MAP ? this.topology.getMaxAddableElements() : new HashSet<TopologyElement>());
        menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                for (TopologyElement topologyElement : set) {
                    TopologyPanel.this.topology.markToAdd(topologyElement);
                }
                TopologyPanel.this.updateDraw();
            }
        });
        menuItem.setDisable(set.isEmpty());
        contextMenu.getItems().add((Object)menuItem);
        contextMenu.show((Node)mouseEvent.getSource(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
    }

    private void rightClickOnReplicaSet(String string, MouseEvent mouseEvent) {
    }

    private String getPaneLabel(StackPane stackPane) {
        Label label = (Label)stackPane.getChildren().get(1);
        Label label2 = (Label)stackPane.getChildren().get(2);
        if (label2.getText().isEmpty()) {
            return label.getText();
        }
        return label2.getText() + "." + label.getText();
    }

    public Dimension getReadOnlyDrawingSize(int n, int n2) {
        int n3 = n2 * (FIELD_HEIGHT + COMPONENT_PADDING);
        int n4 = (n + 1) * (FIELD_WIDTH + COMPONENT_PADDING);
        return new Dimension(n4, n3);
    }

    public void setDisableRightclick(boolean bl) {
        this.disableRightclick = bl;
    }

    public void validateDistribution() throws DistributionException {
        int n;
        int n2 = this.distributionMap.getKSafety();
        int n3 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            Set<TopologyElement> set = this.distributionMap.getElementsInTopologyHideRemoved(i + 1);
            set.removeAll(this.distributionMap.getToEvict());
            set.removeAll(this.distributionMap.getToRemoveReplace().keySet());
            set.addAll(this.distributionMap.getElementsMarkedToAdd(i + 1));
            for (TopologyElement topologyElement : set) {
                n = topologyElement.getReplicaSet();
                if (n <= 0) {
                    ++n4;
                }
                hashMap.merge(n, 1, Integer::sum);
            }
            arrayList.add(set.size());
            if ((Integer)arrayList.get(i) == 0) {
                ++n3;
            }
            set.clear();
        }
        if (n3 == n2) {
            throw new DistributionException(Messages.getString("TimesTenGrid.removeAllInstances"));
        }
        if (n3 > 0) {
            throw new DistributionException(Messages.getString("TimesTenGrid.errorOneReplicaSet"));
        }
        int n6 = (Integer)arrayList.get(0);
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n7 = (Integer)iterator.next();
            if (n7 == n6) continue;
            throw new DistributionException(Messages.getString("TimesTenGrid.dataSpaceGroupsBalanced"));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            int n8 = (Integer)entry.getKey();
            n = (Integer)entry.getValue();
            if (n8 <= 0 || n >= n2) continue;
            n5 += n2 - n;
        }
        if (n4 < n5) {
            throw new DistributionException(Messages.getString("TimesTenGrid.incompleteReplicaSet"));
        }
    }

    private ElementDrawStyle getElementBoxStyle(int n) {
        return elementStyle[n % elementStyle.length];
    }

    private ElementDrawStyle getElementBoxStyle(Paint paint) {
        return styleMap.get(paint);
    }

    private int dataSpaceNumber(String string) {
        Matcher matcher = this.dsgStringPattern.matcher(string);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    static {
        for (ElementDrawStyle elementDrawStyle : elementStyle) {
            styleMap.put((Paint)elementDrawStyle.backgroundColor, elementDrawStyle);
        }
        styleMap.put((Paint)TopologyPanel.availableStyle.backgroundColor, availableStyle);
        styleMap.put((Paint)TopologyPanel.rsStyle.backgroundColor, rsStyle);
    }

    private static enum TopologyType {
        DIST_MAP,
        HOST_ASSIG;

    }

    private static class ElementDrawStyle {
        Color backgroundColor;
        Color textColor;
        Color selectedElementColor;

        public ElementDrawStyle(Color color) {
            this.backgroundColor = color;
            this.textColor = Color.WHITE;
            this.selectedElementColor = Color.web((String)"0xD54B1A");
        }

        public ElementDrawStyle setSelectedColor(Color color) {
            this.selectedElementColor = color;
            return this;
        }

        public ElementDrawStyle setTextColor(Color color) {
            this.textColor = color;
            return this;
        }
    }

    private static class Arrow {
        private Path line;
        private Polygon rightHead;
        private Polygon leftHead;
        private boolean doubleEnded;
        private final Color arrowColor = Color.web((String)"0xF0ECC9");

        public Arrow(double d, double d2, int n, int n2, boolean bl) {
            this.doubleEnded = bl;
            this.line = new Path();
            this.line.setStrokeWidth(2.2);
            this.line.setStroke((Paint)this.arrowColor);
            this.line.getElements().add((Object)new MoveTo(d, d2));
            this.line.getElements().add((Object)new LineTo((double)n, (double)n2));
            this.rightHead = new Polygon();
            this.rightHead.setStroke((Paint)this.arrowColor);
            this.rightHead.setFill((Paint)this.arrowColor);
            this.rightHead.getPoints().addAll((Object[])new Double[]{0.0, 5.0, -5.0, -5.0, 5.0, -5.0});
            this.rightHead.setRotate(-90.0);
            this.rightHead.setTranslateX(d);
            this.rightHead.setTranslateY(d2);
            this.rightHead.setTranslateX((double)n);
            this.rightHead.setTranslateY((double)n2);
            this.leftHead = new Polygon();
            this.leftHead.setStroke((Paint)this.arrowColor);
            this.leftHead.setFill((Paint)this.arrowColor);
            this.leftHead.getPoints().addAll((Object[])new Double[]{0.0, 5.0, -5.0, -5.0, 5.0, -5.0});
            this.leftHead.setRotate(-270.0);
            this.leftHead.setTranslateX(d);
            this.leftHead.setTranslateY(d2);
        }

        public void paintThisArrow(Group group) {
            if (this.doubleEnded) {
                group.getChildren().add((Object)this.leftHead);
            }
            group.getChildren().add((Object)this.rightHead);
            group.getChildren().add((Object)this.line);
        }

        public void eraseThisArrow(Group group) {
            if (this.doubleEnded) {
                group.getChildren().remove((Object)this.leftHead);
            }
            group.getChildren().remove((Object)this.rightHead);
            group.getChildren().remove((Object)this.line);
        }
    }

    public class DistributionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DistributionException(String string) {
            super(string);
        }
    }
}

