/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BasicDeletable;
import oracle.dbtools.raptor.timesten.grid.Deletable;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DifferenceObject;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;

public class PhysicalGroupObject
extends TTGridObject
implements Deletable {
    public PhysicalGroupObject(String string) {
        this.name = string;
    }

    @Override
    public String getObjectType() {
        return Messages.getString("TimesTenGrid.PhysicalGroupObjectName");
    }

    public void diff(DifferenceObject differenceObject, PhysicalGroupObject physicalGroupObject) {
        physicalGroupObject.setAppliedToCurrent(true);
        this.setAppliedToCurrent(true);
        if (!this.name.equalsIgnoreCase(physicalGroupObject.getName())) {
            differenceObject.gridObjectEdited(physicalGroupObject, this);
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(PhysicalGroupObject physicalGroupObject) {
        return physicalGroupObject.getName().equalsIgnoreCase(this.getName());
    }

    public void updateSuggestions() {
        TTGridRootNode.getStorage().saveSuggestion("physicalGroups", this.getName());
    }

    public static List<String> getPhysicalGroupNameSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("physicalGroups");
    }

    @Override
    public void deleteObject(Runnable runnable) {
        BasicDeletable basicDeletable = new BasicDeletable();
        basicDeletable.setCmd(GridCommand.PHYSICAL_DELETE);
        basicDeletable.setCmdArgs(this.name);
        basicDeletable.setDeleteMsg(Messages.getString("TimesTenGrid.physicalGroupDelete"));
        basicDeletable.setDeletingObjMsg(MessageFormat.format(Messages.getString("TimesTenGrid.physicalGroupDeleting"), this.name));
        basicDeletable.setDeletingFromModelMsg(MessageFormat.format(Messages.getString("TimesTenGrid.physicalGroupDeleting"), this.name));
        basicDeletable.setDeleteCancelMsg(Messages.getString("TimesTenGrid.physicalGroupDeleteCancelled"));
        basicDeletable.deleteObject(runnable);
    }
}

