/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.loginspector;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.loginspector.LogInspectorMainWindow;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.javatools.icons.OracleIcons;

public final class SelectInstancesTreePanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private JTree _instancesTree;
    private JScrollPane _treeScrollPane;
    private IconNode root = null;
    private IconNode selected = null;
    private IconNode notSelected = null;
    private DefaultTreeModel _model;
    private JPopupMenu popup;
    private JMenuItem moveMenu;
    private List<InstanceObject> allInstances;
    private List<InstanceObject> selectedInstances;
    private GridObject currentGrid;
    private LogInspectorMainWindow.UpdateSelectedInstances onSelectionChangeUpdate;

    public SelectInstancesTreePanel(GridObject gridObject, LogInspectorMainWindow.UpdateSelectedInstances updateSelectedInstances) {
        this.currentGrid = gridObject;
        this.onSelectionChangeUpdate = updateSelectedInstances;
        this.selectedInstances = new ArrayList<InstanceObject>();
        this.allInstances = new ArrayList<InstanceObject>();
        gridObject.getHosts().forEach(hostObject -> hostObject.getInstances().forEach(instanceObject -> {
            if (instanceObject.isAppliedToCurrent()) {
                this.allInstances.add((InstanceObject)instanceObject);
            }
        }));
        this.initGUI();
    }

    public List<InstanceObject> getAllInstances() {
        return this.allInstances;
    }

    public List<InstanceObject> getSelectedInstances() {
        return this.selectedInstances;
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.popup = new JPopupMenu();
        this.moveMenu = new JMenuItem(Messages.getString("TimesTenGrid.LogLoadUnload"));
        this.popup.add(this.moveMenu);
        this.moveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block0: for (int n : SelectInstancesTreePanel.this._instancesTree.getSelectionRows()) {
                    IconNode iconNode = (IconNode)SelectInstancesTreePanel.this._instancesTree.getPathForRow(n).getLastPathComponent();
                    if ((IconNode)SelectInstancesTreePanel.this._instancesTree.getPathForRow(n).getParentPath().getLastPathComponent() == SelectInstancesTreePanel.this.selected) {
                        for (InstanceObject instanceObject : SelectInstancesTreePanel.this.allInstances) {
                            if (!instanceObject.getFullName().equalsIgnoreCase(iconNode.getName())) continue;
                            SelectInstancesTreePanel.this.selectedInstances.remove(instanceObject);
                            SelectInstancesTreePanel.this.selected.remove(iconNode);
                            if (!instanceObject.isAppliedToCurrent()) continue block0;
                            SelectInstancesTreePanel.this.notSelected.add(iconNode);
                            continue block0;
                        }
                        continue;
                    }
                    for (InstanceObject instanceObject : SelectInstancesTreePanel.this.allInstances) {
                        if (!instanceObject.getFullName().equalsIgnoreCase(iconNode.getName())) continue;
                        SelectInstancesTreePanel.this.selectedInstances.add(instanceObject);
                        SelectInstancesTreePanel.this.notSelected.remove(iconNode);
                        SelectInstancesTreePanel.this.selected.add(iconNode);
                        continue block0;
                    }
                }
                SelectInstancesTreePanel.this.onSelectionChangeUpdate.update(SelectInstancesTreePanel.this.selectedInstances, false);
                SelectInstancesTreePanel.this._model.reload();
                SelectInstancesTreePanel.this.expandTree();
            }
        });
        this.root = new IconNode(Messages.getString("TimesTenGrid.instances"), true, OracleIcons.getIcon((String)"folder.png"));
        this.selected = new IconNode(Messages.getString("TimesTenGrid.LogShowLogs"), true, OracleIcons.getIcon((String)"folder.png"));
        this.notSelected = new IconNode(Messages.getString("TimesTenGrid.LogAvailInst"), true, OracleIcons.getIcon((String)"folder.png"));
        this._model = new DefaultTreeModel(this.root);
        this.root.add(this.selected);
        this.root.add(this.notSelected);
        this._instancesTree = new JTree(this._model){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) == -1) {
                    return null;
                }
                TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                return ((DefaultMutableTreeNode)treePath.getLastPathComponent()).toString();
            }

            @Override
            public void collapsePath(TreePath treePath) {
            }
        };
        this._instancesTree.setToolTipText("");
        this._instancesTree.getSelectionModel().setSelectionMode(4);
        for (HostObject hostObject : this.currentGrid.getHosts()) {
            for (InstanceObject instanceObject : hostObject.getInstances()) {
                if (!instanceObject.isAppliedToCurrent()) continue;
                IconNode iconNode = new IconNode(instanceObject.getFullName(), false, OracleIcons.getIcon((String)"laptop.png"));
                if (this.selectedInstances.contains(instanceObject)) {
                    this.selected.add(iconNode);
                    continue;
                }
                this.notSelected.add(iconNode);
            }
        }
        this.expandTree();
        this._instancesTree.setCellRenderer(new IconNodeRenderer());
        this._instancesTree.addMouseListener(this);
        this._treeScrollPane = new JScrollPane(this._instancesTree);
        this.add((Component)this._treeScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 19, 1, new Insets(5, 5, 5, 5), 20, 20));
    }

    public void addLocalLogAsInstanceNode(InstanceObject instanceObject) {
        IconNode iconNode = new IconNode(instanceObject.getFullName(), false, OracleIcons.getIcon((String)"laptop.png"));
        this.allInstances.add(instanceObject);
        this.selectedInstances.add(instanceObject);
        this.selected.add(iconNode);
        this._model.reload();
    }

    private void expandTree() {
        for (int i = 0; i < this._instancesTree.getRowCount(); ++i) {
            this._instancesTree.expandRow(i);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2;
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            int n3 = mouseEvent.getX();
            int n4 = mouseEvent.getY();
            this.popup.show(this._instancesTree, n3, n4);
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && this._instancesTree.getPathForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY()) != null) {
            IconNode iconNode = (IconNode)this._instancesTree.getPathForLocation(n2, n).getLastPathComponent();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class IconNode
    extends DefaultMutableTreeNode {
        private Icon icon;
        private String name;

        public IconNode(Object object, boolean bl, Icon icon) {
            super(object, bl);
            this.icon = icon;
            this.name = object.toString();
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }
    }

    private class IconNodeRenderer
    extends DefaultTreeCellRenderer {
        private IconNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(((IconNode)object).getIcon());
            this.setText(((IconNode)object).getName());
            return this;
        }
    }
}

